/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.factoryBoard;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.codecs.CatnipCodecs;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSetItemMenu;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.zurrtum.create.content.logistics.factoryBoard.PanelSlot;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.content.logistics.packager.PackagingRequest;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.zurrtum.create.content.logistics.packagerLink.LogisticsManager;
import com.zurrtum.create.content.logistics.packagerLink.RequestPromise;
import com.zurrtum.create.content.logistics.packagerLink.RequestPromiseQueue;
import com.zurrtum.create.content.logistics.stockTicker.PackageOrder;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.s2c.FactoryPanelEffectPacket;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class ServerFactoryPanelBehaviour
extends ServerFilteringBehaviour
implements MenuProvider {
    private static final Codec<Set<FactoryPanelPosition>> TARGET_CODEC = CatnipCodecs.set(FactoryPanelPosition.CODEC);
    private static final Codec<List<BigItemStack>> CRAFTING_LIST_CODEC = BigItemStack.CODEC.listOf();
    public static final BehaviourType<ServerFactoryPanelBehaviour> TOP_LEFT = new BehaviourType();
    public static final BehaviourType<ServerFactoryPanelBehaviour> TOP_RIGHT = new BehaviourType();
    public static final BehaviourType<ServerFactoryPanelBehaviour> BOTTOM_LEFT = new BehaviourType();
    public static final BehaviourType<ServerFactoryPanelBehaviour> BOTTOM_RIGHT = new BehaviourType();
    public Map<FactoryPanelPosition, FactoryPanelConnection> targetedBy;
    public Map<BlockPos, FactoryPanelConnection> targetedByLinks;
    public Set<FactoryPanelPosition> targeting;
    public List<ItemStack> activeCraftingArrangement;
    public List<BigItemStack> craftingList;
    public boolean satisfied;
    public boolean promisedSatisfied;
    public boolean waitingForNetwork;
    public String recipeAddress;
    public int recipeOutput;
    public LerpedFloat bulb;
    public PanelSlot slot;
    public int promiseClearingInterval;
    public boolean forceClearPromises;
    public UUID network;
    public boolean active;
    public boolean redstonePowered;
    public RequestPromiseQueue restockerPromises;
    private boolean promisePrimedForMarkDirty;
    private int lastReportedUnloadedLinks;
    private int lastReportedLevelInStorage;
    private int lastReportedPromises;
    private int timer;

    public ServerFactoryPanelBehaviour(FactoryPanelBlockEntity be, PanelSlot slot) {
        super(be);
        this.slot = slot;
        this.targetedBy = new HashMap<FactoryPanelPosition, FactoryPanelConnection>();
        this.targetedByLinks = new HashMap<BlockPos, FactoryPanelConnection>();
        this.targeting = new HashSet<FactoryPanelPosition>();
        this.count = 0;
        this.satisfied = false;
        this.promisedSatisfied = false;
        this.waitingForNetwork = false;
        this.activeCraftingArrangement = List.of();
        this.recipeAddress = "";
        this.recipeOutput = 1;
        this.active = false;
        this.forceClearPromises = false;
        this.redstonePowered = false;
        this.promiseClearingInterval = -1;
        this.bulb = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.175, LerpedFloat.Chaser.EXP);
        this.restockerPromises = new RequestPromiseQueue(() -> ((FactoryPanelBlockEntity)be).setChanged());
        this.promisePrimedForMarkDirty = true;
        this.network = UUID.randomUUID();
        this.setLazyTickRate(40);
    }

    public void setNetwork(UUID network) {
        this.network = network;
    }

    @Nullable
    public static ServerFactoryPanelBehaviour at(BlockAndTintGetter world, FactoryPanelConnection connection) {
        Object cached = connection.cachedSource.get();
        if (cached instanceof ServerFactoryPanelBehaviour) {
            ServerFactoryPanelBehaviour fbe = (ServerFactoryPanelBehaviour)cached;
            if (!fbe.blockEntity.isRemoved()) {
                return fbe;
            }
        }
        ServerFactoryPanelBehaviour result = ServerFactoryPanelBehaviour.at(world, connection.from);
        connection.cachedSource = new WeakReference<ServerFactoryPanelBehaviour>(result);
        return result;
    }

    @Nullable
    public static ServerFactoryPanelBehaviour at(BlockAndTintGetter world, FactoryPanelPosition pos) {
        Level l;
        if (world instanceof Level && !(l = (Level)world).isLoaded(pos.pos())) {
            return null;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos.pos());
        if (!(blockEntity instanceof FactoryPanelBlockEntity)) {
            return null;
        }
        FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)blockEntity;
        ServerFactoryPanelBehaviour behaviour = fpbe.panels.get((Object)pos.slot());
        if (!behaviour.active) {
            return null;
        }
        return behaviour;
    }

    @Nullable
    public static FactoryPanelSupportBehaviour linkAt(BlockAndTintGetter world, FactoryPanelConnection connection) {
        Object cached = connection.cachedSource.get();
        if (cached instanceof FactoryPanelSupportBehaviour) {
            FactoryPanelSupportBehaviour fpsb = (FactoryPanelSupportBehaviour)cached;
            if (!fpsb.blockEntity.isRemoved()) {
                return fpsb;
            }
        }
        FactoryPanelSupportBehaviour result = ServerFactoryPanelBehaviour.linkAt(world, connection.from);
        connection.cachedSource = new WeakReference<FactoryPanelSupportBehaviour>(result);
        return result;
    }

    @Nullable
    public static FactoryPanelSupportBehaviour linkAt(BlockAndTintGetter world, FactoryPanelPosition pos) {
        Level l;
        if (world instanceof Level && !(l = (Level)world).isLoaded(pos.pos())) {
            return null;
        }
        return BlockEntityBehaviour.get((BlockGetter)world, pos.pos(), FactoryPanelSupportBehaviour.TYPE);
    }

    public void moveTo(FactoryPanelPosition newPos, ServerPlayer player) {
        BlockEntityBehaviour at;
        FactoryPanelBlockEntity fpbe;
        Level level = this.getLevel();
        BlockState existingState = level.getBlockState(newPos.pos());
        if (ServerFactoryPanelBehaviour.at((BlockAndTintGetter)level, newPos) != null) {
            return;
        }
        boolean isAddedToOtherGauge = existingState.is((Block)AllBlocks.FACTORY_GAUGE);
        if (!existingState.isAir() && !isAddedToOtherGauge) {
            return;
        }
        if (isAddedToOtherGauge && existingState != this.blockEntity.getBlockState()) {
            return;
        }
        if (!isAddedToOtherGauge) {
            level.setBlock(newPos.pos(), this.blockEntity.getBlockState(), 3);
        }
        for (BlockPos blockPos : this.targetedByLinks.keySet()) {
            if (blockPos.closerThan((Vec3i)newPos.pos(), 24.0)) continue;
            return;
        }
        for (FactoryPanelPosition factoryPanelPosition : this.targetedBy.keySet()) {
            if (factoryPanelPosition.pos().closerThan((Vec3i)newPos.pos(), 24.0)) continue;
            return;
        }
        for (FactoryPanelPosition factoryPanelPosition : this.targeting) {
            if (factoryPanelPosition.pos().closerThan((Vec3i)newPos.pos(), 24.0)) continue;
            return;
        }
        for (BlockPos blockPos : this.targetedByLinks.keySet()) {
            FactoryPanelSupportBehaviour at2 = ServerFactoryPanelBehaviour.linkAt((BlockAndTintGetter)level, new FactoryPanelPosition(blockPos, this.slot));
            if (at2 == null) continue;
            at2.disconnect(this);
        }
        SmartBlockEntity oldBE = this.blockEntity;
        FactoryPanelPosition factoryPanelPosition = this.getPanelPosition();
        this.moveToSlot(newPos.slot());
        BlockEntity blockEntity = level.getBlockEntity(newPos.pos());
        if (blockEntity instanceof FactoryPanelBlockEntity) {
            fpbe = (FactoryPanelBlockEntity)blockEntity;
            fpbe.attachBehaviourLate(this);
            fpbe.panels.put(this.slot, this);
            fpbe.redraw = true;
            fpbe.lastShape = null;
            fpbe.notifyUpdate();
        }
        if (oldBE instanceof FactoryPanelBlockEntity) {
            fpbe = (FactoryPanelBlockEntity)oldBE;
            ServerFactoryPanelBehaviour newBehaviour = new ServerFactoryPanelBehaviour(fpbe, factoryPanelPosition.slot());
            fpbe.attachBehaviourLate(newBehaviour);
            fpbe.panels.put(factoryPanelPosition.slot(), newBehaviour);
            fpbe.redraw = true;
            fpbe.lastShape = null;
            fpbe.notifyUpdate();
        }
        for (FactoryPanelPosition position : this.targeting) {
            at = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)level, position);
            if (at == null) continue;
            FactoryPanelConnection connection = ((ServerFactoryPanelBehaviour)at).targetedBy.remove(factoryPanelPosition);
            connection.from = newPos;
            ((ServerFactoryPanelBehaviour)at).targetedBy.put(newPos, connection);
            ((ServerFactoryPanelBehaviour)at).blockEntity.sendData();
        }
        for (FactoryPanelPosition position : this.targetedBy.keySet()) {
            at = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)level, position);
            if (at == null) continue;
            ((ServerFactoryPanelBehaviour)at).targeting.remove(factoryPanelPosition);
            ((ServerFactoryPanelBehaviour)at).targeting.add(newPos);
        }
        for (BlockPos pos : this.targetedByLinks.keySet()) {
            at = ServerFactoryPanelBehaviour.linkAt((BlockAndTintGetter)level, new FactoryPanelPosition(pos, this.slot));
            if (at == null) continue;
            ((FactoryPanelSupportBehaviour)at).connect(this);
        }
        player.displayClientMessage((Component)Component.translatable((String)"create.factory_panel.relocated").withStyle(ChatFormatting.GREEN), true);
        player.level().playSound(null, newPos.pos(), SoundEvents.COPPER_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void moveToSlot(PanelSlot slot) {
        this.slot = slot;
        if (this.getLevel().isClientSide()) {
            AllClientHandle.INSTANCE.factoryPanelMoveToSlot(this.blockEntity, slot);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.notifyRedstoneOutputs();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getLevel().isClientSide()) {
            if (this.blockEntity.isVirtual()) {
                this.tickStorageMonitor();
            }
            this.bulb.updateChaseTarget(this.redstonePowered || this.satisfied ? 1.0f : 0.0f);
            this.bulb.tickChaser();
            return;
        }
        if (!this.promisePrimedForMarkDirty) {
            this.restockerPromises.setOnChanged(() -> ((SmartBlockEntity)this.blockEntity).setChanged());
            this.promisePrimedForMarkDirty = true;
        }
        this.tickStorageMonitor();
        this.tickRequests();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.getLevel().isClientSide()) {
            return;
        }
        this.checkForRedstoneInput();
    }

    public void checkForRedstoneInput() {
        if (!this.active) {
            return;
        }
        boolean shouldPower = false;
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            if (!this.getLevel().isLoaded(connection.from.pos())) {
                return;
            }
            FactoryPanelSupportBehaviour linkAt = ServerFactoryPanelBehaviour.linkAt((BlockAndTintGetter)this.getLevel(), connection);
            if (linkAt == null) {
                return;
            }
            shouldPower |= linkAt.shouldPanelBePowered();
        }
        if (shouldPower == this.redstonePowered) {
            return;
        }
        this.redstonePowered = shouldPower;
        this.blockEntity.notifyUpdate();
        this.timer = 1;
    }

    private void notifyRedstoneOutputs() {
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            if (!this.getLevel().isLoaded(connection.from.pos())) {
                return;
            }
            FactoryPanelSupportBehaviour linkAt = ServerFactoryPanelBehaviour.linkAt((BlockAndTintGetter)this.getLevel(), connection);
            if (linkAt == null || linkAt.isOutput()) {
                return;
            }
            linkAt.notifyLink();
        }
    }

    private void tickStorageMonitor() {
        boolean shouldWait;
        ItemStack filter = this.getFilter();
        int inStorage = this.getLevelInStorage();
        int promised = this.getPromised();
        int demand = this.getAmount() * (this.upTo ? 1 : filter.getMaxStackSize());
        int unloadedLinkCount = this.getUnloadedLinks();
        boolean shouldSatisfy = filter.isEmpty() || inStorage >= demand;
        boolean shouldPromiseSatisfy = filter.isEmpty() || inStorage + promised >= demand;
        boolean bl = shouldWait = unloadedLinkCount > 0;
        if (this.lastReportedLevelInStorage == inStorage && this.lastReportedPromises == promised && this.lastReportedUnloadedLinks == unloadedLinkCount && this.satisfied == shouldSatisfy && this.promisedSatisfied == shouldPromiseSatisfy && this.waitingForNetwork == shouldWait) {
            return;
        }
        if (!this.satisfied && shouldSatisfy && demand > 0) {
            AllSoundEvents.CONFIRM.playOnServer(this.getLevel(), (Vec3i)this.getPos(), 0.075f, 1.0f);
            AllSoundEvents.CONFIRM_2.playOnServer(this.getLevel(), (Vec3i)this.getPos(), 0.125f, 0.575f);
        }
        boolean notifyOutputs = this.satisfied != shouldSatisfy;
        this.lastReportedLevelInStorage = inStorage;
        this.satisfied = shouldSatisfy;
        this.lastReportedPromises = promised;
        this.promisedSatisfied = shouldPromiseSatisfy;
        this.lastReportedUnloadedLinks = unloadedLinkCount;
        this.waitingForNetwork = shouldWait;
        if (!this.getLevel().isClientSide()) {
            this.blockEntity.sendData();
        }
        if (notifyOutputs) {
            this.notifyRedstoneOutputs();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void tickRequests() {
        FactoryPanelBlockEntity panelBE = this.panelBE();
        if (this.targetedBy.isEmpty() && !panelBE.restocker) {
            return;
        }
        if (panelBE.restocker) {
            this.restockerPromises.tick();
        }
        if (this.satisfied || this.promisedSatisfied || this.waitingForNetwork || this.redstonePowered) {
            return;
        }
        if (this.timer > 0) {
            this.timer = Math.min((int)this.timer, (int)this.getConfigRequestIntervalInTicks());
            --this.timer;
            return;
        }
        this.resetTimer();
        if (this.recipeAddress.isBlank()) {
            return;
        }
        if (panelBE.restocker) {
            this.tryRestock();
            return;
        }
        boolean failed = false;
        HashMap<UUID, Map> consolidated = new HashMap<UUID, Map>();
        for (FactoryPanelConnection factoryPanelConnection : this.targetedBy.values()) {
            ServerFactoryPanelBehaviour serverFactoryPanelBehaviour = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)this.getLevel(), factoryPanelConnection);
            if (serverFactoryPanelBehaviour == null) {
                return;
            }
            ItemStack item = serverFactoryPanelBehaviour.getFilter();
            Map networkItemCounts = consolidated.computeIfAbsent(serverFactoryPanelBehaviour.network, $ -> new Object2ObjectOpenCustomHashMap(ItemStackLinkedSet.TYPE_AND_TAG));
            networkItemCounts.computeIfAbsent(item, $ -> new ItemStackConnections(item));
            ItemStackConnections itemStackConnections = (ItemStackConnections)networkItemCounts.get(item);
            itemStackConnections.add(factoryPanelConnection);
            itemStackConnections.totalAmount += factoryPanelConnection.amount;
        }
        HashMultimap toRequest = HashMultimap.create();
        for (Map.Entry entry : consolidated.entrySet()) {
            UUID network = (UUID)entry.getKey();
            Iterator summary = LogisticsManager.getSummaryOfNetwork(network, true);
            for (ItemStackConnections connections : ((Map)entry.getValue()).values()) {
                if (connections.totalAmount == 0 || connections.item.isEmpty() || ((InventorySummary)((Object)summary)).getCountOf(connections.item) < connections.totalAmount) {
                    for (FactoryPanelConnection connection : connections) {
                        this.sendEffect(connection.from, false);
                    }
                    failed = true;
                    continue;
                }
                BigItemStack stack2 = new BigItemStack(connections.item, connections.totalAmount);
                toRequest.put((Object)network, (Object)stack2);
                for (FactoryPanelConnection connection : connections) {
                    this.sendEffect(connection.from, true);
                }
            }
        }
        if (failed) {
            return;
        }
        Map map = toRequest.asMap();
        PackageOrderWithCrafts packageOrderWithCrafts = PackageOrderWithCrafts.empty();
        ArrayList<Multimap<PackagerBlockEntity, PackagingRequest>> requests = new ArrayList<Multimap<PackagerBlockEntity, PackagingRequest>>();
        if (!this.activeCraftingArrangement.isEmpty()) {
            PackageOrderWithCrafts packageOrderWithCrafts2 = PackageOrderWithCrafts.singleRecipe(this.activeCraftingArrangement.stream().map(stack -> new BigItemStack(stack.copyWithCount(1))).toList());
        }
        for (Map.Entry entry : map.entrySet()) {
            void var6_13;
            PackageOrderWithCrafts order = new PackageOrderWithCrafts(new PackageOrder(new ArrayList<BigItemStack>((Collection)entry.getValue())), var6_13.orderedCrafts());
            Multimap<PackagerBlockEntity, PackagingRequest> request = LogisticsManager.findPackagersForRequest((UUID)entry.getKey(), order, null, this.recipeAddress);
            requests.add(request);
        }
        for (Multimap multimap : requests) {
            for (PackagerBlockEntity packager : multimap.keySet()) {
                if (!packager.isTooBusyFor(LogisticallyLinkedBehaviour.RequestType.RESTOCK)) continue;
                return;
            }
        }
        for (Multimap multimap : requests) {
            LogisticsManager.performPackageRequests((Multimap<PackagerBlockEntity, PackagingRequest>)multimap);
        }
        RequestPromiseQueue promises = Create.LOGISTICS.getQueuedPromises(this.network);
        if (promises != null) {
            promises.add(new RequestPromise(new BigItemStack(this.getFilter(), this.recipeOutput)));
        }
        panelBE.award(AllAdvancements.FACTORY_GAUGE);
    }

    private void tryRestock() {
        ItemStack item = this.getFilter();
        if (item.isEmpty()) {
            return;
        }
        FactoryPanelBlockEntity panelBE = this.panelBE();
        PackagerBlockEntity packager = panelBE.getRestockedPackager();
        if (packager == null || !packager.targetInventory.hasInventory()) {
            return;
        }
        int availableOnNetwork = LogisticsManager.getStockOf(this.network, item, packager.targetInventory.getIdentifiedInventory());
        if (availableOnNetwork == 0) {
            this.sendEffect(this.getPanelPosition(), false);
            return;
        }
        int inStorage = this.getLevelInStorage();
        int promised = this.getPromised();
        int maxStackSize = item.getMaxStackSize();
        int demand = this.getAmount() * (this.upTo ? 1 : maxStackSize);
        int amountToOrder = Math.clamp((int)(demand - promised - inStorage), (int)0, (int)(maxStackSize * 9));
        BigItemStack orderedItem = new BigItemStack(item, Math.min((int)amountToOrder, (int)availableOnNetwork));
        PackageOrderWithCrafts order = PackageOrderWithCrafts.simple(List.of(orderedItem));
        this.sendEffect(this.getPanelPosition(), true);
        if (!LogisticsManager.broadcastPackageRequest(this.network, LogisticallyLinkedBehaviour.RequestType.RESTOCK, order, packager.targetInventory.getIdentifiedInventory(), this.recipeAddress)) {
            return;
        }
        this.restockerPromises.add(new RequestPromise(orderedItem));
    }

    private void sendEffect(FactoryPanelPosition fromPos, boolean success) {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.getPos();
            serverLevel.getServer().getPlayerList().broadcast(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 64.0, serverLevel.dimension(), (Packet)new FactoryPanelEffectPacket(fromPos, this.getPanelPosition(), success));
        }
    }

    public void addConnection(FactoryPanelPosition fromPos) {
        FactoryPanelSupportBehaviour link = ServerFactoryPanelBehaviour.linkAt((BlockAndTintGetter)this.getLevel(), fromPos);
        if (link != null) {
            this.targetedByLinks.put(fromPos.pos(), new FactoryPanelConnection(fromPos, 1));
            link.connect(this);
            this.blockEntity.notifyUpdate();
            return;
        }
        if (this.panelBE().restocker) {
            return;
        }
        if (this.targetedBy.size() >= 9) {
            return;
        }
        ServerFactoryPanelBehaviour source = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)this.getLevel(), fromPos);
        if (source == null) {
            return;
        }
        source.targeting.add(this.getPanelPosition());
        this.targetedBy.put(fromPos, new FactoryPanelConnection(fromPos, 1));
        this.searchForCraftingRecipe();
        this.blockEntity.notifyUpdate();
    }

    public FactoryPanelPosition getPanelPosition() {
        return new FactoryPanelPosition(this.getPos(), this.slot);
    }

    public FactoryPanelBlockEntity panelBE() {
        return (FactoryPanelBlockEntity)this.blockEntity;
    }

    @Override
    public void onShortInteract(Player player, InteractionHand hand, Direction side, BlockHitResult hitResult) {
        if (!Create.LOGISTICS.mayInteract(this.network, player)) {
            player.displayClientMessage((Component)Component.translatable((String)"create.logistically_linked.protected").withStyle(ChatFormatting.RED), true);
            return;
        }
        boolean isClientSide = player.level().isClientSide();
        ItemStack heldItem = player.getItemInHand(hand);
        if (this.targeting.size() + this.targetedByLinks.size() > 0 && heldItem.is(AllItemTags.TOOLS_WRENCH)) {
            int sharedMode = -1;
            boolean notifySelf = false;
            for (FactoryPanelPosition target : this.targeting) {
                FactoryPanelConnection connection;
                ServerFactoryPanelBehaviour at = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)this.getLevel(), target);
                if (at == null || (connection = at.targetedBy.get(this.getPanelPosition())) == null) continue;
                if (sharedMode == -1) {
                    sharedMode = (connection.arrowBendMode + 1) % 4;
                }
                connection.arrowBendMode = sharedMode;
                if (isClientSide) continue;
                at.blockEntity.notifyUpdate();
            }
            for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
                if (sharedMode == -1) {
                    sharedMode = (connection.arrowBendMode + 1) % 4;
                }
                connection.arrowBendMode = sharedMode;
                if (isClientSide) continue;
                notifySelf = true;
            }
            if (sharedMode == -1) {
                return;
            }
            char[] boxes = "\u25a1\u25a1\u25a1\u25a1".toCharArray();
            boxes[sharedMode] = 9632;
            player.displayClientMessage((Component)Component.translatable((String)"create.factory_panel.cycled_arrow_path", (Object[])new Object[]{new String(boxes)}), true);
            if (notifySelf) {
                this.blockEntity.notifyUpdate();
            }
            return;
        }
        if (isClientSide && AllClientHandle.INSTANCE.factoryPanelClicked(this.getLevel(), player, this)) {
            return;
        }
        if (this.getFilter().isEmpty()) {
            if (heldItem.isEmpty()) {
                if (!isClientSide && player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    this.openHandledScreen(sp);
                }
                return;
            }
            super.onShortInteract(player, hand, side, hitResult);
            return;
        }
        if (heldItem.getItem() instanceof LogisticallyLinkedBlockItem) {
            if (!isClientSide) {
                LogisticallyLinkedBlockItem.assignFrequency(heldItem, player, this.network);
            }
            return;
        }
        if (isClientSide) {
            AllClientHandle.INSTANCE.openFactoryPanelScreen(this, player);
        }
    }

    public void enable() {
        this.active = true;
        this.blockEntity.notifyUpdate();
    }

    public void disable() {
        this.destroy();
        this.active = false;
        this.targetedBy = new HashMap<FactoryPanelPosition, FactoryPanelConnection>();
        this.targeting = new HashSet<FactoryPanelPosition>();
        this.count = 0;
        this.satisfied = false;
        this.promisedSatisfied = false;
        this.recipeAddress = "";
        this.recipeOutput = 1;
        this.setFilter(ItemStack.EMPTY);
        this.blockEntity.notifyUpdate();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public boolean isMissingAddress() {
        return (!this.targetedBy.isEmpty() || this.panelBE().restocker) && this.count != 0 && this.recipeAddress.isBlank();
    }

    @Override
    public void destroy() {
        this.disconnectAll();
        super.destroy();
    }

    public void disconnectAll() {
        FactoryPanelPosition panelPosition = this.getPanelPosition();
        this.disconnectAllLinks();
        for (FactoryPanelConnection connection : this.targetedBy.values()) {
            ServerFactoryPanelBehaviour source = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)this.getLevel(), connection);
            if (source == null) continue;
            source.targeting.remove(panelPosition);
            source.blockEntity.sendData();
        }
        for (FactoryPanelPosition position : this.targeting) {
            ServerFactoryPanelBehaviour target = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)this.getLevel(), position);
            if (target == null) continue;
            target.targetedBy.remove(panelPosition);
            target.searchForCraftingRecipe();
            target.blockEntity.sendData();
        }
        this.targetedBy.clear();
        this.targeting.clear();
    }

    public void disconnectAllLinks() {
        for (FactoryPanelConnection connection : this.targetedByLinks.values()) {
            FactoryPanelSupportBehaviour source = ServerFactoryPanelBehaviour.linkAt((BlockAndTintGetter)this.getLevel(), connection);
            if (source == null) continue;
            source.disconnect(this);
        }
        this.targetedByLinks.clear();
    }

    public int getUnloadedLinks() {
        if (this.getLevel().isClientSide()) {
            return this.lastReportedUnloadedLinks;
        }
        if (this.panelBE().restocker) {
            return this.panelBE().getRestockedPackager() == null ? 1 : 0;
        }
        return Create.LOGISTICS.getUnloadedLinkCount(this.network);
    }

    public int getLevelInStorage() {
        if (this.blockEntity.isVirtual()) {
            return 1;
        }
        if (this.getLevel().isClientSide()) {
            return this.lastReportedLevelInStorage;
        }
        if (this.getFilter().isEmpty()) {
            return 0;
        }
        InventorySummary summary = this.getRelevantSummary();
        return summary.getCountOf(this.getFilter());
    }

    private InventorySummary getRelevantSummary() {
        FactoryPanelBlockEntity panelBE = this.panelBE();
        if (!panelBE.restocker) {
            return LogisticsManager.getSummaryOfNetwork(this.network, false);
        }
        PackagerBlockEntity packager = panelBE.getRestockedPackager();
        if (packager == null) {
            return InventorySummary.EMPTY;
        }
        return packager.getAvailableItems();
    }

    public int getPromised() {
        if (this.getLevel().isClientSide()) {
            return this.lastReportedPromises;
        }
        ItemStack item = this.getFilter();
        if (item.isEmpty()) {
            return 0;
        }
        if (this.panelBE().restocker) {
            if (this.forceClearPromises) {
                this.restockerPromises.forceClear(item);
                this.resetTimerSlightly();
            }
            this.forceClearPromises = false;
            return this.restockerPromises.getTotalPromisedAndRemoveExpired(item, this.getPromiseExpiryTimeInTicks());
        }
        RequestPromiseQueue promises = Create.LOGISTICS.getQueuedPromises(this.network);
        if (promises == null) {
            return 0;
        }
        if (this.forceClearPromises) {
            promises.forceClear(item);
            this.resetTimerSlightly();
        }
        this.forceClearPromises = false;
        return promises.getTotalPromisedAndRemoveExpired(item, this.getPromiseExpiryTimeInTicks());
    }

    public void resetTimer() {
        this.timer = this.getConfigRequestIntervalInTicks();
    }

    public void resetTimerSlightly() {
        this.timer = this.getConfigRequestIntervalInTicks() / 2;
    }

    private int getConfigRequestIntervalInTicks() {
        return (Integer)AllConfigs.server().logistics.factoryGaugeTimer.get();
    }

    private int getPromiseExpiryTimeInTicks() {
        if (this.promiseClearingInterval == -1) {
            return -1;
        }
        if (this.promiseClearingInterval == 0) {
            return 600;
        }
        return this.promiseClearingInterval * 20 * 60;
    }

    @Override
    public void writeSafe(ValueOutput view) {
        if (!this.active) {
            return;
        }
        ValueOutput panelTag = view.child(this.slot.name().toLowerCase(Locale.ROOT));
        panelTag.store("Filter", FilterItemStack.CODEC, (Object)this.filter);
        panelTag.putBoolean("UpTo", this.upTo);
        panelTag.putInt("FilterAmount", this.count);
        panelTag.store("Freq", UUIDUtil.CODEC, (Object)this.network);
        panelTag.putString("RecipeAddress", this.recipeAddress);
        panelTag.putInt("PromiseClearingInterval", -1);
        panelTag.putInt("RecipeOutput", 1);
        if (this.panelBE().restocker) {
            panelTag.store("Promises", RequestPromiseQueue.CODEC, (Object)this.restockerPromises);
        }
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        if (!this.active) {
            return;
        }
        ValueOutput panelTag = view.child(this.slot.name().toLowerCase(Locale.ROOT));
        super.write(panelTag, clientPacket);
        panelTag.putInt("Timer", this.timer);
        panelTag.putInt("LastLevel", this.lastReportedLevelInStorage);
        panelTag.putInt("LastPromised", this.lastReportedPromises);
        panelTag.putInt("LastUnloadedLinks", this.lastReportedUnloadedLinks);
        panelTag.putBoolean("Satisfied", this.satisfied);
        panelTag.putBoolean("PromisedSatisfied", this.promisedSatisfied);
        panelTag.putBoolean("Waiting", this.waitingForNetwork);
        panelTag.putBoolean("RedstonePowered", this.redstonePowered);
        panelTag.store("Targeting", TARGET_CODEC, this.targeting);
        ValueOutput.TypedOutputList targetedByList = panelTag.list("TargetedBy", FactoryPanelConnection.CODEC);
        this.targetedBy.values().forEach(arg_0 -> ((ValueOutput.TypedOutputList)targetedByList).add(arg_0));
        ValueOutput.TypedOutputList targetedByLinkList = panelTag.list("TargetedByLinks", FactoryPanelConnection.CODEC);
        this.targetedByLinks.values().forEach(arg_0 -> ((ValueOutput.TypedOutputList)targetedByLinkList).add(arg_0));
        panelTag.putString("RecipeAddress", this.recipeAddress);
        panelTag.putInt("RecipeOutput", this.recipeOutput);
        panelTag.putInt("PromiseClearingInterval", this.promiseClearingInterval);
        panelTag.store("Freq", UUIDUtil.CODEC, (Object)this.network);
        panelTag.store("Craft", CreateCodecs.ITEM_LIST_CODEC, this.activeCraftingArrangement);
        if (this.craftingList != null) {
            panelTag.store("CraftingList", CRAFTING_LIST_CODEC, this.craftingList);
        }
        if (this.panelBE().restocker && !clientPacket) {
            panelTag.store("Promises", RequestPromiseQueue.CODEC, (Object)this.restockerPromises);
        }
    }

    @Override
    public void read(ValueInput view, boolean clientPacket) {
        Optional slotView = view.child(this.slot.name().toLowerCase(Locale.ROOT));
        if (slotView.isEmpty()) {
            this.active = false;
            return;
        }
        ValueInput panelTag = (ValueInput)slotView.get();
        this.active = true;
        this.filter = panelTag.read("Filter", FilterItemStack.CODEC).orElseGet(FilterItemStack::empty);
        this.count = panelTag.getIntOr("FilterAmount", 0);
        this.upTo = panelTag.getBooleanOr("UpTo", false);
        this.timer = panelTag.getIntOr("Timer", 0);
        this.lastReportedLevelInStorage = panelTag.getIntOr("LastLevel", 0);
        this.lastReportedPromises = panelTag.getIntOr("LastPromised", 0);
        this.lastReportedUnloadedLinks = panelTag.getIntOr("LastUnloadedLinks", 0);
        this.satisfied = panelTag.getBooleanOr("Satisfied", false);
        this.promisedSatisfied = panelTag.getBooleanOr("PromisedSatisfied", false);
        this.waitingForNetwork = panelTag.getBooleanOr("Waiting", false);
        this.redstonePowered = panelTag.getBooleanOr("RedstonePowered", false);
        this.promiseClearingInterval = panelTag.getIntOr("PromiseClearingInterval", 0);
        panelTag.read("Freq", UUIDUtil.CODEC).ifPresent(uuid -> {
            this.network = uuid;
        });
        this.targeting.clear();
        panelTag.read("Targeting", TARGET_CODEC).ifPresent(this.targeting::addAll);
        this.targetedBy.clear();
        panelTag.listOrEmpty("TargetedBy", FactoryPanelConnection.CODEC).forEach(c -> this.targetedBy.put(c.from, (FactoryPanelConnection)c));
        this.targetedByLinks.clear();
        panelTag.listOrEmpty("TargetedByLinks", FactoryPanelConnection.CODEC).forEach(c -> this.targetedByLinks.put(c.from.pos(), (FactoryPanelConnection)c));
        this.activeCraftingArrangement = panelTag.read("Craft", CreateCodecs.ITEM_LIST_CODEC).orElseGet(List::of);
        this.recipeAddress = panelTag.getStringOr("RecipeAddress", "");
        this.recipeOutput = panelTag.getIntOr("RecipeOutput", 0);
        if (view.getBooleanOr("Restocker", false) && !clientPacket) {
            Optional queue = panelTag.read("Promises", RequestPromiseQueue.CODEC);
            if (queue.isPresent()) {
                this.restockerPromises = (RequestPromiseQueue)queue.get();
                this.restockerPromises.setOnChanged(() -> {});
            } else {
                this.restockerPromises = new RequestPromiseQueue(() -> {});
            }
            this.promisePrimedForMarkDirty = false;
        }
        this.craftingList = panelTag.read("CraftingList", CRAFTING_LIST_CODEC).orElse(null);
    }

    @Override
    public boolean setFilter(ItemStack stack) {
        ItemStack filter = stack.copy();
        if (stack.getItem() instanceof FilterItem) {
            return false;
        }
        this.filter = FilterItemStack.of(filter);
        this.searchForCraftingRecipe();
        this.blockEntity.setChanged();
        this.blockEntity.sendData();
        return true;
    }

    public void searchForCraftingRecipe() {
        Level level = this.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)level;
        ItemStack output = this.filter.item();
        if (output.isEmpty() || this.targetedBy.isEmpty()) {
            this.craftingList = null;
            return;
        }
        List<BigItemStack> inputConfig = this.targetedBy.values().stream().map(c -> {
            ServerFactoryPanelBehaviour b = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)serverWorld, c.from);
            return b == null ? new BigItemStack(ItemStack.EMPTY, 0) : new BigItemStack(b.getFilter(), c.amount);
        }).toList();
        Set itemsToUse = inputConfig.stream().map(b -> b.stack).filter(i -> !i.isEmpty()).map(ItemStack::getItem).collect(Collectors.toSet());
        Item item = output.getItem();
        RegistryAccess registryManager = serverWorld.registryAccess();
        CraftingRecipe availableCraftingRecipe = serverWorld.recipeAccess().recipes.byType(RecipeType.CRAFTING).parallelStream().filter(entry -> {
            List ingredients;
            CraftingRecipe recipe = (CraftingRecipe)entry.value();
            if (recipe instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                try {
                    result = recipe.assemble((RecipeInput)CraftingInput.EMPTY, (HolderLookup.Provider)registryManager);
                }
                catch (Exception ignore) {
                    result = ItemStack.EMPTY;
                }
                if (result.isEmpty() && ((result = shapedRecipe.result) == null || result.isEmpty())) {
                    return false;
                }
                if (result.getItem() != item) {
                    return false;
                }
                ingredients = shapedRecipe.getIngredients().stream().flatMap(Optional::stream).toList();
            } else if (recipe instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
                try {
                    result = recipe.assemble((RecipeInput)CraftingInput.EMPTY, (HolderLookup.Provider)registryManager);
                }
                catch (Exception ignore) {
                    result = ItemStack.EMPTY;
                }
                if (result.isEmpty() && ((result = shapelessRecipe.result) == null || result.isEmpty())) {
                    return false;
                }
                if (result.getItem() != item) {
                    return false;
                }
                ingredients = shapelessRecipe.ingredients;
            } else {
                return false;
            }
            if (AllRecipeTypes.shouldIgnoreInAutomation(entry)) {
                return false;
            }
            HashSet<Item> itemsUsed = new HashSet<Item>();
            for (Ingredient ingredient : ingredients) {
                if (ingredient.isEmpty()) continue;
                boolean available = false;
                for (BigItemStack bis : inputConfig) {
                    if (bis.stack.isEmpty() || !ingredient.test(bis.stack)) continue;
                    available = true;
                    itemsUsed.add(bis.stack.getItem());
                    break;
                }
                if (available) continue;
                return false;
            }
            return itemsUsed.size() >= itemsToUse.size();
        }).findAny().map(RecipeHolder::value).orElse(null);
        if (availableCraftingRecipe == null) {
            this.craftingList = null;
            return;
        }
        this.craftingList = ServerFactoryPanelBehaviour.convertRecipeToPackageOrderContext(availableCraftingRecipe, registryManager, inputConfig, false);
    }

    @Nullable
    public static List<BigItemStack> convertRecipeToPackageOrderContext(CraftingRecipe availableCraftingRecipe, RegistryAccess registryManager, List<BigItemStack> inputs, boolean respectAmounts) {
        List<Ingredient> ingredients;
        if (availableCraftingRecipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)availableCraftingRecipe;
            ingredients = shapedRecipe.getIngredients().stream().map(o -> o.orElse(null)).toList();
        } else if (availableCraftingRecipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)availableCraftingRecipe;
            ingredients = shapelessRecipe.ingredients;
        } else {
            return null;
        }
        ArrayList<BigItemStack> craftingList = new ArrayList<BigItemStack>();
        ItemStack output = availableCraftingRecipe.assemble((RecipeInput)CraftingInput.EMPTY, (HolderLookup.Provider)registryManager);
        int count = output.getCount();
        output.setCount(1);
        craftingList.add(new BigItemStack(output, count));
        BigItemStack emptyIngredient = new BigItemStack(ItemStack.EMPTY, 1);
        List<BigItemStack> mutableInputs = BigItemStack.duplicateWrappers(inputs);
        int width = Math.min((int)3, (int)ingredients.size());
        int height = Math.min((int)3, (int)(ingredients.size() / 3 + 1));
        if (availableCraftingRecipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)availableCraftingRecipe;
            width = shaped.getWidth();
            height = shaped.getHeight();
        }
        if (height == 1) {
            for (int i = 0; i < 3; ++i) {
                craftingList.add(emptyIngredient);
            }
        }
        if (width == 1) {
            craftingList.add(emptyIngredient);
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = ingredients.get(i);
            BigItemStack craftingIngredient = emptyIngredient;
            if (ingredient != null && !ingredient.isEmpty()) {
                for (BigItemStack bigItemStack : mutableInputs) {
                    if (bigItemStack.count <= 0 || !ingredient.test(bigItemStack.stack)) continue;
                    craftingIngredient = new BigItemStack(bigItemStack.stack, 1);
                    if (!respectAmounts) break;
                    --bigItemStack.count;
                    break;
                }
            }
            craftingList.add(craftingIngredient);
            if (width >= 3 || (i + 1) % width != 0) continue;
            for (int j = 0; j < 3 - width; ++j) {
                if (craftingList.size() >= 10) continue;
                craftingList.add(emptyIngredient);
            }
        }
        while (craftingList.size() < 10) {
            craftingList.add(emptyIngredient);
        }
        return craftingList;
    }

    @Override
    public void setValueSettings(Player player, ValueSettings settings, boolean ctrlDown) {
        if (this.getValueSettings().equals(settings)) {
            return;
        }
        this.count = Math.max((int)0, (int)settings.value());
        this.upTo = settings.row() == 0;
        this.panelBE().redraw = true;
        this.blockEntity.setChanged();
        this.blockEntity.sendData();
        this.playFeedbackSound(this);
        this.resetTimerSlightly();
        if (!this.getLevel().isClientSide()) {
            this.notifyRedstoneOutputs();
        }
    }

    @Override
    public ValueSettings getValueSettings() {
        return new ValueSettings(this.upTo ? 0 : 1, this.count);
    }

    @Override
    public int netId() {
        return 2 + this.slot.ordinal();
    }

    @Override
    public boolean isCountVisible() {
        return !this.getFilter().isEmpty();
    }

    @Override
    public BehaviourType<?> getType() {
        return ServerFactoryPanelBehaviour.getTypeForSlot(this.slot);
    }

    public static BehaviourType<ServerFactoryPanelBehaviour> getTypeForSlot(PanelSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case PanelSlot.BOTTOM_LEFT -> BOTTOM_LEFT;
            case PanelSlot.TOP_LEFT -> TOP_LEFT;
            case PanelSlot.TOP_RIGHT -> TOP_RIGHT;
            case PanelSlot.BOTTOM_RIGHT -> BOTTOM_RIGHT;
        };
    }

    public int getIngredientStatusColor() {
        return this.count == 0 || this.isMissingAddress() || this.redstonePowered ? 0x888898 : (this.waitingForNetwork ? 0x5B3B3B : (this.satisfied ? 10420095 : (this.promisedSatisfied ? 0x22AFAF : 4026045)));
    }

    @Override
    public ItemRequirement getRequiredItems() {
        return this.isActive() ? new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, AllBlocks.FACTORY_GAUGE.asItem()) : ItemRequirement.NONE;
    }

    @Override
    public boolean canShortInteract(ItemStack toApply) {
        return true;
    }

    @Override
    public boolean readFromClipboard(ValueInput view, Player player, Direction side, boolean simulate) {
        return false;
    }

    @Override
    public boolean canWrite(HolderLookup.Provider registries, Direction side) {
        return false;
    }

    @Override
    public boolean writeToClipboard(ValueOutput view, Direction side) {
        return false;
    }

    public FactoryPanelSetItemMenu createMenu(int containerId, Inventory playerInventory, Player player, RegistryFriendlyByteBuf extraData) {
        FactoryPanelPosition.PACKET_CODEC.encode((Object)extraData, (Object)this.getPanelPosition());
        return new FactoryPanelSetItemMenu(containerId, playerInventory, this);
    }

    @Override
    public Component getDisplayName() {
        return this.blockEntity.getBlockState().getBlock().getName();
    }

    public String getFrogAddress() {
        PackagerBlockEntity packager = this.panelBE().getRestockedPackager();
        if (packager == null) {
            return null;
        }
        BlockEntity blockEntity = packager.getLevel().getBlockEntity(packager.getBlockPos().above());
        if (blockEntity instanceof FrogportBlockEntity) {
            FrogportBlockEntity fpbe = (FrogportBlockEntity)blockEntity;
            if (fpbe.addressFilter != null && !fpbe.addressFilter.isBlank()) {
                return fpbe.addressFilter;
            }
        }
        return null;
    }

    public static class ItemStackConnections
    extends ArrayList<FactoryPanelConnection> {
        public ItemStack item;
        public int totalAmount;

        public ItemStackConnections(ItemStack item) {
            this.item = item;
        }
    }
}

