/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.filter;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.content.logistics.filter.AbstractFilterMenu;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class FilterMenu
extends AbstractFilterMenu {
    public boolean respectNBT;
    public boolean blacklist;

    public FilterMenu(int id, Inventory inv, ItemStack stack) {
        super(AllMenuTypes.FILTER, id, inv, stack);
    }

    @Override
    protected int getPlayerInventoryXOffset() {
        return 38;
    }

    @Override
    protected int getPlayerInventoryYOffset() {
        return 121;
    }

    @Override
    protected void addFilterSlots() {
        int x = 23;
        int y = 25;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)this.ghostInventory, col + row * 9, x + col * 18, y + row * 18));
            }
        }
    }

    @Override
    protected ItemStackHandler createGhostInventory() {
        return AllItems.FILTER.getFilterItemHandler((ItemStack)this.contentHolder);
    }

    @Override
    protected void initAndReadInventory(ItemStack filterItem) {
        super.initAndReadInventory(filterItem);
        this.respectNBT = (Boolean)filterItem.getOrDefault(AllDataComponents.FILTER_ITEMS_RESPECT_NBT, (Object)false);
        this.blacklist = (Boolean)filterItem.getOrDefault(AllDataComponents.FILTER_ITEMS_BLACKLIST, (Object)false);
    }

    @Override
    protected void saveData(ItemStack filterItem) {
        super.saveData(filterItem);
        filterItem.set(AllDataComponents.FILTER_ITEMS_RESPECT_NBT, (Object)this.respectNBT);
        filterItem.set(AllDataComponents.FILTER_ITEMS_BLACKLIST, (Object)this.blacklist);
        if (this.respectNBT || this.blacklist) {
            return;
        }
        if (!this.ghostInventory.isEmpty()) {
            return;
        }
        filterItem.remove(AllDataComponents.FILTER_ITEMS_RESPECT_NBT);
        filterItem.remove(AllDataComponents.FILTER_ITEMS_BLACKLIST);
    }
}

