/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.filter;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.logistics.filter.PackageFilterMenu;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class PackageFilterItem
extends FilterItem {
    protected PackageFilterItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public List<Component> makeSummary(ItemStack filter) {
        String address = PackageItem.getAddress(filter);
        if (address.isBlank()) {
            return Collections.emptyList();
        }
        return List.of(Component.literal((String)"-> ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)address).withStyle(ChatFormatting.GOLD)));
    }

    @Override
    @Nullable
    public MenuBase<?> createMenu(int id, Inventory inv, Player player, RegistryFriendlyByteBuf extraData) {
        ItemStack heldItem = player.getMainHandItem();
        ItemStack.STREAM_CODEC.encode((Object)extraData, (Object)heldItem);
        return new PackageFilterMenu(id, inv, heldItem);
    }

    @Override
    public DataComponentType<?> getComponentType() {
        return AllDataComponents.PACKAGE_ADDRESS;
    }

    @Override
    public FilterItemStack makeStackWrapper(ItemStack filter) {
        return new FilterItemStack.PackageFilterItemStack(filter);
    }

    @Override
    public ItemStack[] getFilterItems(ItemStack stack) {
        return new ItemStack[0];
    }
}

