/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packagePort.frogport;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.box.PackageStyles;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.content.logistics.packager.PackagerItemHandler;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.audio.FrogportAudioBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FrogportBlockEntity
extends PackagePortBlockEntity {
    public ItemStack animatedPackage;
    public LerpedFloat manualOpenAnimationProgress;
    public LerpedFloat animationProgress = LerpedFloat.linear();
    public LerpedFloat anticipationProgress = LerpedFloat.linear();
    public boolean currentlyDepositing;
    public boolean goggles = false;
    public boolean sendAnticipate;
    public float passiveYaw;
    public boolean failedLastExport;
    private ItemStack deferAnimationStart;
    private boolean deferAnimationInward;

    public FrogportBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.PACKAGE_FROGPORT, pos, state);
        this.manualOpenAnimationProgress = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.35, LerpedFloat.Chaser.LINEAR);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.FROGPORT);
    }

    public boolean isAnimationInProgress() {
        return this.animationProgress.getChaseTarget() == 1.0f;
    }

    @Override
    public AABB getRenderBoundingBox() {
        AABB bb = super.getRenderBoundingBox().expandTowards(0.0, 1.0, 0.0);
        if (this.target != null) {
            bb = bb.minmax(new AABB(BlockPos.containing((Position)this.target.getExactTargetLocation(this, (LevelAccessor)this.level, this.worldPosition)))).inflate(0.5);
        }
        return bb;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.level.isClientSide() || this.isAnimationInProgress()) {
            return;
        }
        boolean prevFail = this.failedLastExport;
        this.tryPushingToAdjacentInventories();
        this.tryPullingFromOwnAndAdjacentInventories();
        if (this.failedLastExport != prevFail) {
            this.sendData();
        }
    }

    public void sendAnticipate() {
        if (this.isAnimationInProgress()) {
            return;
        }
        int size = this.inventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            if (!this.inventory.getItem(i).isEmpty()) continue;
            this.sendAnticipate = true;
            this.sendData();
            return;
        }
    }

    public void anticipate() {
        this.anticipationProgress.chase(1.0, 0.1, LerpedFloat.Chaser.LINEAR);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.deferAnimationStart != null) {
            this.startAnimation(this.deferAnimationStart, this.deferAnimationInward);
            this.deferAnimationStart = null;
        }
        if (this.anticipationProgress.getValue() == 1.0f) {
            this.anticipationProgress.startWithValue(0.0);
        }
        this.manualOpenAnimationProgress.updateChaseTarget(this.openTracker.openCount > 0 ? 1.0f : 0.0f);
        boolean wasOpen = this.manualOpenAnimationProgress.getValue() > 0.0f;
        this.anticipationProgress.tickChaser();
        this.manualOpenAnimationProgress.tickChaser();
        if (this.level.isClientSide() && wasOpen && this.manualOpenAnimationProgress.getValue() == 0.0f) {
            this.getBehaviour(FrogportAudioBehaviour.TYPE).close(this.level, this.worldPosition);
        }
        if (!this.isAnimationInProgress()) {
            return;
        }
        this.animationProgress.tickChaser();
        float value = this.animationProgress.getValue();
        if (this.currentlyDepositing) {
            if (!this.level.isClientSide() || this.isVirtual()) {
                if ((double)value > 0.5 && this.animatedPackage != null) {
                    if (this.target == null || !this.target.depositImmediately() && !this.target.export((LevelAccessor)this.level, this.worldPosition, this.animatedPackage, false)) {
                        this.drop(this.animatedPackage);
                    }
                    this.animatedPackage = null;
                }
            } else {
                if ((double)value > 0.7 && this.animatedPackage != null) {
                    this.animatedPackage = null;
                }
                if ((double)this.animationProgress.getValue(0.0f) < 0.2 && (double)value > 0.2) {
                    Vec3 v = this.target.getExactTargetLocation(this, (LevelAccessor)this.level, this.worldPosition);
                    this.level.playLocalSound(v.x, v.y, v.z, SoundEvents.CHAIN_STEP, SoundSource.BLOCKS, 0.25f, 1.2f, false);
                }
            }
        }
        if (value < 1.0f) {
            return;
        }
        this.anticipationProgress.startWithValue(0.0);
        this.animationProgress.startWithValue(0.0);
        if (this.level.isClientSide()) {
            this.animatedPackage = null;
            return;
        }
        if (!this.currentlyDepositing) {
            int count = this.animatedPackage.getCount();
            this.inventory.sendMode();
            int insert = this.inventory.insert(this.animatedPackage, count);
            this.inventory.receiveMode();
            if (insert != count) {
                if (insert == 0) {
                    this.drop(this.animatedPackage);
                } else {
                    this.drop(this.animatedPackage.copyWithCount(count - insert));
                }
            }
        }
        this.animatedPackage = null;
    }

    public void startAnimation(ItemStack box, boolean deposit) {
        if (!PackageItem.isPackage(box)) {
            return;
        }
        if (deposit && (this.target == null || this.target.depositImmediately() && !this.target.export((LevelAccessor)this.level, this.worldPosition, box.copy(), false))) {
            return;
        }
        this.animationProgress.startWithValue(0.0);
        this.animationProgress.chase(1.0, 0.1, LerpedFloat.Chaser.LINEAR);
        this.animatedPackage = box;
        this.currentlyDepositing = deposit;
        if (this.level != null && !deposit && !this.level.isClientSide()) {
            this.award(AllAdvancements.FROGPORT);
        }
        if (this.level != null && this.level.isClientSide()) {
            FrogportAudioBehaviour sounds = this.getBehaviour(FrogportAudioBehaviour.TYPE);
            sounds.open(this.level, this.worldPosition);
            if (this.currentlyDepositing) {
                sounds.depositPackage(this.level, this.worldPosition);
            } else {
                sounds.catchPackage(this.level, this.worldPosition);
                Vec3 vec = this.target.getExactTargetLocation(this, (LevelAccessor)this.level, this.worldPosition);
                if (vec != null) {
                    for (int i = 0; i < 5; ++i) {
                        this.level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, AllBlocks.ROPE.defaultBlockState()), vec.x, vec.y - (double)this.level.random.nextFloat() * 0.25, vec.z, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        if (this.level != null && !this.level.isClientSide()) {
            this.level.blockEntityChanged(this.worldPosition);
            this.sendData();
        }
    }

    protected void tryPushingToAdjacentInventories() {
        this.failedLastExport = false;
        if (this.inventory.isEmpty()) {
            return;
        }
        Container handler = this.getAdjacentInventory(Direction.DOWN);
        if (handler == null) {
            return;
        }
        boolean dirty = false;
        int size = this.inventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (!this.inventory.canTakeItemThroughFace(i, stack, null)) continue;
            int insert = handler.insertExist(stack, 1);
            if (insert == 1) {
                int count = stack.getCount();
                if (count == insert) {
                    this.inventory.setItem(i, ItemStack.EMPTY);
                } else {
                    stack.setCount(count - 1);
                }
                dirty = true;
                continue;
            }
            this.failedLastExport = true;
        }
        if (dirty) {
            this.inventory.setChanged();
            this.level.blockEntityChanged(this.worldPosition);
        }
    }

    @Override
    protected void onOpenChange(boolean open) {
    }

    public void tryPullingFromOwnAndAdjacentInventories() {
        if (this.isAnimationInProgress()) {
            return;
        }
        if (this.target == null || !this.target.export((LevelAccessor)this.level, this.worldPosition, PackageStyles.getDefaultBox(), true)) {
            return;
        }
        this.inventory.sendMode();
        ItemStack stack = this.inventory.extractAny();
        this.inventory.receiveMode();
        if (!stack.isEmpty()) {
            this.startAnimation(stack, true);
            return;
        }
        for (Direction side : Iterate.directions) {
            Container handler;
            if (side != Direction.DOWN || (handler = this.getAdjacentInventory(side)) == null || !this.tryPullingFrom(handler)) continue;
            return;
        }
    }

    public boolean tryPullingFrom(Container handler) {
        ItemStack extract = handler.extract(stack -> {
            if (!PackageItem.isPackage(stack)) {
                return false;
            }
            String filterString = this.getFilterString();
            return filterString == null || handler instanceof PackagerItemHandler || !PackageItem.matchAddress(stack, filterString);
        });
        if (extract.isEmpty()) {
            return false;
        }
        this.startAnimation(extract, true);
        return true;
    }

    protected Container getAdjacentInventory(Direction side) {
        BlockPos pos = this.worldPosition.relative(side);
        BlockEntity blockEntity = this.level.getBlockEntity(pos);
        if (blockEntity == null || blockEntity instanceof FrogportBlockEntity) {
            return null;
        }
        return ItemHelper.getInventory(this.level, pos, null, blockEntity, side.getOpposite());
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.putFloat("PlacedYaw", this.passiveYaw);
        if (this.animatedPackage != null && this.isAnimationInProgress()) {
            view.store("AnimatedPackage", ItemStack.CODEC, (Object)this.animatedPackage);
            view.putBoolean("Deposit", this.currentlyDepositing);
        }
        if (this.sendAnticipate) {
            this.sendAnticipate = false;
            view.putBoolean("Anticipate", true);
        }
        if (this.failedLastExport) {
            view.putBoolean("FailedLastExport", true);
        }
        if (this.goggles) {
            view.putBoolean("Goggles", true);
        }
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.passiveYaw = view.getFloatOr("PlacedYaw", 0.0f);
        this.failedLastExport = view.getBooleanOr("FailedLastExport", false);
        this.goggles = view.getBooleanOr("Goggles", false);
        if (!clientPacket) {
            this.animatedPackage = null;
        }
        view.read("AnimatedPackage", ItemStack.CODEC).ifPresent(stack -> {
            this.deferAnimationInward = view.getBooleanOr("Deposit", false);
            this.deferAnimationStart = stack;
        });
        if (clientPacket && view.getBooleanOr("Anticipate", false)) {
            this.anticipate();
        }
    }

    public float getYaw() {
        if (this.target == null) {
            return this.passiveYaw;
        }
        Vec3 diff = this.target.getExactTargetLocation(this, (LevelAccessor)this.level, this.worldPosition).subtract(Vec3.atCenterOf((Vec3i)this.worldPosition));
        return (float)(Mth.atan2((double)diff.x, (double)diff.z) * 57.2957763671875) + 180.0f;
    }

    @Override
    protected void onOpenedManually() {
        if (this.level.isClientSide()) {
            this.getBehaviour(FrogportAudioBehaviour.TYPE).open(this.level, this.worldPosition);
        }
    }

    @Override
    public InteractionResult use(Player player) {
        ItemStack mainHandItem;
        if (player == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!this.goggles && (mainHandItem = player.getMainHandItem()).is((Item)AllItems.GOGGLES)) {
            this.goggles = true;
            if (!this.level.isClientSide()) {
                this.notifyUpdate();
                this.level.playSound(null, this.worldPosition, (SoundEvent)SoundEvents.ARMOR_EQUIP_GOLD.value(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(player);
    }
}

