/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packagePort.postbox;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PostboxBlock
extends HorizontalDirectionalBlock
implements IBE<PostboxBlockEntity>,
IWrenchable,
ProperWaterloggedBlock,
ItemInventoryProvider<PostboxBlockEntity> {
    public static MapCodec<PostboxBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostboxBlock.propertiesCodec(), (App)DyeColor.CODEC.fieldOf("color").forGetter(PostboxBlock::getColor)).apply((Applicative)instance, PostboxBlock::new));
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    protected final DyeColor color;

    public PostboxBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Container getInventory(LevelAccessor world, BlockPos pos, BlockState state, PostboxBlockEntity blockEntity, Direction context) {
        return blockEntity.inventory;
    }

    public static Function<BlockBehaviour.Properties, PostboxBlock> dyed(DyeColor color) {
        return settings -> new PostboxBlock((BlockBehaviour.Properties)settings, color);
    }

    public static PostboxBlock getColorBlock(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> AllBlocks.WHITE_POSTBOX;
            case DyeColor.ORANGE -> AllBlocks.ORANGE_POSTBOX;
            case DyeColor.MAGENTA -> AllBlocks.MAGENTA_POSTBOX;
            case DyeColor.LIGHT_BLUE -> AllBlocks.LIGHT_BLUE_POSTBOX;
            case DyeColor.YELLOW -> AllBlocks.YELLOW_POSTBOX;
            case DyeColor.LIME -> AllBlocks.LIME_POSTBOX;
            case DyeColor.PINK -> AllBlocks.PINK_POSTBOX;
            case DyeColor.GRAY -> AllBlocks.GRAY_POSTBOX;
            case DyeColor.LIGHT_GRAY -> AllBlocks.LIGHT_GRAY_POSTBOX;
            case DyeColor.CYAN -> AllBlocks.CYAN_POSTBOX;
            case DyeColor.PURPLE -> AllBlocks.PURPLE_POSTBOX;
            case DyeColor.BLUE -> AllBlocks.BLUE_POSTBOX;
            case DyeColor.BROWN -> AllBlocks.BROWN_POSTBOX;
            case DyeColor.GREEN -> AllBlocks.GREEN_POSTBOX;
            case DyeColor.RED -> AllBlocks.RED_POSTBOX;
            case DyeColor.BLACK -> AllBlocks.BLACK_POSTBOX;
        };
    }

    public DyeColor getColor() {
        return this.color;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction facing = pContext.getHorizontalDirection().getOpposite();
        return this.withWater((BlockState)super.getStateForPlacement(pContext).setValue((Property)FACING, (Comparable)facing), pContext);
    }

    public FluidState getFluidState(BlockState pState) {
        return this.fluidState(pState);
    }

    public BlockState updateShape(BlockState pState, LevelReader pLevel, ScheduledTickAccess tickView, BlockPos pPos, Direction pDirection, BlockPos pNeighborPos, BlockState pNeighborState, RandomSource random) {
        this.updateWater(pLevel, tickView, pState, pPos);
        return pState;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.POSTBOX.get((Direction)pState.getValue((Property)FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{FACING, OPEN, WATERLOGGED}));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.onBlockEntityUse((BlockGetter)level, pos, be -> be.use(player));
    }

    @Override
    public Class<PostboxBlockEntity> getBlockEntityClass() {
        return PostboxBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends PostboxBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.PACKAGE_POSTBOX;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos, Direction direction) {
        return this.getBlockEntityOptional((BlockGetter)pLevel, pPos).map(PackagePortBlockEntity::getComparatorOutput).orElse(0);
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

