/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packagePort.postbox;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.content.logistics.packagePort.postbox.PostboxBlock;
import com.zurrtum.create.content.trains.station.GlobalPackagePort;
import com.zurrtum.create.content.trains.station.GlobalStation;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class PostboxBlockEntity
extends PackagePortBlockEntity {
    public WeakReference<GlobalStation> trackedGlobalStation = new WeakReference<Object>(null);
    public LerpedFloat flag = LerpedFloat.linear().startWithValue(0.0);
    public boolean forceFlag;
    private boolean sendParticles;

    public PostboxBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.PACKAGE_POSTBOX, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level.isClientSide() && !this.isVirtual()) {
            if (this.sendParticles) {
                this.sendData();
            }
            return;
        }
        float currentTarget = this.flag.getChaseTarget();
        if (currentTarget == 0.0f || this.flag.settled()) {
            boolean target;
            boolean bl = target = !this.inventory.isEmpty() || this.forceFlag;
            if ((float)target != currentTarget) {
                this.flag.chase((double)target, 0.1f, LerpedFloat.Chaser.LINEAR);
                if (target) {
                    AllSoundEvents.CONTRAPTION_ASSEMBLE.playAt(this.level, (Vec3i)this.worldPosition, 1.0f, 2.0f, true);
                }
            }
        }
        boolean settled = this.flag.getValue() > 0.15f;
        this.flag.tickChaser();
        if (currentTarget == 0.0f && settled != this.flag.getValue() > 0.15f) {
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playAt(this.level, (Vec3i)this.worldPosition, 0.75f, 1.5f, true);
        }
        if (this.sendParticles) {
            this.sendParticles = false;
            BoneMealItem.addGrowthParticles((LevelAccessor)this.level, (BlockPos)this.worldPosition, (int)40);
        }
    }

    @Override
    protected void onOpenChange(boolean open) {
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)PostboxBlock.OPEN, (Comparable)Boolean.valueOf(open)));
        this.level.playSound(null, this.worldPosition, open ? SoundEvents.BARREL_OPEN : SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS);
    }

    public void spawnParticles() {
        this.sendParticles = true;
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket && this.sendParticles) {
            view.putBoolean("Particles", true);
        }
        this.sendParticles = false;
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.sendParticles = clientPacket && view.getBooleanOr("Particles", false);
    }

    public void setChanged() {
        this.saveOfflineBuffer();
        super.setChanged();
    }

    private void saveOfflineBuffer() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        GlobalStation station = (GlobalStation)this.trackedGlobalStation.get();
        if (station == null) {
            return;
        }
        GlobalPackagePort globalPackagePort = station.connectedPorts.get(this.worldPosition);
        if (globalPackagePort == null) {
            return;
        }
        globalPackagePort.saveOfflineBuffer(this.inventory);
    }
}

