/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packager.repackager;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.crate.BottomlessItemHandler;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.content.logistics.packager.PackagerItemHandler;
import com.zurrtum.create.content.logistics.packager.PackagingRequest;
import com.zurrtum.create.content.logistics.packager.repackager.PackageRepackageHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class RepackagerBlockEntity
extends PackagerBlockEntity {
    public PackageRepackageHelper repackageHelper = new PackageRepackageHelper();

    public RepackagerBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.REPACKAGER, pos, state);
    }

    @Override
    public boolean unwrapBox(ItemStack box, boolean simulate) {
        int count;
        if (this.animationTicks > 0) {
            return false;
        }
        Container targetInv = (Container)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return false;
        }
        boolean targetIsCreativeCrate = targetInv instanceof BottomlessItemHandler;
        boolean anySpace = simulate ? targetInv.countSpace(box, count = box.getCount()) == count : targetInv.preciseInsert(box);
        if (!targetIsCreativeCrate && !anySpace) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.previouslyUnwrapped = box;
        this.animationInward = true;
        this.animationTicks = 20;
        this.notifyUpdate();
        return true;
    }

    @Override
    public void recheckIfLinksPresent() {
    }

    @Override
    public boolean redstoneModeActive() {
        return true;
    }

    @Override
    public void attemptToSend(List<PackagingRequest> queuedRequests) {
        if (!this.heldBox.isEmpty() || this.animationTicks != 0 || this.buttonCooldown > 0) {
            return;
        }
        if (!this.queuedExitingPackages.isEmpty()) {
            return;
        }
        Container targetInv = (Container)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return;
        }
        this.attemptToRepackage(targetInv);
        if (this.heldBox.isEmpty()) {
            return;
        }
        this.updateSignAddress();
        if (!this.signBasedAddress.isBlank()) {
            PackageItem.addAddress(this.heldBox, this.signBasedAddress);
        }
    }

    protected void attemptToRepackage(Container targetInv) {
        this.repackageHelper.clear();
        int completedOrderId = -1;
        for (ItemStack stack : targetInv) {
            if (stack.isEmpty() || !PackageItem.isPackage(stack)) continue;
            if (!this.repackageHelper.isFragmented(stack)) {
                targetInv.extract(stack, 1);
                this.heldBox = stack.copy();
                this.animationInward = false;
                this.animationTicks = 20;
                this.notifyUpdate();
                return;
            }
            completedOrderId = this.repackageHelper.addPackageFragment(stack);
            if (completedOrderId == -1) continue;
            break;
        }
        if (completedOrderId == -1) {
            return;
        }
        List<BigItemStack> boxesToExport = this.repackageHelper.repack(completedOrderId, this.level.getRandom());
        if (boxesToExport.isEmpty()) {
            return;
        }
        targetInv.extract(this.repackageHelper.collectedPackages.get(completedOrderId));
        this.queuedExitingPackages.addAll(boxesToExport);
        this.notifyUpdate();
    }
}

