/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packagerLink;

import com.mojang.serialization.Codec;
import com.zurrtum.create.content.logistics.packagerLink.LogisticsNetwork;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class LogisticsNetworkSavedData
extends SavedData {
    public static final Codec<LogisticsNetworkSavedData> CODEC = Codec.list(LogisticsNetwork.CODEC).xmap(LogisticsNetworkSavedData::createMap, LogisticsNetworkSavedData::toList).xmap(LogisticsNetworkSavedData::new, LogisticsNetworkSavedData::getLogisticsNetworks);
    private static final SavedDataType<LogisticsNetworkSavedData> TYPE = new SavedDataType("create_logistics", LogisticsNetworkSavedData::new, CODEC, null);
    private final Map<UUID, LogisticsNetwork> logisticsNetworks;

    public Map<UUID, LogisticsNetwork> getLogisticsNetworks() {
        return this.logisticsNetworks;
    }

    private LogisticsNetworkSavedData() {
        this.logisticsNetworks = new HashMap<UUID, LogisticsNetwork>();
    }

    private LogisticsNetworkSavedData(Map<UUID, LogisticsNetwork> logisticsNetworks) {
        this.logisticsNetworks = logisticsNetworks;
    }

    private static Map<UUID, LogisticsNetwork> createMap(List<LogisticsNetwork> list) {
        HashMap<UUID, LogisticsNetwork> logisticsNetworks = new HashMap<UUID, LogisticsNetwork>();
        list.forEach(network -> logisticsNetworks.put(network.id, (LogisticsNetwork)network));
        return logisticsNetworks;
    }

    private static List<LogisticsNetwork> toList(Map<UUID, LogisticsNetwork> logisticsNetworks) {
        return logisticsNetworks.values().stream().toList();
    }

    public static LogisticsNetworkSavedData load(MinecraftServer server) {
        return (LogisticsNetworkSavedData)server.overworld().getDataStorage().computeIfAbsent(TYPE);
    }
}

