/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.packagerLink;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.content.logistics.packagerLink.RequestPromise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RequestPromiseQueue {
    public static final Codec<RequestPromiseQueue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(RequestPromise.CODEC).fieldOf("List").forGetter(i -> i.flatten(false))).apply((Applicative)instance, RequestPromiseQueue::new));
    private final Map<Item, List<RequestPromise>> promisesByItem = new IdentityHashMap<Item, List<RequestPromise>>();
    private Runnable onChanged;

    public RequestPromiseQueue(Runnable onChanged) {
        this.onChanged = onChanged;
    }

    private RequestPromiseQueue(List<RequestPromise> list) {
        this((Runnable)null);
        list.forEach(promise -> this.promisesByItem.computeIfAbsent(promise.promisedStack.stack.getItem(), $ -> new LinkedList()).add(promise));
    }

    public void add(RequestPromise promise) {
        this.promisesByItem.computeIfAbsent(promise.promisedStack.stack.getItem(), $ -> new LinkedList()).add(promise);
        this.onChanged.run();
    }

    public void setOnChanged(Runnable onChanged) {
        this.onChanged = onChanged;
    }

    public int getTotalPromisedAndRemoveExpired(ItemStack stack, int expiryTime) {
        int promised = 0;
        List<RequestPromise> list = this.promisesByItem.get(stack.getItem());
        if (list == null) {
            return promised;
        }
        Iterator<RequestPromise> iterator = list.iterator();
        while (iterator.hasNext()) {
            RequestPromise promise = iterator.next();
            if (!ItemStack.isSameItemSameComponents((ItemStack)promise.promisedStack.stack, (ItemStack)stack)) continue;
            if (expiryTime != -1 && promise.ticksExisted >= expiryTime) {
                iterator.remove();
                this.onChanged.run();
                continue;
            }
            promised += promise.promisedStack.count;
        }
        return promised;
    }

    public void forceClear(ItemStack stack) {
        List<RequestPromise> list = this.promisesByItem.get(stack.getItem());
        if (list == null) {
            return;
        }
        Iterator<RequestPromise> iterator = list.iterator();
        while (iterator.hasNext()) {
            RequestPromise promise = iterator.next();
            if (!ItemStack.isSameItemSameComponents((ItemStack)promise.promisedStack.stack, (ItemStack)stack)) continue;
            iterator.remove();
            this.onChanged.run();
        }
        if (list.isEmpty()) {
            this.promisesByItem.remove(stack.getItem());
        }
    }

    public void itemEnteredSystem(ItemStack stack, int amount) {
        List<RequestPromise> list = this.promisesByItem.get(stack.getItem());
        if (list == null) {
            return;
        }
        Iterator<RequestPromise> iterator = list.iterator();
        while (iterator.hasNext()) {
            RequestPromise requestPromise = iterator.next();
            if (!ItemStack.isSameItemSameComponents((ItemStack)requestPromise.promisedStack.stack, (ItemStack)stack)) continue;
            int toSubtract = Math.min(amount, requestPromise.promisedStack.count);
            amount -= toSubtract;
            requestPromise.promisedStack.count -= toSubtract;
            if (requestPromise.promisedStack.count <= 0) {
                iterator.remove();
                this.onChanged.run();
            }
            if (amount > 0) continue;
            break;
        }
        if (list.isEmpty()) {
            this.promisesByItem.remove(stack.getItem());
        }
    }

    public List<RequestPromise> flatten(boolean sorted) {
        ArrayList<RequestPromise> all = new ArrayList<RequestPromise>();
        this.promisesByItem.forEach((key, list) -> all.addAll((Collection<RequestPromise>)list));
        if (sorted) {
            all.sort(RequestPromise.ageComparator());
        }
        return all;
    }

    public void tick() {
        this.promisesByItem.forEach((key, list) -> list.forEach(RequestPromise::tick));
    }

    public boolean isEmpty() {
        return this.promisesByItem.isEmpty();
    }
}

