/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.redstoneRequester;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.WeakPowerControlBlock;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.component.AutoRequestData;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class RedstoneRequesterBlock
extends Block
implements IBE<RedstoneRequesterBlockEntity>,
IWrenchable,
WeakPowerControlBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;

    public RedstoneRequesterBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{POWERED, AXIS}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.getStateForPlacement(pContext);
        if (stateForPlacement == null) {
            return null;
        }
        return (BlockState)((BlockState)stateForPlacement.setValue(AXIS, (Comparable)pContext.getHorizontalDirection().getAxis())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(pContext.getLevel().hasNeighborSignal(pContext.getClickedPos())));
    }

    @Override
    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos, Direction direction) {
        RedstoneRequesterBlockEntity req = (RedstoneRequesterBlockEntity)this.getBlockEntity((BlockGetter)pLevel, pPos);
        return req != null && req.lastRequestSucceeded ? 15 : 0;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.onBlockEntityUse((BlockGetter)level, pos, be -> be.use(player));
    }

    public static void programRequester(ServerPlayer player, StockTickerBlockEntity be, PackageOrderWithCrafts order, String address) {
        ItemStack stack = player.getMainHandItem();
        boolean isRequester = stack.is((Item)AllItems.REDSTONE_REQUESTER);
        boolean isShopCloth = stack.is(AllItemTags.TABLE_CLOTHS);
        if (!isRequester && !isShopCloth) {
            return;
        }
        String targetDim = player.level().dimension().identifier().toString();
        AutoRequestData autoRequestData = new AutoRequestData(order, address, be.getBlockPos(), targetDim, false);
        autoRequestData.writeToItem(BlockPos.ZERO, stack);
        if (isRequester) {
            BlockEntityType type;
            CompoundTag beTag;
            TypedEntityData data = (TypedEntityData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            if (data != null) {
                beTag = data.copyTagWithoutId();
                type = (BlockEntityType)data.type();
            } else {
                beTag = new CompoundTag();
                type = AllBlockEntityTypes.PACKAGER_LINK;
            }
            beTag.store("Freq", UUIDUtil.CODEC, (Object)be.behaviour.freqId);
            beTag.store("id", CreateCodecs.BLOCK_ENTITY_TYPE_CODEC, AllBlockEntityTypes.REDSTONE_REQUESTER);
            stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)TypedEntityData.of((Object)type, (CompoundTag)beTag));
        }
        player.setItemInHand(InteractionHand.MAIN_HAND, stack);
    }

    public static void appendRequesterTooltip(ItemStack pStack, Consumer<Component> pTooltip) {
        if (!pStack.has(AllDataComponents.AUTO_REQUEST_DATA)) {
            return;
        }
        AutoRequestData data = (AutoRequestData)pStack.get(AllDataComponents.AUTO_REQUEST_DATA);
        for (BigItemStack entry : data.encodedRequest().stacks()) {
            pTooltip.accept((Component)entry.stack.getHoverName().copy().append(" x").append(String.valueOf(entry.count)).withStyle(ChatFormatting.GRAY));
        }
        pTooltip.accept((Component)Component.translatable((String)"create.logistically_linked.tooltip_clear").withStyle(ChatFormatting.DARK_GRAY));
    }

    public void setPlacedBy(Level pLevel, BlockPos requesterPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        Player player = pPlacer instanceof Player ? (Player)pPlacer : null;
        this.withBlockEntityDo((BlockGetter)pLevel, requesterPos, rrbe -> {
            AutoRequestData data = AutoRequestData.readFromItem(pLevel, player, requesterPos, pStack);
            if (data == null) {
                return;
            }
            rrbe.encodedRequest = data.encodedRequest();
            rrbe.encodedTargetAdress = data.encodedTargetAddress();
        });
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, @Nullable Orientation wireOrientation, boolean pMovedByPiston) {
        if (pLevel.isClientSide()) {
            return;
        }
        pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(pLevel.hasNeighborSignal(pPos))));
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, RedstoneRequesterBlockEntity::onRedstonePowerChanged);
    }

    @Override
    public Class<RedstoneRequesterBlockEntity> getBlockEntityClass() {
        return RedstoneRequesterBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends RedstoneRequesterBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.REDSTONE_REQUESTER;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue(AXIS, (Comparable)pRotation.rotate(Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)pState.getValue(AXIS)))).getAxis());
    }
}

