/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.stockTicker;

import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class StockKeeperCategoryMenu
extends MenuBase<StockTickerBlockEntity> {
    public boolean slotsActive = true;
    public ItemStackHandler proxyInventory;

    public StockKeeperCategoryMenu(int id, Inventory inv, StockTickerBlockEntity contentHolder) {
        super(AllMenuTypes.STOCK_KEEPER_CATEGORY, id, inv, contentHolder);
    }

    @Override
    protected void initAndReadInventory(StockTickerBlockEntity contentHolder) {
        this.proxyInventory = new ItemStackHandler(1);
    }

    @Override
    protected void addSlots() {
        this.addSlot(new InactiveItemHandlerSlot(this.proxyInventory, 0, 16, 24));
        this.addPlayerSlots(18, 106);
    }

    @Override
    protected Slot createPlayerSlot(Inventory inventory, int index, int x, int y) {
        return new InactiveSlot((Container)inventory, index, x, y);
    }

    @Override
    protected void saveData(StockTickerBlockEntity contentHolder) {
    }

    @Override
    public boolean stillValid(Player player) {
        return !((StockTickerBlockEntity)this.contentHolder).isRemoved() && player.position().closerThan((Position)Vec3.atCenterOf((Vec3i)((StockTickerBlockEntity)this.contentHolder).getBlockPos()), player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 4.0);
    }

    public ItemStack quickMoveStack(Player pPlayer, int index) {
        Slot clickedSlot = this.getSlot(index);
        if (!clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = clickedSlot.getItem();
        int size = 1;
        boolean success = index < size ? !this.moveItemStackTo(stack, size, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, size, false);
        return success ? ItemStack.EMPTY : stack;
    }

    class InactiveItemHandlerSlot
    extends Slot {
        public InactiveItemHandlerSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return super.mayPlace(stack) && (stack.isEmpty() || stack.getItem() instanceof FilterItem);
        }

        public boolean isActive() {
            return StockKeeperCategoryMenu.this.slotsActive;
        }
    }

    class InactiveSlot
    extends Slot {
        public InactiveSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean isActive() {
            return StockKeeperCategoryMenu.this.slotsActive;
        }
    }
}

