/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.tableCloth;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.foundation.item.TooltipWorldContext;
import com.zurrtum.create.infrastructure.component.ShoppingList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class ShoppingListItem
extends Item {
    public ShoppingListItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static ShoppingList getList(ItemStack stack) {
        return (ShoppingList)stack.get(AllDataComponents.SHOPPING_LIST);
    }

    public static ItemStack saveList(ItemStack stack, ShoppingList list, String address) {
        stack.set(AllDataComponents.SHOPPING_LIST, (Object)list);
        stack.set(AllDataComponents.SHOPPING_LIST_ADDRESS, (Object)address);
        return stack;
    }

    public static String getAddress(ItemStack stack) {
        return (String)stack.getOrDefault(AllDataComponents.SHOPPING_LIST_ADDRESS, (Object)"");
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay displayComponent, Consumer<Component> textConsumer, TooltipFlag type) {
        ShoppingList list = ShoppingListItem.getList(stack);
        if (list != null && context instanceof TooltipWorldContext) {
            TooltipWorldContext worldContext = (TooltipWorldContext)context;
            Couple<InventorySummary> lists = list.bakeEntries((LevelAccessor)worldContext.create$getWorld(), null);
            for (InventorySummary items : lists) {
                boolean cost;
                List<BigItemStack> entries = items.getStacksByCount();
                boolean bl = cost = items == lists.getSecond();
                if (cost) {
                    textConsumer.accept((Component)Component.empty());
                }
                if (entries.size() == 1) {
                    BigItemStack entry = entries.getFirst();
                    textConsumer.accept((Component)(cost ? Component.translatable((String)"create.table_cloth.total_cost") : Component.literal((String)"")).withStyle(ChatFormatting.GOLD).append((Component)entry.stack.getHoverName().plainCopy().append(" x").append(String.valueOf(entry.count)).withStyle(cost ? ChatFormatting.YELLOW : ChatFormatting.GRAY)));
                    continue;
                }
                if (cost) {
                    textConsumer.accept((Component)Component.translatable((String)"create.table_cloth.total_cost").withStyle(ChatFormatting.GOLD));
                }
                for (BigItemStack entry : entries) {
                    textConsumer.accept((Component)entry.stack.getHoverName().plainCopy().append(" x").append(String.valueOf(entry.count)).withStyle(cost ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
                }
            }
        }
        textConsumer.accept((Component)Component.translatable((String)"create.table_cloth.hand_to_shop_keeper").withStyle(ChatFormatting.GRAY));
        textConsumer.accept((Component)Component.translatable((String)"create.table_cloth.sneak_click_discard").withStyle(ChatFormatting.DARK_GRAY));
    }

    public InteractionResult use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pUsedHand == InteractionHand.OFF_HAND || pPlayer == null || !pPlayer.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        pPlayer.displayClientMessage((Component)Component.translatable((String)"create.table_cloth.shopping_list_discarded"), true);
        pPlayer.makeSound(SoundEvents.BOOK_PAGE_TURN);
        return InteractionResult.SUCCESS.heldItemTransformedTo(ItemStack.EMPTY);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        InteractionHand pUsedHand = pContext.getHand();
        Player pPlayer = pContext.getPlayer();
        if (pUsedHand == InteractionHand.OFF_HAND || pPlayer == null || !pPlayer.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        pPlayer.setItemInHand(pUsedHand, ItemStack.EMPTY);
        pPlayer.displayClientMessage((Component)Component.translatable((String)"create.table_cloth.shopping_list_discarded"), true);
        pPlayer.makeSound(SoundEvents.BOOK_PAGE_TURN);
        return InteractionResult.SUCCESS;
    }
}

