/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.tableCloth;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.logistics.tableCloth.ServerTableClothFilteringBehaviour;
import com.zurrtum.create.content.logistics.tableCloth.ShoppingListItem;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.component.AutoRequestData;
import com.zurrtum.create.infrastructure.component.ShoppingList;
import com.zurrtum.create.infrastructure.packet.c2s.LogisticalStockRequestPacket;
import com.zurrtum.create.infrastructure.packet.s2c.RemoveBlockEntityPacket;
import com.zurrtum.create.infrastructure.packet.s2c.ShopUpdatePacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TableClothBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity {
    public AutoRequestData requestData;
    public List<ItemStack> manuallyAddedItems = new ArrayList<ItemStack>();
    public UUID owner = null;
    public Direction facing;
    public boolean sideOccluded;
    public ServerFilteringBehaviour priceTag;
    private List<ItemStack> renderedItemsForShop;

    public TableClothBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.TABLE_CLOTH, pos, state);
        this.requestData = new AutoRequestData();
        this.facing = Direction.SOUTH;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.priceTag = new ServerTableClothFilteringBehaviour(this);
        behaviours.add(this.priceTag);
    }

    public List<ItemStack> getItemsForRender() {
        if (this.isShop()) {
            if (this.renderedItemsForShop == null) {
                this.renderedItemsForShop = this.requestData.encodedRequest().stacks().stream().map(b -> b.stack).limit(4L).toList();
            }
            return this.renderedItemsForShop;
        }
        return this.manuallyAddedItems;
    }

    public void invalidateItemsForRender() {
        this.renderedItemsForShop = null;
    }

    public void notifyShopUpdate() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ShopUpdatePacket packet = new ShopUpdatePacket(this.worldPosition);
            for (ServerPlayer player : serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(this.worldPosition), false)) {
                player.connection.send((Packet)packet);
            }
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        BlockPos relativePos = this.worldPosition.relative(this.facing);
        this.sideOccluded = this.level.getBlockState(relativePos).is(AllBlockTags.TABLE_CLOTHS) || Block.isFaceFull((VoxelShape)this.level.getBlockState(relativePos.below()).getOcclusionShape(), (Direction)this.facing.getOpposite());
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(1.0);
    }

    public boolean isShop() {
        return !this.requestData.encodedRequest().isEmpty();
    }

    public InteractionResult use(Player player, BlockHitResult ray) {
        if (this.isShop()) {
            return this.useShop(player);
        }
        ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (heldItem.isEmpty()) {
            if (this.manuallyAddedItems.isEmpty()) {
                return InteractionResult.SUCCESS;
            }
            player.setItemInHand(InteractionHand.MAIN_HAND, this.manuallyAddedItems.remove(this.manuallyAddedItems.size() - 1));
            this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 0.5f, 1.0f);
            if (this.manuallyAddedItems.isEmpty()) {
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)TableClothBlock.HAS_BE, (Comparable)Boolean.valueOf(false)), 3);
                Level level = this.level;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    RemoveBlockEntityPacket packet = new RemoveBlockEntityPacket(this.worldPosition);
                    for (ServerPlayer serverPlayer : serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(this.worldPosition), false)) {
                        serverPlayer.connection.send((Packet)packet);
                    }
                }
            } else {
                this.notifyUpdate();
            }
            return InteractionResult.SUCCESS;
        }
        if (this.manuallyAddedItems.size() >= 4) {
            return InteractionResult.SUCCESS;
        }
        this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.5f, 1.0f);
        this.manuallyAddedItems.add(heldItem.copyWithCount(1));
        this.facing = player.getDirection().getOpposite();
        heldItem.shrink(1);
        if (heldItem.isEmpty()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        this.notifyUpdate();
        return InteractionResult.SUCCESS;
    }

    public InteractionResult useShop(Player player) {
        StockTickerBlockEntity stbe;
        ItemStack itemInHand = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack prevListItem = ItemStack.EMPTY;
        boolean addOntoList = false;
        for (int i = 0; i < 9; ++i) {
            ItemStack item = player.getInventory().getItem(i);
            if (!item.is((Item)AllItems.SHOPPING_LIST)) continue;
            prevListItem = item;
            addOntoList = true;
            player.getInventory().setItem(i, ItemStack.EMPTY);
        }
        if (itemInHand.is((Item)AllItems.SHOPPING_LIST)) {
            prevListItem = itemInHand;
            addOntoList = true;
        }
        if (!itemInHand.isEmpty() && !addOntoList) {
            player.displayClientMessage((Component)Component.translatable((String)"create.stock_keeper.shopping_list_empty_hand"), true);
            AllSoundEvents.DENY.playOnServer(this.level, (Vec3i)this.worldPosition, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.getPaymentItem().isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"create.stock_keeper.no_price_set"), true);
            AllSoundEvents.DENY.playOnServer(this.level, (Vec3i)this.worldPosition, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        UUID tickerID = null;
        BlockPos tickerPos = this.requestData.targetOffset().offset((Vec3i)this.worldPosition);
        BlockEntity blockEntity = this.level.getBlockEntity(tickerPos);
        if (blockEntity instanceof StockTickerBlockEntity && (stbe = (StockTickerBlockEntity)blockEntity).isKeeperPresent()) {
            tickerID = stbe.behaviour.freqId;
        }
        int stockLevel = this.getStockLevelForTrade(ShoppingListItem.getList(prevListItem));
        if (tickerID == null) {
            player.displayClientMessage((Component)Component.translatable((String)"create.stock_keeper.keeper_missing").withStyle(ChatFormatting.RED), true);
            AllSoundEvents.DENY.playOnServer(this.level, (Vec3i)this.worldPosition, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (stockLevel == 0) {
            player.displayClientMessage((Component)Component.translatable((String)"create.stock_keeper.out_of_stock").withStyle(ChatFormatting.RED), true);
            AllSoundEvents.DENY.playOnServer(this.level, (Vec3i)this.worldPosition, 0.5f, 1.0f);
            if (!prevListItem.isEmpty()) {
                if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, prevListItem);
                } else {
                    player.getInventory().placeItemBackInInventory(prevListItem);
                }
            }
            return InteractionResult.SUCCESS;
        }
        Object list = new ShoppingList(new ArrayList<IntAttached<BlockPos>>(), this.owner, tickerID);
        if (addOntoList) {
            ShoppingList prevList = ShoppingListItem.getList(prevListItem).duplicate();
            if (this.owner.equals(prevList.shopOwner()) && tickerID.equals(prevList.shopNetwork())) {
                list = prevList;
            } else {
                addOntoList = false;
            }
        }
        if (((ShoppingList)list).getPurchases(this.worldPosition) >= stockLevel) {
            for (IntAttached intAttached : ((ShoppingList)list).purchases()) {
                if (!this.worldPosition.equals(intAttached.getValue())) continue;
                intAttached.setFirst(Math.min(stockLevel, (Integer)intAttached.getFirst()));
            }
            player.displayClientMessage((Component)Component.translatable((String)"create.stock_keeper.limited_stock").withStyle(ChatFormatting.RED), true);
        } else {
            AllSoundEvents.CONFIRM_2.playOnServer(this.level, (Vec3i)this.worldPosition, 0.5f, 1.0f);
            ShoppingList.Mutable mutable = new ShoppingList.Mutable((ShoppingList)list);
            mutable.addPurchases(this.worldPosition, 1);
            list = mutable.toImmutable();
            if (!addOntoList) {
                player.displayClientMessage((Component)Component.translatable((String)"create.stock_keeper.use_list_to_add_purchases").withColor(0xEEEEEE), true);
            }
            if (!addOntoList) {
                this.level.playSound(null, this.worldPosition, SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS, 1.0f, 1.5f);
            }
        }
        ItemStack newListItem = ShoppingListItem.saveList(AllItems.SHOPPING_LIST.getDefaultInstance(), (ShoppingList)list, this.requestData.encodedTargetAddress());
        if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, newListItem);
        } else {
            player.getInventory().placeItemBackInInventory(newListItem);
        }
        return InteractionResult.SUCCESS;
    }

    public int getStockLevelForTrade(@Nullable ShoppingList otherPurchases) {
        InventorySummary recentSummary;
        BlockPos tickerPos = this.requestData.targetOffset().offset((Vec3i)this.worldPosition);
        BlockEntity blockEntity = this.level.getBlockEntity(tickerPos);
        if (!(blockEntity instanceof StockTickerBlockEntity)) {
            return 0;
        }
        StockTickerBlockEntity stbe = (StockTickerBlockEntity)blockEntity;
        if (this.level.isClientSide()) {
            if (stbe.getTicksSinceLastUpdate() > 15) {
                stbe.resetTicksSinceLastUpdate();
                AllClientHandle.INSTANCE.sendPacket(new LogisticalStockRequestPacket(stbe.getBlockPos()));
            }
            recentSummary = stbe.getLastClientsideStockSnapshotAsSummary();
        } else {
            recentSummary = stbe.getRecentSummary();
        }
        if (recentSummary == null) {
            return 0;
        }
        InventorySummary modifierSummary = new InventorySummary();
        if (otherPurchases != null) {
            modifierSummary = (InventorySummary)otherPurchases.bakeEntries((LevelAccessor)this.level, this.worldPosition).getFirst();
        }
        int smallestQuotient = Integer.MAX_VALUE;
        for (BigItemStack entry : this.requestData.encodedRequest().stacks()) {
            if (entry.count <= 0) continue;
            smallestQuotient = Math.min(smallestQuotient, (recentSummary.getCountOf(entry.stack) - modifierSummary.getCountOf(entry.stack)) / entry.count);
        }
        return smallestQuotient;
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.store("Items", CreateCodecs.ITEM_LIST_CODEC, this.manuallyAddedItems);
        view.store("Facing", (Codec)Direction.CODEC, (Object)this.facing);
        view.store("RequestData", AutoRequestData.CODEC, (Object)this.requestData);
        if (this.owner != null) {
            view.store("OwnerUUID", UUIDUtil.CODEC, (Object)this.owner);
        }
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.manuallyAddedItems.clear();
        view.read("Items", CreateCodecs.ITEM_LIST_CODEC).ifPresent(list -> this.manuallyAddedItems.addAll((Collection<ItemStack>)list));
        this.requestData = view.read("RequestData", AutoRequestData.CODEC).orElseGet(AutoRequestData::new);
        this.owner = view.read("OwnerUUID", UUIDUtil.CODEC).orElse(null);
        this.facing = view.read("Facing", (Codec)Direction.CODEC).orElse(Direction.DOWN);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.manuallyAddedItems.forEach(stack -> Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)stack));
        this.manuallyAddedItems.clear();
    }

    public ItemStack getPaymentItem() {
        return this.priceTag.getFilter();
    }

    public int getPaymentAmount() {
        return this.priceTag.getFilter().isEmpty() ? 1 : this.priceTag.count;
    }

    @Override
    public void transform(BlockEntity blockEntity, StructureTransform transform) {
        this.facing = transform.mirrorFacing(this.facing);
        if (transform.rotationAxis == Direction.Axis.Y) {
            this.facing = transform.rotateFacing(this.facing);
        }
        this.notifyUpdate();
    }
}

