/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.logistics.vault;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.api.packager.InventoryIdentifier;
import com.zurrtum.create.content.logistics.vault.ItemVaultBlock;
import com.zurrtum.create.foundation.block.NeighborChangeListeningBlock;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventory;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.util.BitSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ItemVaultBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Inventory {
    protected Supplier<ItemInventory> itemCapability = null;
    protected InventoryIdentifier invId;
    protected ItemVaultHandler inventory = new ItemVaultHandler();
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    protected int radius = 1;
    protected int length = 1;
    protected Direction.Axis axis;

    public ItemVaultBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.ITEM_VAULT, pos, state);
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
        super.preRemoveSideEffects(pos, oldState);
        Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.inventory);
        this.level.removeBlockEntity(pos);
        ConnectivityHandler.splitMulti(this);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level.isClientSide()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti(this);
    }

    protected void updateComparators() {
        ItemVaultBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        this.level.blockEntityChanged(controllerBE.worldPosition);
        BlockPos pos = controllerBE.getBlockPos();
        int radius = controllerBE.radius;
        int length = controllerBE.length;
        Direction.Axis axis = controllerBE.getMainConnectionAxis();
        int zMax = axis == Direction.Axis.X ? radius : length;
        int xMax = axis == Direction.Axis.Z ? radius : length;
        BlockPos.MutableBlockPos updatePos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos provokingPos = new BlockPos.MutableBlockPos();
        for (int y = 0; y < radius; ++y) {
            for (int z = 0; z < zMax; ++z) {
                for (int x = 0; x < xMax; ++x) {
                    int sectionZ;
                    int sectionX = SectionPos.blockToSectionCoord((int)(pos.getX() + x));
                    if (!this.level.hasChunk(sectionX, sectionZ = SectionPos.blockToSectionCoord((int)(pos.getZ() + z)))) continue;
                    provokingPos.setWithOffset((Vec3i)pos, x, y, z);
                    Block provokingBlock = this.level.getBlockState((BlockPos)provokingPos).getBlock();
                    if (y == 0) {
                        ItemVaultBlockEntity.updateComparatorsInner(this.level, provokingBlock, (BlockPos)provokingPos, updatePos, Direction.DOWN);
                    }
                    if (y == radius - 1) {
                        ItemVaultBlockEntity.updateComparatorsInner(this.level, provokingBlock, (BlockPos)provokingPos, updatePos, Direction.UP);
                    }
                    if (z == 0) {
                        ItemVaultBlockEntity.updateComparatorsInner(this.level, provokingBlock, (BlockPos)provokingPos, updatePos, Direction.NORTH);
                    }
                    if (z == zMax - 1) {
                        ItemVaultBlockEntity.updateComparatorsInner(this.level, provokingBlock, (BlockPos)provokingPos, updatePos, Direction.SOUTH);
                    }
                    if (x == 0) {
                        ItemVaultBlockEntity.updateComparatorsInner(this.level, provokingBlock, (BlockPos)provokingPos, updatePos, Direction.WEST);
                    }
                    if (x != xMax - 1) continue;
                    ItemVaultBlockEntity.updateComparatorsInner(this.level, provokingBlock, (BlockPos)provokingPos, updatePos, Direction.EAST);
                }
            }
        }
    }

    private static void updateComparatorsInner(Level level, Block provokingBlock, BlockPos provokingPos, BlockPos.MutableBlockPos updatePos, Direction direction) {
        updatePos.setWithOffset((Vec3i)provokingPos, direction);
        int sectionX = SectionPos.blockToSectionCoord((int)updatePos.getX());
        int sectionZ = SectionPos.blockToSectionCoord((int)updatePos.getZ());
        if (!level.hasChunk(sectionX, sectionZ)) {
            return;
        }
        BlockState blockstate = level.getBlockState((BlockPos)updatePos);
        Block block = blockstate.getBlock();
        if (block instanceof NeighborChangeListeningBlock) {
            NeighborChangeListeningBlock block2 = (NeighborChangeListeningBlock)block;
            block2.onNeighborChange(blockstate, (LevelReader)level, (BlockPos)updatePos, provokingPos);
        }
        if (blockstate.is(Blocks.COMPARATOR)) {
            level.neighborChanged(blockstate, (BlockPos)updatePos, provokingBlock, null, false);
        } else if (blockstate.isRedstoneConductor((BlockGetter)level, (BlockPos)updatePos)) {
            updatePos.move(direction);
            blockstate = level.getBlockState((BlockPos)updatePos);
            if (blockstate.is(Blocks.COMPARATOR)) {
                level.neighborChanged(blockstate, (BlockPos)updatePos, provokingBlock, null, false);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.getBlockPos();
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition) && this.worldPosition != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    @Override
    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    @Override
    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.worldPosition;
    }

    public ItemVaultBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof ItemVaultBlockEntity) {
            return (ItemVaultBlockEntity)blockEntity;
        }
        return null;
    }

    @Override
    public void removeController(boolean keepContents) {
        if (this.level.isClientSide()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.length = 1;
        BlockState state = this.getBlockState();
        if (ItemVaultBlock.isVault(state)) {
            state = (BlockState)state.setValue((Property)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(false));
            this.getLevel().setBlock(this.worldPosition, state, 22);
        }
        this.itemCapability = null;
        this.setChanged();
        this.sendData();
    }

    @Override
    public void setController(BlockPos controller) {
        if (this.level.isClientSide() && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.itemCapability = null;
        this.setChanged();
        this.sendData();
    }

    @Override
    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        boolean changeOfController;
        super.read(view, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevLength = this.length;
        this.updateConnectivity = view.getBooleanOr("Uninitialized", false);
        this.lastKnownPos = view.read("LastKnownPos", BlockPos.CODEC).orElse(null);
        this.controller = view.read("Controller", BlockPos.CODEC).orElse(null);
        if (this.isController()) {
            this.radius = view.getIntOr("Size", 0);
            this.length = view.getIntOr("Length", 0);
        }
        if (!clientPacket) {
            this.inventory.read(view);
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (this.hasLevel() && (changeOfController || prevSize != this.radius || prevLength != this.length)) {
            this.level.setBlocksDirty(this.getBlockPos(), Blocks.AIR.defaultBlockState(), this.getBlockState());
        }
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        if (this.updateConnectivity) {
            view.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            view.store("LastKnownPos", BlockPos.CODEC, (Object)this.lastKnownPos);
        }
        if (this.isController()) {
            view.putInt("Size", this.radius);
            view.putInt("Length", this.length);
        } else {
            view.store("Controller", BlockPos.CODEC, (Object)this.controller);
        }
        super.write(view, clientPacket);
        if (!clientPacket) {
            view.putString("StorageType", "CombinedInv");
            this.inventory.write(view);
        }
    }

    public ItemVaultHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public InventoryIdentifier getInvId() {
        this.initCapability();
        return this.invId;
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        int i;
        int size = handler.getContainerSize();
        for (i = 0; i < size; ++i) {
            this.inventory.setItem(i, handler.getItem(i));
        }
        int max = this.inventory.getContainerSize();
        for (i = size; i < max; ++i) {
            this.inventory.setItem(i, ItemStack.EMPTY);
        }
    }

    public void initCapability() {
        if (!this.isController()) {
            ItemVaultBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            if (controllerBE.itemCapability == null || controllerBE.itemCapability.get() == null) {
                controllerBE.initCapability();
            }
            this.itemCapability = () -> {
                if (controllerBE.isRemoved()) {
                    return null;
                }
                if (controllerBE.itemCapability == null) {
                    return null;
                }
                return controllerBE.itemCapability.get();
            };
            this.invId = controllerBE.invId;
            return;
        }
        boolean alongZ = ItemVaultBlock.getVaultBlockAxis(this.getBlockState()) == Direction.Axis.Z;
        ItemVaultHandler[] invs = new ItemVaultHandler[this.length * this.radius * this.radius];
        block0: for (int yOffset = 0; yOffset < this.length; ++yOffset) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    BlockPos vaultPos = alongZ ? this.worldPosition.offset(xOffset, zOffset, yOffset) : this.worldPosition.offset(yOffset, xOffset, zOffset);
                    ItemVaultBlockEntity vaultAt = (ItemVaultBlockEntity)ConnectivityHandler.partAt(AllBlockEntityTypes.ITEM_VAULT, (BlockGetter)this.level, vaultPos);
                    if (vaultAt == null) {
                        invs = null;
                        break block0;
                    }
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = vaultAt.inventory;
                }
            }
        }
        if (invs == null) {
            this.itemCapability = null;
        } else {
            ConnectedItemVaultHandler capability = new ConnectedItemVaultHandler(invs);
            this.itemCapability = () -> capability;
        }
        BlockPos farCorner = alongZ ? this.worldPosition.offset(this.radius, this.radius, this.length) : this.worldPosition.offset(this.length, this.radius, this.radius);
        BoundingBox bounds = BoundingBox.fromCorners((Vec3i)this.worldPosition, (Vec3i)farCorner);
        this.invId = new InventoryIdentifier.Bounds(bounds);
    }

    public static int getMaxLength(int radius) {
        return radius * 3;
    }

    @Override
    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    @Override
    public void notifyMultiUpdated() {
        BlockState state = this.getBlockState();
        if (ItemVaultBlock.isVault(state)) {
            this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
        }
        this.itemCapability = null;
        this.setChanged();
    }

    @Override
    public Direction.Axis getMainConnectionAxis() {
        return this.getMainAxisOf(this);
    }

    @Override
    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return this.getMaxWidth();
        }
        return ItemVaultBlockEntity.getMaxLength(width);
    }

    @Override
    public int getMaxWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return this.length;
    }

    @Override
    public int getWidth() {
        return this.radius;
    }

    @Override
    public void setHeight(int height) {
        this.length = height;
    }

    @Override
    public void setWidth(int width) {
        this.radius = width;
    }

    @Override
    public boolean hasInventory() {
        return true;
    }

    public class ItemVaultHandler
    implements ItemInventory {
        private final int size;
        protected final NonNullList<ItemStack> stacks;

        public ItemVaultHandler() {
            this.size = (Integer)AllConfigs.server().logistics.vaultCapacity.get();
            this.stacks = NonNullList.withSize((int)this.size, (Object)ItemStack.EMPTY);
        }

        public int getContainerSize() {
            return this.size;
        }

        public ItemStack getItem(int slot) {
            if (slot >= this.size) {
                return ItemStack.EMPTY;
            }
            return (ItemStack)this.stacks.get(slot);
        }

        public void setItem(int slot, ItemStack stack) {
            if (slot >= this.size) {
                return;
            }
            this.stacks.set(slot, (Object)stack);
        }

        @Override
        public void setChanged() {
            ItemVaultBlockEntity.this.level.blockEntityChanged(ItemVaultBlockEntity.this.worldPosition);
        }

        public void write(ValueOutput view) {
            ValueOutput.TypedOutputList list = view.list("Inventory", ItemStack.CODEC);
            for (ItemStack stack : this.stacks) {
                if (stack.isEmpty()) continue;
                list.add((Object)stack);
            }
        }

        public void read(ValueInput view) {
            ValueInput.TypedInputList list = view.listOrEmpty("Inventory", ItemStack.CODEC);
            int i = 0;
            for (ItemStack itemStack : list) {
                this.stacks.set(i++, (Object)itemStack);
            }
            int size = this.stacks.size();
            while (i < size) {
                this.stacks.set(i, (Object)ItemStack.EMPTY);
                ++i;
            }
        }
    }

    public class ConnectedItemVaultHandler
    implements ItemInventory,
    VersionedInventory {
        private final ItemVaultHandler[] itemHandler;
        private final int vaultCapacity;
        private final int size;
        private final int id;
        private final BitSet accessed;
        private int version;

        public ConnectedItemVaultHandler(ItemVaultHandler[] invs) {
            this.vaultCapacity = (Integer)AllConfigs.server().logistics.vaultCapacity.get();
            this.itemHandler = invs;
            this.size = this.vaultCapacity * invs.length;
            this.id = idGenerator.getAndIncrement();
            this.accessed = new BitSet(invs.length);
            this.version = 0;
        }

        public int getContainerSize() {
            return this.size;
        }

        public ItemStack getItem(int slot) {
            if (slot >= this.size) {
                return ItemStack.EMPTY;
            }
            int i = slot / this.vaultCapacity;
            this.accessed.set(i);
            return this.itemHandler[i].getItem(slot % this.vaultCapacity);
        }

        public void setItem(int slot, ItemStack stack) {
            if (slot >= this.size) {
                return;
            }
            int i = slot / this.vaultCapacity;
            ItemVaultHandler handler = this.itemHandler[i];
            handler.setItem(slot % this.vaultCapacity, stack);
            handler.setChanged();
        }

        public int insert(ItemStack stack) {
            int maxAmount;
            if (stack.isEmpty()) {
                return 0;
            }
            int remaining = maxAmount = stack.getCount();
            for (ItemVaultHandler handler : this.itemHandler) {
                int insert = handler.insert(stack);
                if (remaining == insert) {
                    this.incrementVersion();
                    stack.setCount(maxAmount);
                    return maxAmount;
                }
                if (insert == 0) continue;
                stack.setCount(remaining -= insert);
            }
            if (remaining == maxAmount) {
                return 0;
            }
            this.incrementVersion();
            stack.setCount(maxAmount);
            return maxAmount - remaining;
        }

        public int extract(ItemStack stack) {
            int maxAmount;
            if (stack.isEmpty()) {
                return 0;
            }
            int remaining = maxAmount = stack.getCount();
            for (ItemVaultHandler handler : this.itemHandler) {
                int extract = handler.extract(stack);
                if (remaining == extract) {
                    this.incrementVersion();
                    stack.setCount(maxAmount);
                    return maxAmount;
                }
                if (extract == 0) continue;
                stack.setCount(remaining -= extract);
            }
            if (remaining == maxAmount) {
                return 0;
            }
            this.incrementVersion();
            stack.setCount(maxAmount);
            return maxAmount - remaining;
        }

        public ItemStack extract(Predicate<ItemStack> predicate, int maxAmount) {
            if (maxAmount == 0) {
                return ItemStack.EMPTY;
            }
            int size = this.itemHandler.length;
            for (int i = 0; i < size; ++i) {
                ItemStack findStack = this.itemHandler[i].extract(predicate, maxAmount);
                if (findStack == ItemStack.EMPTY) continue;
                int extract = findStack.getCount();
                if (extract == maxAmount) {
                    this.incrementVersion();
                    return findStack;
                }
                if (++i == size) {
                    this.incrementVersion();
                    return findStack;
                }
                int remaining = maxAmount - extract;
                while (i < size) {
                    extract = this.itemHandler[i].extract(findStack);
                    if (remaining == extract) {
                        this.incrementVersion();
                        findStack.setCount(maxAmount);
                        return findStack;
                    }
                    if (extract != 0) {
                        findStack.setCount(remaining -= extract);
                    }
                    ++i;
                }
                this.incrementVersion();
                findStack.setCount(maxAmount - remaining);
                return findStack;
            }
            return ItemStack.EMPTY;
        }

        public ItemStack preciseExtract(Predicate<ItemStack> predicate, int maxAmount) {
            if (maxAmount == 0) {
                return ItemStack.EMPTY;
            }
            int size = this.itemHandler.length;
            for (int i = 0; i < size; ++i) {
                ItemStack findStack = this.itemHandler[i].count(predicate, maxAmount);
                if (findStack.isEmpty()) continue;
                int count = findStack.getCount();
                if (count == maxAmount) {
                    this.itemHandler[i].extract(findStack);
                    this.incrementVersion();
                    return findStack;
                }
                if (++i == size) break;
                int[] extracts = new int[size];
                int remaining = maxAmount - count;
                while (i < size) {
                    int extract = this.itemHandler[i].count(findStack, remaining);
                    if (extract != 0) {
                        extracts[i] = extract;
                        if (remaining > extract) {
                            remaining -= extract;
                        } else {
                            this.itemHandler[0].extract(findStack);
                            for (int j = 1; j <= i; ++j) {
                                extract = extracts[j];
                                if (extract == 0) continue;
                                findStack.setCount(extract);
                                this.itemHandler[j].extract(findStack);
                            }
                            this.incrementVersion();
                            findStack.setCount(maxAmount);
                            return findStack;
                        }
                    }
                    ++i;
                }
            }
            return ItemStack.EMPTY;
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public void setChanged() {
            for (ItemVaultHandler inventory : this.itemHandler) {
                inventory.setChanged();
            }
            this.incrementVersion();
        }

        private void incrementVersion() {
            ItemVaultBlockEntity.this.updateComparators();
            ++this.version;
        }
    }
}

