/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.basin;

import com.zurrtum.create.Create;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.basin.BasinRecipe;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.simple.DeferralBehaviour;
import com.zurrtum.create.foundation.recipe.RecipeFinder;
import com.zurrtum.create.foundation.recipe.trie.AbstractVariant;
import com.zurrtum.create.foundation.recipe.trie.RecipeTrie;
import com.zurrtum.create.foundation.recipe.trie.RecipeTrieFinder;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BasinOperatingBlockEntity
extends KineticBlockEntity {
    public DeferralBehaviour basinChecker;
    public boolean basinRemoved;
    protected Recipe<?> currentRecipe;
    private final BasinRecipeFinder finder = new BasinRecipeFinder();

    public BasinOperatingBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        this.basinChecker = new DeferralBehaviour(this, this::updateBasin);
        behaviours.add(this.basinChecker);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.basinRemoved = false;
        this.basinChecker.scheduleUpdate();
    }

    @Override
    public void tick() {
        if (this.basinRemoved) {
            this.basinRemoved = false;
            this.onBasinRemoved();
            this.sendData();
            return;
        }
        super.tick();
    }

    protected boolean updateBasin() {
        if (!this.isSpeedRequirementFulfilled()) {
            return true;
        }
        if (this.getSpeed() == 0.0f) {
            return true;
        }
        if (this.isRunning()) {
            return true;
        }
        if (this.level == null || this.level.isClientSide()) {
            return true;
        }
        Optional<BasinBlockEntity> basin = this.getBasin();
        if (basin.filter(BasinBlockEntity::canContinueProcessing).isEmpty()) {
            return true;
        }
        Recipe<?> recipe = this.getMatchingRecipes();
        if (recipe == null) {
            return true;
        }
        this.currentRecipe = recipe;
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    protected abstract boolean isRunning();

    public void startProcessingBasin() {
    }

    public boolean continueWithPreviousRecipe() {
        return true;
    }

    protected boolean matchBasinRecipe(Recipe<?> recipe) {
        if (recipe == null) {
            return false;
        }
        return this.getBasin().map(blockEntity -> {
            Recipe recipe2 = recipe;
            Objects.requireNonNull(recipe2);
            Recipe selector0$temp = recipe2;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BasinRecipe.class, ShapedRecipe.class, ShapelessRecipe.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    BasinRecipe basinRecipe = (BasinRecipe)selector0$temp;
                    yield basinRecipe.matches(new BasinInput((BasinBlockEntity)blockEntity), this.level);
                }
                case 1 -> {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)selector0$temp;
                    yield BasinRecipe.matchCraftingRecipe(new BasinInput((BasinBlockEntity)blockEntity), shapedRecipe, this.level);
                }
                case 2 -> {
                    ShapelessRecipe shapelessRecipe = (ShapelessRecipe)selector0$temp;
                    yield BasinRecipe.matchCraftingRecipe(new BasinInput((BasinBlockEntity)blockEntity), shapelessRecipe, this.level);
                }
                default -> false;
            };
        }).orElse(false);
    }

    protected void applyBasinRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        Optional<BasinBlockEntity> optionalBasin = this.getBasin();
        if (optionalBasin.isEmpty()) {
            return;
        }
        BasinBlockEntity basin = optionalBasin.get();
        boolean wasEmpty = basin.canContinueProcessing();
        Recipe<?> recipe = this.currentRecipe;
        Objects.requireNonNull(recipe);
        Recipe<?> recipe2 = recipe;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BasinRecipe.class, ShapedRecipe.class, ShapelessRecipe.class}, recipe2, n)) {
            case 0: {
                BasinRecipe basinRecipe = (BasinRecipe)recipe2;
                if (basinRecipe.apply(new BasinInput(basin))) break;
                return;
            }
            case 1: {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe2;
                if (BasinRecipe.applyCraftingRecipe(new BasinInput(basin), shapedRecipe, this.level)) break;
                return;
            }
            case 2: {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe2;
                if (BasinRecipe.applyCraftingRecipe(new BasinInput(basin), shapelessRecipe, this.level)) break;
                return;
            }
            default: {
                return;
            }
        }
        this.getProcessedRecipeTrigger().ifPresent(this::award);
        basin.inputTank.sendDataImmediately();
        if (wasEmpty && this.matchBasinRecipe(this.currentRecipe)) {
            this.continueWithPreviousRecipe();
            this.sendData();
        }
        basin.notifyChangeOfContents();
    }

    protected Recipe<?> getMatchingRecipes() {
        BasinBlockEntity basin;
        Optional<BasinBlockEntity> $basin = this.getBasin();
        if ($basin.isEmpty() || (basin = $basin.get()).isEmpty()) {
            return null;
        }
        if (basin.itemCapability == null && basin.fluidCapability == null) {
            return null;
        }
        try {
            RecipeTrie<Recipe<?>> trie = RecipeTrieFinder.get(this.getRecipeCacheKey(), (ServerLevel)this.level, this::matchStaticFilters);
            Set<AbstractVariant> availableVariants = RecipeTrie.getVariants(basin.itemCapability, basin.fluidCapability);
            return this.finder.match(basin, trie.lookup(availableVariants));
        }
        catch (Exception e) {
            Create.LOGGER.error("Failed to get recipe trie, falling back to slow logic", (Throwable)e);
            List<RecipeHolder<Recipe<?>>> recipes = RecipeFinder.get(this.getRecipeCacheKey(), (ServerLevel)this.level, this::matchStaticFilters);
            if (recipes.isEmpty()) {
                return null;
            }
            return this.finder.matchEntry(basin, recipes);
        }
    }

    protected abstract void onBasinRemoved();

    protected Optional<BasinBlockEntity> getBasin() {
        if (this.level == null) {
            return Optional.empty();
        }
        BlockEntity basinBE = this.level.getBlockEntity(this.worldPosition.below(2));
        if (!(basinBE instanceof BasinBlockEntity)) {
            return Optional.empty();
        }
        return Optional.of((BasinBlockEntity)basinBE);
    }

    protected Optional<CreateTrigger> getProcessedRecipeTrigger() {
        return Optional.empty();
    }

    protected abstract boolean matchStaticFilters(RecipeHolder<? extends Recipe<?>> var1);

    protected abstract Object getRecipeCacheKey();

    private class BasinRecipeFinder {
        private BasinInput basinInput;
        private Consumer<Recipe<?>> matchingStrategy;
        private Recipe<?> matchedRecipe;
        private int ingredientCount;

        private BasinRecipeFinder() {
        }

        public Recipe<?> match(BasinBlockEntity basin, List<Recipe<?>> recipes) {
            this.matchedRecipe = null;
            this.matchingStrategy = this::firstMatchStrategy;
            this.basinInput = new BasinInput(basin);
            for (Recipe<?> recipe : recipes) {
                this.matchingStrategy.accept(recipe);
            }
            return this.matchedRecipe;
        }

        public Recipe<?> matchEntry(BasinBlockEntity basin, List<RecipeHolder<? extends Recipe<?>>> recipes) {
            this.matchedRecipe = null;
            this.matchingStrategy = this::firstMatchStrategy;
            this.basinInput = new BasinInput(basin);
            for (RecipeHolder<Recipe<?>> recipeHolder : recipes) {
                this.matchingStrategy.accept(recipeHolder.value());
            }
            return this.matchedRecipe;
        }

        private void updateMatchedRecipe(Recipe<?> recipe, int size) {
            this.matchedRecipe = recipe;
            this.ingredientCount = size;
        }

        private void firstMatchStrategy(Recipe<?> candidateRecipe) {
            Recipe<?> recipe = candidateRecipe;
            Objects.requireNonNull(recipe);
            Recipe<?> recipe2 = recipe;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BasinRecipe.class, ShapedRecipe.class, ShapelessRecipe.class}, recipe2, n)) {
                case 0: {
                    BasinRecipe recipe3 = (BasinRecipe)recipe2;
                    if (!recipe3.matches(this.basinInput, BasinOperatingBlockEntity.this.level)) break;
                    this.updateMatchedRecipe(recipe3, recipe3.getIngredientSize());
                    this.matchingStrategy = this::selectBetterMatch;
                    break;
                }
                case 1: {
                    ShapedRecipe recipe4 = (ShapedRecipe)recipe2;
                    if (!BasinRecipe.matchCraftingRecipe(this.basinInput, recipe4, BasinOperatingBlockEntity.this.level)) break;
                    this.updateMatchedRecipe((Recipe<?>)recipe4, (int)recipe4.getIngredients().stream().filter(Optional::isPresent).count());
                    this.matchingStrategy = this::selectBetterMatch;
                    break;
                }
                case 2: {
                    ShapelessRecipe recipe5 = (ShapelessRecipe)recipe2;
                    if (!BasinRecipe.matchCraftingRecipe(this.basinInput, recipe5, BasinOperatingBlockEntity.this.level)) break;
                    this.updateMatchedRecipe((Recipe<?>)recipe5, recipe5.ingredients.size());
                    this.matchingStrategy = this::selectBetterMatch;
                    break;
                }
            }
        }

        private void selectBetterMatch(Recipe<?> candidateRecipe) {
            Recipe<?> recipe = candidateRecipe;
            Objects.requireNonNull(recipe);
            Recipe<?> recipe2 = recipe;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BasinRecipe.class, ShapedRecipe.class, ShapelessRecipe.class}, recipe2, n)) {
                case 0: {
                    BasinRecipe recipe3 = (BasinRecipe)recipe2;
                    int count = recipe3.getIngredientSize();
                    if (count <= this.ingredientCount || !recipe3.matches(this.basinInput, BasinOperatingBlockEntity.this.level)) break;
                    this.updateMatchedRecipe(recipe3, count);
                    break;
                }
                case 1: {
                    ShapedRecipe recipe4 = (ShapedRecipe)recipe2;
                    int count = recipe4.getIngredients().size();
                    if (count <= this.ingredientCount || !BasinRecipe.matchCraftingRecipe(this.basinInput, recipe4, BasinOperatingBlockEntity.this.level)) break;
                    this.updateMatchedRecipe((Recipe<?>)recipe4, count);
                    break;
                }
                case 2: {
                    ShapelessRecipe recipe5 = (ShapelessRecipe)recipe2;
                    int count = recipe5.ingredients.size();
                    if (count <= this.ingredientCount || !BasinRecipe.matchCraftingRecipe(this.basinInput, recipe5, BasinOperatingBlockEntity.this.level)) break;
                    this.updateMatchedRecipe((Recipe<?>)recipe5, count);
                    break;
                }
            }
        }
    }
}

