/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.basin;

import com.zurrtum.create.content.processing.basin.BasinInput;
import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface BasinRecipe
extends Recipe<BasinInput> {
    public static final Map<ShapelessRecipe, List<SizedIngredient>> SHAPELESS_CACHE = new IdentityHashMap<ShapelessRecipe, List<SizedIngredient>>();
    public static final Map<ShapedRecipe, List<SizedIngredient>> SHAPED_CACHE = new IdentityHashMap<ShapedRecipe, List<SizedIngredient>>();

    public static boolean matchCraftingRecipe(BasinInput input, ShapelessRecipe recipe, Level world) {
        return BasinRecipe.matchCraftingRecipe(input, recipe, world, SHAPELESS_CACHE, SizedIngredient::of);
    }

    public static boolean matchCraftingRecipe(BasinInput input, ShapedRecipe recipe, Level world) {
        return BasinRecipe.matchCraftingRecipe(input, recipe, world, SHAPED_CACHE, SizedIngredient::of);
    }

    private static <T extends CraftingRecipe> boolean matchCraftingRecipe(BasinInput input, T recipe, Level world, Map<T, List<SizedIngredient>> ingredientCache, Function<T, List<SizedIngredient>> recipeToIngredients) {
        ServerFilteringBehaviour filter = input.filter();
        if (filter == null) {
            return false;
        }
        ItemStack result = recipe.assemble(null, (HolderLookup.Provider)world.registryAccess());
        if (!filter.test(result)) {
            return false;
        }
        List<SizedIngredient> ingredients = ingredientCache.computeIfAbsent(recipe, recipeToIngredients);
        if (ingredients.isEmpty()) {
            return false;
        }
        List<ItemStack> outputs = BasinRecipe.tryCraft(input, ingredients);
        if (outputs == null) {
            return false;
        }
        outputs.add(result);
        return input.acceptOutputs(outputs, List.of(), true);
    }

    @Nullable
    public static List<ItemStack> tryCraft(BasinInput input, Ingredient ingredient) {
        Container inventory = input.items();
        int size = inventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !ingredient.test(stack)) continue;
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            ItemStack remainder = stack.getItem().getCraftingRemainder();
            if (remainder != ItemStack.EMPTY) {
                outputs.add(remainder);
            }
            return outputs;
        }
        return null;
    }

    @Nullable
    public static List<ItemStack> tryCraft(BasinInput input, SizedIngredient ingredient) {
        int remainder = ingredient.getCount();
        if (remainder == 1) {
            return BasinRecipe.tryCraft(input, ingredient.getIngredient());
        }
        Container inventory = input.items();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        int size = inventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !ingredient.test(stack)) continue;
            int extract = Math.min(stack.getCount(), remainder);
            BasinRecipe.addRecipeRemainder(stack, extract, outputs);
            if (extract == remainder) {
                return outputs;
            }
            remainder -= extract;
        }
        return null;
    }

    @Nullable
    public static List<ItemStack> tryCraft(BasinInput input, List<SizedIngredient> ingredients) {
        int ingredientIndex;
        int ingredientSize = ingredients.size();
        if (ingredientSize == 0) {
            return new ArrayList<ItemStack>();
        }
        if (ingredientSize == 1) {
            return BasinRecipe.tryCraft(input, ingredients.getFirst());
        }
        ArrayList<ItemStack> usings = new ArrayList<ItemStack>();
        LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
        Container inventory = input.items();
        int itemIndex = 0;
        int inventorySize = inventory.getContainerSize();
        block0: for (ingredientIndex = 0; ingredientIndex < ingredientSize; ++ingredientIndex) {
            SizedIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.getCount();
            while (itemIndex < inventorySize) {
                ItemStack stack = inventory.getItem(itemIndex);
                if (!stack.isEmpty()) {
                    if (ingredient.test(stack)) {
                        int count = stack.getCount();
                        if (count > remainder) {
                            usings.add(stack.copyWithCount(remainder));
                            ++itemIndex;
                            continue block0;
                        }
                        usings.add(stack);
                        if (count == remainder) {
                            ++itemIndex;
                            continue block0;
                        }
                        remainder -= count;
                    } else {
                        inputs.add(stack);
                    }
                }
                ++itemIndex;
            }
            Iterator iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (!ingredient.test(stack)) continue;
                iterator.remove();
                int count = stack.getCount();
                if (count > remainder) {
                    usings.add(stack.copyWithCount(remainder));
                    ++ingredientIndex;
                    break block0;
                }
                usings.add(stack);
                if (count == remainder) {
                    ++ingredientIndex;
                    break block0;
                }
                remainder -= count;
            }
            return null;
        }
        while (ingredientIndex < ingredientSize) {
            block18: {
                SizedIngredient ingredient = ingredients.get(ingredientIndex);
                int remainder = ingredient.getCount();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    ItemStack stack = (ItemStack)iterator.next();
                    if (!ingredient.test(stack)) continue;
                    iterator.remove();
                    int count = stack.getCount();
                    if (count > remainder) {
                        usings.add(stack.copyWithCount(remainder));
                    } else {
                        usings.add(stack);
                        if (count != remainder) {
                            remainder -= count;
                            continue;
                        }
                    }
                    break block18;
                }
                return null;
            }
            ++ingredientIndex;
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (ItemStack stack : usings) {
            BasinRecipe.addRecipeRemainder(stack, stack.getCount(), outputs);
        }
        return outputs;
    }

    public static boolean matchFluidIngredient(BasinInput input, @Nullable FluidIngredient ingredient) {
        if (ingredient == null) {
            return true;
        }
        int remainder = ingredient.amount();
        for (FluidStack stack : input.fluids()) {
            if (!ingredient.test(stack)) continue;
            int amount = stack.getAmount();
            if (amount >= remainder) {
                return true;
            }
            remainder -= amount;
        }
        return false;
    }

    public static boolean matchFluidIngredient(BasinInput input, List<FluidIngredient> ingredients) {
        int ingredientIndex;
        int ingredientSize = ingredients.size();
        if (ingredientSize == 0) {
            return true;
        }
        if (ingredientSize == 1) {
            return BasinRecipe.matchFluidIngredient(input, ingredients.getFirst());
        }
        LinkedList<FluidStack> inputs = new LinkedList<FluidStack>();
        FluidInventory inventory = input.fluids();
        int fluidIndex = 0;
        int inventorySize = inventory.size();
        block0: for (ingredientIndex = 0; ingredientIndex < ingredientSize; ++ingredientIndex) {
            FluidIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.amount();
            while (fluidIndex < inventorySize) {
                FluidStack stack = inventory.getStack(fluidIndex);
                if (!stack.isEmpty()) {
                    if (ingredient.test(stack)) {
                        int amount = stack.getAmount();
                        if (amount >= remainder) {
                            ++fluidIndex;
                            continue block0;
                        }
                        remainder -= amount;
                    } else {
                        inputs.add(stack);
                    }
                }
                ++fluidIndex;
            }
            Iterator iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                FluidStack stack = (FluidStack)iterator.next();
                if (!ingredient.test(stack)) continue;
                iterator.remove();
                int count = stack.getAmount();
                if (count >= remainder) {
                    ++ingredientIndex;
                    break block0;
                }
                remainder -= count;
            }
            return false;
        }
        while (ingredientIndex < ingredientSize) {
            block13: {
                FluidIngredient ingredient = ingredients.get(ingredientIndex);
                int remainder = ingredient.amount();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    FluidStack stack = (FluidStack)iterator.next();
                    if (!ingredient.test(stack)) continue;
                    iterator.remove();
                    int count = stack.getAmount();
                    if (count < remainder) {
                        remainder -= count;
                        continue;
                    }
                    break block13;
                }
                return false;
            }
            ++ingredientIndex;
        }
        return true;
    }

    public static boolean applyCraftingRecipe(BasinInput input, ShapedRecipe recipe, Level world) {
        return BasinRecipe.applyCraftingRecipe(input, recipe, world, SHAPED_CACHE, SizedIngredient::of);
    }

    public static boolean applyCraftingRecipe(BasinInput input, ShapelessRecipe recipe, Level world) {
        return BasinRecipe.applyCraftingRecipe(input, recipe, world, SHAPELESS_CACHE, SizedIngredient::of);
    }

    private static <T extends CraftingRecipe> boolean applyCraftingRecipe(BasinInput input, T recipe, Level world, Map<T, List<SizedIngredient>> ingredientCache, Function<T, List<SizedIngredient>> recipeToIngredients) {
        ArrayDeque<Runnable> changes;
        List<SizedIngredient> ingredients = ingredientCache.computeIfAbsent(recipe, recipeToIngredients);
        List<ItemStack> outputs = BasinRecipe.prepareCraft(input, ingredients, changes = new ArrayDeque<Runnable>());
        if (outputs == null) {
            return false;
        }
        outputs.add(recipe.assemble(null, (HolderLookup.Provider)world.registryAccess()));
        if (!input.acceptOutputs(outputs, List.of(), true)) {
            return false;
        }
        changes.forEach(Runnable::run);
        return input.acceptOutputs(outputs, List.of(), false);
    }

    public static void addRecipeRemainder(ItemStack stack, int count, List<ItemStack> outputs) {
        Item item = stack.getItem();
        for (int i = 0; i < count; ++i) {
            ItemStack remainder = item.getCraftingRemainder();
            if (remainder == ItemStack.EMPTY) continue;
            outputs.add(remainder);
        }
    }

    @Nullable
    public static List<ItemStack> prepareCraft(BasinInput input, Ingredient ingredient, Deque<Runnable> changes) {
        Container inventory = input.items();
        int size = inventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !ingredient.test(stack)) continue;
            int count = stack.getCount();
            if (count > 1) {
                int newCount = count - 1;
                changes.add(() -> {
                    stack.setCount(newCount);
                    inventory.setChanged();
                });
            } else {
                int slot = i;
                changes.add(() -> {
                    inventory.setItem(slot, ItemStack.EMPTY);
                    inventory.setChanged();
                });
            }
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            ItemStack remainder = stack.getItem().getCraftingRemainder();
            if (remainder != ItemStack.EMPTY) {
                outputs.add(remainder);
            }
            return outputs;
        }
        return null;
    }

    @Nullable
    public static List<ItemStack> prepareCraft(BasinInput input, SizedIngredient ingredient, Deque<Runnable> changes) {
        int remainder = ingredient.getCount();
        if (remainder == 1) {
            return BasinRecipe.prepareCraft(input, ingredient.getIngredient(), changes);
        }
        Container inventory = input.items();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        int size = inventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            int using;
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !ingredient.test(stack)) continue;
            int count = stack.getCount();
            if (count > remainder) {
                int newCount = count - remainder;
                changes.add(() -> stack.setCount(newCount));
                using = remainder;
            } else {
                int slot = i;
                changes.add(() -> inventory.setItem(slot, ItemStack.EMPTY));
                using = count;
            }
            BasinRecipe.addRecipeRemainder(stack, using, outputs);
            if (using == remainder) {
                changes.add(() -> ((Container)inventory).setChanged());
                return outputs;
            }
            remainder -= using;
        }
        return null;
    }

    @Nullable
    public static List<ItemStack> prepareCraft(BasinInput input, List<SizedIngredient> ingredients, Deque<Runnable> changes) {
        int ingredientIndex;
        int ingredientSize = ingredients.size();
        if (ingredientSize == 0) {
            return new ArrayList<ItemStack>();
        }
        if (ingredientSize == 1) {
            return BasinRecipe.prepareCraft(input, ingredients.getFirst(), changes);
        }
        ArrayList<ItemStack> usings = new ArrayList<ItemStack>();
        LinkedList<IntObjectPair> inputs = new LinkedList<IntObjectPair>();
        Container inventory = input.items();
        int itemIndex = 0;
        int inventorySize = inventory.getContainerSize();
        block0: for (ingredientIndex = 0; ingredientIndex < ingredientSize; ++ingredientIndex) {
            SizedIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.getCount();
            while (itemIndex < inventorySize) {
                ItemStack stack = inventory.getItem(itemIndex);
                if (!stack.isEmpty()) {
                    if (ingredient.test(stack)) {
                        int count = stack.getCount();
                        if (count > remainder) {
                            usings.add(stack.copyWithCount(remainder));
                            int newCount = count - remainder;
                            changes.add(() -> stack.setCount(newCount));
                            ++itemIndex;
                            continue block0;
                        }
                        usings.add(stack);
                        int slot = itemIndex++;
                        changes.add(() -> inventory.setItem(slot, ItemStack.EMPTY));
                        if (count == remainder) continue block0;
                        remainder -= count;
                    } else {
                        inputs.add(IntObjectPair.of((int)itemIndex, (Object)stack));
                    }
                }
                ++itemIndex;
            }
            Iterator iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                IntObjectPair pair = (IntObjectPair)iterator.next();
                ItemStack stack = (ItemStack)pair.right();
                if (!ingredient.test(stack)) continue;
                iterator.remove();
                int count = stack.getCount();
                if (count > remainder) {
                    usings.add(stack.copyWithCount(remainder));
                    int newCount = count - remainder;
                    changes.add(() -> stack.setCount(newCount));
                    ++ingredientIndex;
                    break block0;
                }
                usings.add(stack);
                int slot = pair.leftInt();
                changes.add(() -> inventory.setItem(slot, ItemStack.EMPTY));
                if (count == remainder) {
                    ++ingredientIndex;
                    break block0;
                }
                remainder -= count;
            }
            return null;
        }
        while (ingredientIndex < ingredientSize) {
            block17: {
                SizedIngredient ingredient = ingredients.get(ingredientIndex);
                int remainder = ingredient.getCount();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    IntObjectPair pair = (IntObjectPair)iterator.next();
                    ItemStack stack = (ItemStack)pair.right();
                    if (!ingredient.test(stack)) continue;
                    iterator.remove();
                    int count = stack.getCount();
                    if (count > remainder) {
                        usings.add(stack.copyWithCount(remainder));
                        int newCount = count - remainder;
                        changes.add(() -> stack.setCount(newCount));
                    } else {
                        usings.add(stack);
                        int slot = pair.leftInt();
                        changes.add(() -> inventory.setItem(slot, ItemStack.EMPTY));
                        if (count != remainder) {
                            remainder -= count;
                            continue;
                        }
                    }
                    break block17;
                }
                return null;
            }
            ++ingredientIndex;
        }
        changes.add(() -> ((Container)inventory).setChanged());
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (ItemStack stack : usings) {
            BasinRecipe.addRecipeRemainder(stack, stack.getCount(), outputs);
        }
        return outputs;
    }

    public static boolean prepareFluidCraft(BasinInput input, @Nullable FluidIngredient ingredient, Deque<Runnable> changes) {
        if (ingredient == null) {
            return true;
        }
        FluidInventory inventory = input.fluids();
        int remainder = ingredient.amount();
        int fluidInventorySize = inventory.size();
        for (int fluidIndex = 0; fluidIndex < fluidInventorySize; ++fluidIndex) {
            FluidStack stack = inventory.getStack(fluidIndex);
            if (!ingredient.test(stack)) continue;
            int amount = stack.getAmount();
            if (amount > remainder) {
                int newAmount = amount - remainder;
                changes.add(() -> {
                    stack.setAmount(newAmount);
                    inventory.markDirty();
                });
                return true;
            }
            int slot = fluidIndex;
            if (remainder == amount) {
                changes.add(() -> {
                    inventory.setStack(slot, FluidStack.EMPTY);
                    inventory.markDirty();
                });
                return true;
            }
            changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
            remainder -= amount;
        }
        return false;
    }

    public static boolean prepareFluidCraft(BasinInput input, List<FluidIngredient> ingredients, Deque<Runnable> changes) {
        int ingredientIndex;
        int ingredientSize = ingredients.size();
        if (ingredientSize == 0) {
            return true;
        }
        if (ingredientSize == 1) {
            return BasinRecipe.prepareFluidCraft(input, ingredients.getFirst(), changes);
        }
        LinkedList<IntObjectPair> inputs = new LinkedList<IntObjectPair>();
        FluidInventory inventory = input.fluids();
        int fluidIndex = 0;
        int inventorySize = inventory.size();
        block0: for (ingredientIndex = 0; ingredientIndex < ingredientSize; ++ingredientIndex) {
            FluidIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.amount();
            while (fluidIndex < inventorySize) {
                FluidStack stack = inventory.getStack(fluidIndex);
                if (!stack.isEmpty()) {
                    if (ingredient.test(stack)) {
                        int count = stack.getAmount();
                        if (count > remainder) {
                            int newAmount = count - remainder;
                            changes.add(() -> stack.setAmount(newAmount));
                            ++fluidIndex;
                            continue block0;
                        }
                        int slot = fluidIndex++;
                        changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
                        if (count == remainder) continue block0;
                        remainder -= count;
                    } else {
                        inputs.add(IntObjectPair.of((int)fluidIndex, (Object)stack));
                    }
                }
                ++fluidIndex;
            }
            Iterator iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                IntObjectPair pair = (IntObjectPair)iterator.next();
                FluidStack stack = (FluidStack)pair.right();
                if (!ingredient.test(stack)) continue;
                iterator.remove();
                int count = stack.getAmount();
                if (count > remainder) {
                    int newAmount = count - remainder;
                    changes.add(() -> stack.setAmount(newAmount));
                    ++ingredientIndex;
                    break block0;
                }
                int slot = pair.leftInt();
                changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
                if (count == remainder) {
                    ++ingredientIndex;
                    break block0;
                }
                remainder -= count;
            }
            return false;
        }
        while (ingredientIndex < ingredientSize) {
            block16: {
                FluidIngredient ingredient = ingredients.get(ingredientIndex);
                int remainder = ingredient.amount();
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    IntObjectPair pair = (IntObjectPair)iterator.next();
                    FluidStack stack = (FluidStack)pair.right();
                    if (!ingredient.test(stack)) continue;
                    iterator.remove();
                    int count = stack.getAmount();
                    if (count > remainder) {
                        int newAmount = count - remainder;
                        changes.add(() -> stack.setAmount(newAmount));
                    } else {
                        int slot = pair.leftInt();
                        changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
                        if (count != remainder) {
                            remainder -= count;
                            continue;
                        }
                    }
                    break block16;
                }
                return false;
            }
            ++ingredientIndex;
        }
        changes.add(inventory::markDirty);
        return true;
    }

    public int getIngredientSize();

    public List<SizedIngredient> getIngredients();

    public List<FluidIngredient> getFluidIngredients();

    public boolean apply(BasinInput var1);

    default public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    default public RecipeBookCategory recipeBookCategory() {
        return null;
    }

    default public boolean isSpecial() {
        return true;
    }

    default public ItemStack assemble(BasinInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }
}

