/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.burner;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerInteractionHandler;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockItem;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.block.IBE;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlazeBurnerBlock
extends HorizontalDirectionalBlock
implements IBE<BlazeBurnerBlockEntity>,
IWrenchable,
SpecialBlockItemRequirement {
    public static final MapCodec<BlazeBurnerBlock> CODEC = BlazeBurnerBlock.simpleCodec(BlazeBurnerBlock::new);
    public static final EnumProperty<HeatLevel> HEAT_LEVEL = EnumProperty.create((String)"blaze", HeatLevel.class);

    public BlazeBurnerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HEAT_LEVEL, (Comparable)((Object)HeatLevel.NONE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HEAT_LEVEL, FACING});
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        if (world.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos.above());
        if (!(blockEntity instanceof BasinBlockEntity)) {
            return;
        }
        BasinBlockEntity basin = (BasinBlockEntity)blockEntity;
        basin.notifyChangeOfContents();
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (state.getValue(HEAT_LEVEL) == HeatLevel.NONE) {
            return null;
        }
        return IBE.super.newBlockEntity(pos, state);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean forceOverflow;
        HeatLevel heat = (HeatLevel)((Object)state.getValue(HEAT_LEVEL));
        if (stack.is((Item)AllItems.GOGGLES) && heat != HeatLevel.NONE) {
            return this.onBlockEntityUseItemOn((BlockGetter)level, pos, bbte -> {
                if (bbte.goggles) {
                    return InteractionResult.TRY_WITH_EMPTY_HAND;
                }
                bbte.goggles = true;
                bbte.notifyUpdate();
                return InteractionResult.SUCCESS;
            });
        }
        BlazeBurnerBlockEntity be = (BlazeBurnerBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null && be.stockKeeper) {
            StockTickerBlockEntity stockTicker = BlazeBurnerBlockEntity.getStockTicker((LevelAccessor)level, pos);
            if (stockTicker != null) {
                StockTickerInteractionHandler.interactWithLogisticsManagerAt(player, level, stockTicker.getBlockPos());
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.isEmpty() && heat != HeatLevel.NONE) {
            return this.onBlockEntityUseItemOn((BlockGetter)level, pos, bbte -> {
                if (!bbte.goggles) {
                    return InteractionResult.TRY_WITH_EMPTY_HAND;
                }
                bbte.goggles = false;
                bbte.notifyUpdate();
                return InteractionResult.SUCCESS;
            });
        }
        if (heat == HeatLevel.NONE) {
            if (stack.getItem() instanceof FlintAndSteelItem) {
                level.playSound((Entity)player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.4f + 0.8f);
                if (level.isClientSide()) {
                    return InteractionResult.SUCCESS;
                }
                stack.hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
                level.setBlockAndUpdate(pos, AllBlocks.LIT_BLAZE_BURNER.defaultBlockState());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        boolean doNotConsume = player.isCreative();
        InteractionResult res = BlazeBurnerBlock.tryInsert(state, level, pos, stack, doNotConsume, forceOverflow = !FakePlayerHandler.has((Entity)player), false);
        if (res instanceof InteractionResult.Success) {
            InteractionResult.Success success = (InteractionResult.Success)res;
            ItemStack leftover = success.heldItemTransformedTo();
            if (!(level.isClientSide() || doNotConsume || leftover == null || leftover.isEmpty())) {
                if (stack.isEmpty()) {
                    player.setItemInHand(hand, leftover);
                } else if (!player.getInventory().add(leftover)) {
                    player.drop(leftover, false);
                }
            }
        }
        if (res.consumesAction()) {
            return res;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public static InteractionResult tryInsert(BlockState state, Level world, BlockPos pos, ItemStack stack, boolean doNotConsume, boolean forceOverflow, boolean simulate) {
        if (!state.hasBlockEntity()) {
            return InteractionResult.FAIL;
        }
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof BlazeBurnerBlockEntity)) {
            return InteractionResult.FAIL;
        }
        BlazeBurnerBlockEntity burnerBE = (BlazeBurnerBlockEntity)be;
        if (burnerBE.isCreativeFuel(stack)) {
            if (!simulate) {
                burnerBE.applyCreativeFuel();
            }
            return InteractionResult.SUCCESS.heldItemTransformedTo(ItemStack.EMPTY);
        }
        if (!burnerBE.tryUpdateFuel(stack, forceOverflow, simulate)) {
            return InteractionResult.FAIL;
        }
        if (!doNotConsume) {
            ItemStack container = stack.getItem().getCraftingRemainder();
            if (!world.isClientSide()) {
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS.heldItemTransformedTo(container);
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(ItemStack.EMPTY);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        ItemStack stack = context.getItemInHand();
        Item item = stack.getItem();
        BlockState defaultState = this.defaultBlockState();
        if (!(item instanceof BlazeBurnerBlockItem)) {
            return defaultState;
        }
        HeatLevel initialHeat = ((BlazeBurnerBlockItem)item).hasCapturedBlaze() ? HeatLevel.SMOULDERING : HeatLevel.NONE;
        return (BlockState)((BlockState)defaultState.setValue(HEAT_LEVEL, (Comparable)((Object)initialHeat))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return AllShapes.HEATER_BLOCK_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        if (p_220071_4_ == CollisionContext.empty()) {
            return AllShapes.HEATER_BLOCK_SPECIAL_COLLISION_SHAPE;
        }
        return this.getShape(p_220071_1_, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    public boolean hasAnalogOutputSignal(BlockState p_149740_1_) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level p_180641_2_, BlockPos p_180641_3_, Direction direction) {
        return Math.max(0, ((HeatLevel)((Object)state.getValue(HEAT_LEVEL))).ordinal() - 1);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (random.nextInt(10) != 0) {
            return;
        }
        if (!((HeatLevel)((Object)state.getValue(HEAT_LEVEL))).isAtLeast(HeatLevel.SMOULDERING)) {
            return;
        }
        world.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static HeatLevel getHeatLevelOf(BlockState blockState) {
        return blockState.hasProperty(HEAT_LEVEL) ? (HeatLevel)((Object)blockState.getValue(HEAT_LEVEL)) : HeatLevel.NONE;
    }

    public static int getLight(BlockState state) {
        HeatLevel level = (HeatLevel)((Object)state.getValue(HEAT_LEVEL));
        return switch (level.ordinal()) {
            case 0 -> 0;
            case 1 -> 8;
            default -> 15;
        };
    }

    protected ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        return BlazeBurnerBlock.getLitOrUnlitStack(state);
    }

    @Override
    public Class<BlazeBurnerBlockEntity> getBlockEntityClass() {
        return BlazeBurnerBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends BlazeBurnerBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.HEATER;
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, @Nullable BlockEntity blockEntity) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, BlazeBurnerBlock.getLitOrUnlitStack(state));
    }

    private static ItemStack getLitOrUnlitStack(BlockState state) {
        boolean isLit = state.getValue(HEAT_LEVEL) != HeatLevel.NONE;
        return (isLit ? AllItems.BLAZE_BURNER : AllItems.EMPTY_BLAZE_BURNER).getDefaultInstance();
    }

    public static enum HeatLevel implements StringRepresentable
    {
        NONE,
        SMOULDERING,
        FADING,
        KINDLED,
        SEETHING;

        public static final Codec<HeatLevel> CODEC;

        public static HeatLevel byIndex(int index) {
            return HeatLevel.values()[index];
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isAtLeast(HeatLevel heatLevel) {
            return this.ordinal() >= heatLevel.ordinal();
        }

        public HeatLevel nextActiveLevel() {
            return HeatLevel.byIndex(this.ordinal() % (HeatLevel.values().length - 1) + 1);
        }

        static {
            CODEC = StringRepresentable.fromEnum(HeatLevel::values);
        }
    }
}

