/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record ChanceOutput(float chance, ItemStack stack) {
    public static Codec<ChanceOutput> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(ChanceOutput::chance), (App)ItemStack.MAP_CODEC.forGetter(ChanceOutput::stack)).apply((Applicative)instance, ChanceOutput::new));
    public static StreamCodec<RegistryFriendlyByteBuf, ChanceOutput> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, ChanceOutput::chance, (StreamCodec)ItemStack.STREAM_CODEC, ChanceOutput::stack, ChanceOutput::new);

    @Nullable
    public ItemStack get(RandomSource random) {
        if (this.chance == 1.0f) {
            return this.stack.copy();
        }
        int count = this.stack.getCount();
        int n = count;
        for (int i = 0; i < n; ++i) {
            if (!(random.nextFloat() > this.chance)) continue;
            --count;
        }
        if (count == 0) {
            return null;
        }
        return this.stack.copyWithCount(count);
    }
}

