/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.recipe;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class SizedIngredient {
    public static StreamCodec<RegistryFriendlyByteBuf, SizedIngredient> PACKET_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, i -> i.ingredient, (StreamCodec)ByteBufCodecs.INT, i -> i.count, SizedIngredient::new);
    private final Ingredient ingredient;
    private int count;

    public static Codec<List<SizedIngredient>> getListCodec(int min, int max) {
        return Ingredient.CODEC.listOf(min, max).xmap(SizedIngredient::of, SizedIngredient::unpack);
    }

    public SizedIngredient(Ingredient ingredient, int count) {
        this.ingredient = ingredient;
        this.count = count;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getCount() {
        return this.count;
    }

    public boolean test(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public static List<SizedIngredient> of(ShapelessRecipe recipe) {
        return SizedIngredient.of(recipe.ingredients);
    }

    public static List<SizedIngredient> of(List<Ingredient> ingredients) {
        int size = ingredients.size();
        if (size == 0) {
            return List.of();
        }
        ArrayList<SizedIngredient> result = new ArrayList<SizedIngredient>();
        result.add(new SizedIngredient(ingredients.getFirst(), 1));
        if (size == 1) {
            return result;
        }
        block0: for (int i = 1; i < size; ++i) {
            Ingredient ingredient = ingredients.get(i);
            for (SizedIngredient sizedIngredient : result) {
                if (!sizedIngredient.ingredient.equals((Object)ingredient)) continue;
                ++sizedIngredient.count;
                continue block0;
            }
            result.add(new SizedIngredient(ingredient, 1));
        }
        return result;
    }

    public static List<SizedIngredient> of(ShapedRecipe recipe) {
        List ingredients = recipe.getIngredients();
        ArrayList<SizedIngredient> result = new ArrayList<SizedIngredient>();
        if (ingredients.isEmpty()) {
            return result;
        }
        block0: for (Optional placement : ingredients) {
            if (placement.isEmpty()) continue;
            Ingredient ingredient = (Ingredient)placement.get();
            for (SizedIngredient sizedIngredient : result) {
                if (!sizedIngredient.ingredient.equals((Object)ingredient)) continue;
                ++sizedIngredient.count;
                continue block0;
            }
            result.add(new SizedIngredient(ingredient, 1));
        }
        return result;
    }

    public static List<Ingredient> unpack(List<SizedIngredient> ingredients) {
        ArrayList<Ingredient> result = new ArrayList<Ingredient>();
        for (SizedIngredient sizedIngredient : ingredients) {
            for (int i = 0; i < sizedIngredient.count; ++i) {
                result.add(sizedIngredient.ingredient);
            }
        }
        return result;
    }
}

