/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.processing.sequenced;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllAssemblyRecipeNames;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllRecipeSerializers;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.content.processing.recipe.ChanceOutput;
import com.zurrtum.create.foundation.recipe.ComponentsIngredient;
import com.zurrtum.create.foundation.recipe.CreateRecipe;
import com.zurrtum.create.infrastructure.component.SequencedAssemblyJunk;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.util.TriConsumer;

public record SequencedAssemblyRecipe(Ingredient ingredient, ItemStack transitionalItem, ChanceOutput result, List<ChanceOutput> junks, int loops, List<Recipe<?>> sequence) implements CreateRecipe<SingleRecipeInput>
{
    public RecipeType<SequencedAssemblyRecipe> getType() {
        return AllRecipeTypes.SEQUENCED_ASSEMBLY;
    }

    public boolean matches(SingleRecipeInput input, Level world) {
        return this.ingredient.test(input.item());
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        return this.result.stack().copy();
    }

    public RecipeSerializer<? extends Recipe<SingleRecipeInput>> getSerializer() {
        return AllRecipeSerializers.SEQUENCED_ASSEMBLY;
    }

    public static class Serializer
    implements RecipeSerializer<SequencedAssemblyRecipe> {
        private static final Codec<List<ChanceOutput>> JUNKS_CODEC = ChanceOutput.CODEC.listOf();
        private static final Codec<List<Recipe<?>>> RECIPE_CODEC = Recipe.CODEC.listOf();
        private static final MapCodec<SequencedAssemblyRecipe> RAW_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(SequencedAssemblyRecipe::ingredient), (App)ItemStack.CODEC.fieldOf("transitional_item").forGetter(SequencedAssemblyRecipe::transitionalItem), (App)ChanceOutput.CODEC.fieldOf("result").forGetter(SequencedAssemblyRecipe::result), (App)JUNKS_CODEC.optionalFieldOf("junks", List.of()).forGetter(SequencedAssemblyRecipe::junks), (App)Codec.INT.optionalFieldOf("loops", (Object)1).forGetter(SequencedAssemblyRecipe::loops), (App)RECIPE_CODEC.fieldOf("sequence").forGetter(SequencedAssemblyRecipe::sequence)).apply((Applicative)instance, SequencedAssemblyRecipe::new));
        private static final String INGREDIENT_ID = "$ingredient";
        private static final String RESULT_ID = "$result";
        private static final AtomicInteger idGenerator = new AtomicInteger();
        public static final Map<Identifier, Recipe<?>> GENERATE_RECIPES = new HashMap();
        public static final MapCodec<SequencedAssemblyRecipe> CODEC = new MapCodec<SequencedAssemblyRecipe>(){

            public <T> RecordBuilder<T> encode(SequencedAssemblyRecipe input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                prefix.add("raw", ops.createBoolean(true));
                return RAW_CODEC.encode((Object)input, ops, prefix);
            }

            public <T> DataResult<SequencedAssemblyRecipe> decode(DynamicOps<T> dynamicOps, MapLike<T> input) {
                if (input.get("raw") == null) {
                    Object object = input.get("sequence");
                    if (!(object instanceof JsonArray)) {
                        throw new UnsupportedOperationException("ops must be a JsonOps");
                    }
                    JsonArray sequenceJson = (JsonArray)object;
                    DynamicOps ops = dynamicOps;
                    int loops = Optional.ofNullable(input.get("loops")).map(value -> dynamicOps.getNumberValue(value, (Number)1).intValue()).orElse(1);
                    int sequenceSize = sequenceJson.size();
                    int size = sequenceSize * loops;
                    if (size <= 1) {
                        throw new UnsupportedOperationException("sequence must have at least two steps");
                    }
                    ItemStack transitionalItem = (ItemStack)ItemStack.CODEC.parse(dynamicOps, input.get("transitional_item")).getOrThrow();
                    ChanceOutput result = (ChanceOutput)ChanceOutput.CODEC.parse(dynamicOps, input.get("result")).getOrThrow();
                    List<ChanceOutput> junks = JUNKS_CODEC.parse(dynamicOps, input.get("junks")).result().orElse(List.of());
                    ArrayList<Component> RecipeName = new ArrayList<Component>(sequenceSize);
                    for (int i2 = 0; i2 < sequenceSize; ++i2) {
                        JsonObject object2 = (JsonObject)sequenceJson.get(i2);
                        RecipeName.add(AllAssemblyRecipeNames.get(ops, object2));
                    }
                    ItemStack transitional = transitionalItem.copy();
                    Ingredient transitionalIngredient = Ingredient.of((ItemLike)transitionalItem.getItem());
                    Supplier<JsonElement> transitionalJsonIngredient = () -> (JsonElement)ComponentsIngredient.CODEC.encodeStart(ops, (Object)new ComponentsIngredient(transitionalIngredient, transitional.getComponentsPatch())).getOrThrow();
                    ArrayList<BiFunction<JsonElement, JsonElement, JsonObject>> sequenceJsonFactory = new ArrayList<BiFunction<JsonElement, JsonElement, JsonObject>>(size);
                    for (int i3 = 0; i3 < sequenceSize; ++i3) {
                        JsonObject object3 = (JsonObject)sequenceJson.get(i3);
                        Consumer<JsonElement> replaceIngredient = 1.getReplace(object3, Serializer.INGREDIENT_ID);
                        Consumer<JsonElement> replaceResult = 1.getReplace(object3, Serializer.RESULT_ID);
                        sequenceJsonFactory.add((ingredientJson, resultJson) -> {
                            if (replaceIngredient != null) {
                                replaceIngredient.accept((JsonElement)ingredientJson);
                            }
                            if (replaceResult != null) {
                                replaceResult.accept((JsonElement)resultJson);
                            }
                            return object3;
                        });
                    }
                    MutableInt step = new MutableInt(1);
                    Supplier<JsonElement> transitionalJsonResult = () -> {
                        int i;
                        int index = step.getAndIncrement();
                        ArrayList<Object> lore = new ArrayList<Object>(6);
                        lore.add(CommonComponents.EMPTY);
                        lore.add(Component.translatable((String)"create.recipe.sequenced_assembly").withStyle(ChatFormatting.GRAY).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
                        lore.add(Component.translatable((String)"create.recipe.assembly.progress", (Object[])new Object[]{index, size}).withStyle(ChatFormatting.DARK_GRAY).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
                        lore.add(Component.translatable((String)"create.recipe.assembly.next", (Object[])new Object[]{RecipeName.get(index % sequenceSize)}).withStyle(ChatFormatting.AQUA).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
                        int end = Math.min(i + 2, size);
                        for (i = index + 1; i < end; ++i) {
                            lore.add(Component.literal((String)"-> ").append((Component)RecipeName.get(i % sequenceSize)).withStyle(ChatFormatting.DARK_AQUA).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
                        }
                        transitional.set(AllDataComponents.SEQUENCED_ASSEMBLY_PROGRESS, (Object)Float.valueOf((float)index / (float)size));
                        transitional.set(DataComponents.LORE, (Object)new ItemLore(lore, lore));
                        return (JsonElement)ItemStack.CODEC.encodeStart(ops, (Object)transitional).getOrThrow();
                    };
                    Supplier<JsonElement> transitionalJsonChanceResult = () -> {
                        transitional.set(AllDataComponents.SEQUENCED_ASSEMBLY_JUNK, (Object)new SequencedAssemblyJunk(result.chance(), junks));
                        JsonElement element = (JsonElement)transitionalJsonResult.get();
                        transitional.remove(AllDataComponents.SEQUENCED_ASSEMBLY_JUNK);
                        return element;
                    };
                    JsonElement jsonResult = (JsonElement)ItemStack.CODEC.encodeStart(ops, (Object)result.stack()).getOrThrow();
                    Identifier id = Identifier.parse((String)AllRecipeTypes.SEQUENCED_ASSEMBLY.toString()).withSuffix("_" + idGenerator.incrementAndGet() + "_" + BuiltInRegistries.ITEM.getKey((Object)result.stack().getItem()).getPath() + "_");
                    ArrayList sequence = new ArrayList(size);
                    TriConsumer recipeAdd = (i, ingredientJson, resultJson) -> {
                        JsonObject object = (JsonObject)((BiFunction)sequenceJsonFactory.get(i % sequenceSize)).apply(ingredientJson, resultJson);
                        Recipe recipe = (Recipe)Recipe.CODEC.parse(ops, (Object)object).getOrThrow();
                        sequence.add(recipe);
                        GENERATE_RECIPES.put(id.withSuffix(String.valueOf(sequence.size())), recipe);
                    };
                    JsonElement ingredientJson2 = (JsonElement)input.get("ingredient");
                    recipeAdd.accept((Object)0, (Object)ingredientJson2, (Object)(size == 2 ? transitionalJsonChanceResult.get() : transitionalJsonResult.get()));
                    int end = size - 2;
                    for (int i4 = 1; i4 < end; ++i4) {
                        recipeAdd.accept((Object)i4, (Object)transitionalJsonIngredient.get(), (Object)transitionalJsonResult.get());
                    }
                    if (size > 2) {
                        recipeAdd.accept((Object)(size - 2), (Object)transitionalJsonIngredient.get(), (Object)transitionalJsonChanceResult.get());
                    }
                    recipeAdd.accept((Object)(size - 1), (Object)transitionalJsonIngredient.get(), (Object)jsonResult);
                    return DataResult.success((Object)new SequencedAssemblyRecipe((Ingredient)Ingredient.CODEC.parse(ops, (Object)ingredientJson2).getOrThrow(), transitionalItem, result, junks, loops, sequence));
                }
                return RAW_CODEC.decode(dynamicOps, input);
            }

            private static Consumer<JsonElement> getReplace(JsonObject target, String id) {
                for (Map.Entry entry : target.entrySet()) {
                    JsonElement value = (JsonElement)entry.getValue();
                    Consumer<JsonElement> consumer = 1.getReplace(value, id);
                    if (consumer != null) {
                        return consumer;
                    }
                    if (!1.match(value, id)) continue;
                    String key = (String)entry.getKey();
                    return data -> target.add(key, data);
                }
                return null;
            }

            private static Consumer<JsonElement> getReplace(JsonArray target, String id) {
                int size = target.size();
                for (int i = 0; i < size; ++i) {
                    JsonElement value = target.get(i);
                    Consumer<JsonElement> consumer = 1.getReplace(value, id);
                    if (consumer != null) {
                        return consumer;
                    }
                    if (!1.match(value, id)) continue;
                    int index = i;
                    return data -> target.set(index, data);
                }
                return null;
            }

            private static Consumer<JsonElement> getReplace(JsonElement target, String id) {
                if (target instanceof JsonObject) {
                    JsonObject object = (JsonObject)target;
                    return 1.getReplace(object, id);
                }
                if (target instanceof JsonArray) {
                    JsonArray array = (JsonArray)target;
                    return 1.getReplace(array, id);
                }
                return null;
            }

            private static boolean match(JsonElement target, String id) {
                JsonPrimitive primitive;
                return target instanceof JsonPrimitive && (primitive = (JsonPrimitive)target).isString() && primitive.getAsString().equals(id);
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of(ops.createString("ingredient"), ops.createString("transitional_item"), ops.createString("result"), ops.createString("junks"), ops.createString("loops"), ops.createString("sequence"));
            }
        };
        public static final StreamCodec<RegistryFriendlyByteBuf, SequencedAssemblyRecipe> PACKET_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, SequencedAssemblyRecipe::ingredient, (StreamCodec)ItemStack.STREAM_CODEC, SequencedAssemblyRecipe::transitionalItem, ChanceOutput.PACKET_CODEC, SequencedAssemblyRecipe::result, (StreamCodec)ChanceOutput.PACKET_CODEC.apply(ByteBufCodecs.list()), SequencedAssemblyRecipe::junks, (StreamCodec)ByteBufCodecs.INT, SequencedAssemblyRecipe::loops, (StreamCodec)Recipe.STREAM_CODEC.apply(ByteBufCodecs.list()), SequencedAssemblyRecipe::sequence, SequencedAssemblyRecipe::new);

        public MapCodec<SequencedAssemblyRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SequencedAssemblyRecipe> streamCodec() {
            return PACKET_CODEC;
        }
    }
}

