/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.analogLever;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.redstone.analogLever.AnalogLeverBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class AnalogLeverBlock
extends FaceAttachedHorizontalDirectionalBlock
implements IBE<AnalogLeverBlockEntity> {
    public static final MapCodec<AnalogLeverBlock> CODEC = AnalogLeverBlock.simpleCodec(AnalogLeverBlock::new);
    private final Function<BlockState, VoxelShape> shapeFunction = this.createShapeFunction();

    public AnalogLeverBlock(BlockBehaviour.Properties p_i48402_1_) {
        super(p_i48402_1_);
    }

    private Function<BlockState, VoxelShape> createShapeFunction() {
        Map map = Shapes.rotateAttachFace((VoxelShape)Block.boxZ((double)6.0, (double)8.0, (double)10.0, (double)16.0));
        return this.getShapeForEachState(state -> (VoxelShape)((Map)map.get(state.getValue((Property)FACE))).get(state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shapeFunction.apply(state);
    }

    public static boolean onBlockActivated(InteractionHand hand, BlockState state, ItemStack stack) {
        if (hand == InteractionHand.OFF_HAND || stack.is((Item)AllItems.WRENCH)) {
            return false;
        }
        return state.getBlock() instanceof AnalogLeverBlock;
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (worldIn.isClientSide()) {
            AnalogLeverBlock.addParticles(state, (LevelAccessor)worldIn, pos, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return this.onBlockEntityUse((BlockGetter)worldIn, pos, be -> {
            boolean sneak = player.isShiftKeyDown();
            be.changeState(sneak);
            float f = 0.25f + (float)(be.state + 5) / 15.0f * 0.5f;
            worldIn.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.2f, f);
            return InteractionResult.SUCCESS;
        });
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.getBlockEntityOptional(blockAccess, pos).map(al -> al.state).orElse(0);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return AnalogLeverBlock.getConnectedDirection((BlockState)blockState) == side ? this.getSignal(blockState, blockAccess, pos, side) : 0;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            if (be.state != 0 && rand.nextFloat() < 0.25f) {
                AnalogLeverBlock.addParticles(stateIn, (LevelAccessor)worldIn, pos, 0.5f);
            }
        });
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel worldIn, BlockPos pos, boolean isMoving) {
        if (isMoving) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            if (be.state != 0) {
                AnalogLeverBlock.updateNeighbors(state, (Level)worldIn, pos);
            }
            worldIn.removeBlockEntity(pos);
        });
    }

    private static void addParticles(BlockState state, LevelAccessor worldIn, BlockPos pos, float alpha) {
        Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
        Direction direction1 = AnalogLeverBlock.getConnectedDirection((BlockState)state).getOpposite();
        double d0 = (double)pos.getX() + 0.5 + 0.1 * (double)direction.getStepX() + 0.2 * (double)direction1.getStepX();
        double d1 = (double)pos.getY() + 0.5 + 0.1 * (double)direction.getStepY() + 0.2 * (double)direction1.getStepY();
        double d2 = (double)pos.getZ() + 0.5 + 0.1 * (double)direction.getStepZ() + 0.2 * (double)direction1.getStepZ();
        worldIn.addParticle((ParticleOptions)new DustParticleOptions(0xFF0000, alpha), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    static void updateNeighbors(BlockState state, Level world, BlockPos pos) {
        world.updateNeighborsAt(pos, state.getBlock(), null);
        world.updateNeighborsAt(pos.relative(AnalogLeverBlock.getConnectedDirection((BlockState)state).getOpposite()), state.getBlock(), null);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING, FACE}));
    }

    @Override
    public Class<AnalogLeverBlockEntity> getBlockEntityClass() {
        return AnalogLeverBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends AnalogLeverBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ANALOG_LEVER;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @NotNull
    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

