/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.contact;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContraption;
import com.zurrtum.create.content.redstone.contact.RedstoneContactBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.TickPriority;

public class ContactMovementBehaviour
extends MovementBehaviour {
    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)RedstoneContactBlock.FACING)).getUnitVec3i()).scale((double)0.65f);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        Contraption contraption;
        BlockState block = context.state;
        Level world = context.world;
        if (world.isClientSide()) {
            return;
        }
        if (context.firstMovement) {
            return;
        }
        this.deactivateLastVisitedContact(context);
        BlockState visitedState = world.getBlockState(pos);
        if (!visitedState.is((Block)AllBlocks.REDSTONE_CONTACT) && !visitedState.is((Block)AllBlocks.ELEVATOR_CONTACT)) {
            return;
        }
        Vec3 contact = Vec3.atLowerCornerOf((Vec3i)((Direction)block.getValue((Property)RedstoneContactBlock.FACING)).getUnitVec3i());
        contact = (Vec3)context.rotation.apply(contact);
        Direction direction = Direction.getApproximateNearest((double)contact.x, (double)contact.y, (double)contact.z);
        if (visitedState.getValue((Property)RedstoneContactBlock.FACING) != direction.getOpposite()) {
            return;
        }
        if (visitedState.is((Block)AllBlocks.REDSTONE_CONTACT)) {
            world.setBlockAndUpdate(pos, (BlockState)visitedState.setValue((Property)RedstoneContactBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        }
        if (visitedState.is((Block)AllBlocks.ELEVATOR_CONTACT) && (contraption = context.contraption) instanceof ElevatorContraption) {
            ElevatorContraption ec = (ElevatorContraption)contraption;
            ec.broadcastFloorData(world, pos);
        }
        context.data.store("lastContact", BlockPos.CODEC, (Object)pos);
    }

    @Override
    public void stopMoving(MovementContext context) {
        this.deactivateLastVisitedContact(context);
    }

    @Override
    public void cancelStall(MovementContext context) {
        super.cancelStall(context);
        this.deactivateLastVisitedContact(context);
    }

    public void deactivateLastVisitedContact(MovementContext context) {
        if (!context.data.contains("lastContact")) {
            return;
        }
        BlockPos last = context.data.read("lastContact", BlockPos.CODEC).orElse(BlockPos.ZERO);
        context.data.remove("lastContact");
        BlockState blockState = context.world.getBlockState(last);
        if (blockState.is((Block)AllBlocks.REDSTONE_CONTACT)) {
            context.world.scheduleTick(last, (Block)AllBlocks.REDSTONE_CONTACT, 1, TickPriority.NORMAL);
        }
    }
}

