/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.contact;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn;
import com.zurrtum.create.foundation.block.RedStoneConnectBlock;
import com.zurrtum.create.foundation.block.WeakPowerControlBlock;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RedstoneContactBlock
extends WrenchableDirectionalBlock
implements RedStoneConnectBlock,
WeakPowerControlBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public RedstoneContactBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
        super.createBlockStateDefinition(builder);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
        Direction placeDirection = context.getClickedFace().getOpposite();
        if (context.getPlayer() != null && context.getPlayer().isShiftKeyDown() || RedstoneContactBlock.hasValidContact((LevelReader)context.getLevel(), context.getClickedPos(), placeDirection)) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)placeDirection);
        }
        if (RedstoneContactBlock.hasValidContact((LevelReader)context.getLevel(), context.getClickedPos(), (Direction)state.getValue((Property)FACING))) {
            state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult onWrenched = super.onWrenched(state, context);
        if (onWrenched != InteractionResult.SUCCESS) {
            return onWrenched;
        }
        Level level = context.getLevel();
        if (level.isClientSide()) {
            return onWrenched;
        }
        BlockPos pos = context.getClickedPos();
        state = level.getBlockState(pos);
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (facing.getAxis() == Direction.Axis.Y) {
            return onWrenched;
        }
        if (ElevatorColumn.get((LevelAccessor)level, new ElevatorColumn.ColumnCoords(pos.getX(), pos.getZ(), facing)) == null) {
            return onWrenched;
        }
        level.setBlockAndUpdate(pos, BlockHelper.copyProperties(state, AllBlocks.ELEVATOR_CONTACT.defaultBlockState()));
        return onWrenched;
    }

    protected void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (oldState.is((Block)this) && oldState == state.cycle((Property)POWERED)) {
            world.updateNeighborsAt(pos, (Block)this, null);
        }
    }

    public BlockState updateShape(BlockState stateIn, LevelReader world, ScheduledTickAccess tickView, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (facing != stateIn.getValue((Property)FACING)) {
            return stateIn;
        }
        boolean hasValidContact = RedstoneContactBlock.hasValidContact(world, currentPos, facing);
        if ((Boolean)stateIn.getValue((Property)POWERED) != hasValidContact) {
            return (BlockState)stateIn.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasValidContact));
        }
        return stateIn;
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        boolean hasValidContact = RedstoneContactBlock.hasValidContact((LevelReader)worldIn, pos, (Direction)state.getValue((Property)FACING));
        if ((Boolean)state.getValue((Property)POWERED) != hasValidContact) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasValidContact)));
        }
    }

    public static boolean hasValidContact(LevelReader world, BlockPos pos, Direction direction) {
        BlockState blockState = world.getBlockState(pos.relative(direction));
        return (blockState.is((Block)AllBlocks.REDSTONE_CONTACT) || blockState.is((Block)AllBlocks.ELEVATOR_CONTACT)) && blockState.getValue((Property)FACING) == direction.getOpposite();
    }

    public boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED);
    }

    @Override
    public boolean canConnectRedstone(BlockState state, @Nullable Direction side) {
        return side != null && state.getValue((Property)FACING) != side.getOpposite();
    }

    public int getSignal(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)state.getValue((Property)POWERED) != false && side != ((Direction)state.getValue((Property)FACING)).getOpposite() ? 15 : 0;
    }

    @Override
    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }
}

