/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.deskBell;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.redstone.deskBell.DeskBellBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class DeskBellBlockEntity
extends SmartBlockEntity {
    public LerpedFloat animation = LerpedFloat.linear().startWithValue(0.0);
    public boolean ding;
    int blockStateTimer = 0;
    public float animationOffset;

    public DeskBellBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.DESK_BELL, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        this.animation.tickChaser();
        if (this.level.isClientSide()) {
            return;
        }
        if (this.blockStateTimer == 0) {
            return;
        }
        --this.blockStateTimer;
        if (this.blockStateTimer > 0) {
            return;
        }
        BlockState blockState = this.getBlockState();
        if (((Boolean)blockState.getValue((Property)DeskBellBlock.POWERED)).booleanValue()) {
            AllBlocks.DESK_BELL.unPress(blockState, this.level, this.worldPosition);
        }
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket && this.ding) {
            view.putBoolean("Ding", true);
        }
        this.ding = false;
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket && view.getBooleanOr("Ding", false)) {
            this.ding();
        }
    }

    public void ding() {
        if (!this.level.isClientSide()) {
            this.blockStateTimer = 20;
            this.ding = true;
            this.sendData();
            return;
        }
        this.animationOffset = this.level.random.nextFloat() * 2.0f * (float)Math.PI;
        this.animation.startWithValue(1.0).chase(0.0, 0.05, LerpedFloat.Chaser.LINEAR);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }
}

