/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.behaviour.display.DisplaySource;
import com.zurrtum.create.api.behaviour.display.DisplayTarget;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.LinkWithBulbBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class DisplayLinkBlockEntity
extends LinkWithBulbBlockEntity
implements TransformableBlockEntity {
    public BlockPos targetOffset = BlockPos.ZERO;
    public DisplaySource activeSource;
    private CompoundTag sourceConfig = new CompoundTag();
    public DisplayTarget activeTarget;
    public int targetLine = 0;
    public int refreshTicks;
    public FactoryPanelSupportBehaviour factoryPanelSupport;
    private static final Vec3 bulbOffset = VecHelper.voxelSpace(11.0, 7.0, 5.0);
    private static final Vec3 bulbOffsetVertical = VecHelper.voxelSpace(5.0, 7.0, 11.0);

    public DisplayLinkBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.DISPLAY_LINK, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.factoryPanelSupport = new FactoryPanelSupportBehaviour(this, () -> false, () -> false, this::updateGatheredData);
        behaviours.add(this.factoryPanelSupport);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.DISPLAY_LINK, AllAdvancements.DISPLAY_BOARD);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isVirtual()) {
            return;
        }
        if (this.activeSource == null) {
            return;
        }
        if (this.level.isClientSide()) {
            return;
        }
        ++this.refreshTicks;
        if (this.refreshTicks < this.activeSource.getPassiveRefreshTicks() || !this.activeSource.shouldPassiveReset()) {
            return;
        }
        this.tickSource();
    }

    public void tickSource() {
        this.refreshTicks = 0;
        if (((Boolean)this.getBlockState().getValueOrElse((Property)DisplayLinkBlock.POWERED, (Comparable)Boolean.valueOf(true))).booleanValue()) {
            return;
        }
        if (!this.level.isClientSide()) {
            this.updateGatheredData();
        }
    }

    public void onNoLongerPowered() {
        if (this.activeSource == null) {
            return;
        }
        this.refreshTicks = 0;
        this.activeSource.onSignalReset(new DisplayLinkContext(this.level, this));
        this.updateGatheredData();
    }

    public void updateGatheredData() {
        BlockPos sourcePosition = this.getSourcePosition();
        BlockPos targetPosition = this.getTargetPosition();
        if (!this.level.isLoaded(targetPosition) || !this.level.isLoaded(sourcePosition)) {
            return;
        }
        DisplayTarget target = DisplayTarget.get((LevelAccessor)this.level, targetPosition);
        List<DisplaySource> sources = DisplaySource.getAll((LevelAccessor)this.level, sourcePosition);
        boolean notify = false;
        if (this.activeTarget != target) {
            this.activeTarget = target;
            notify = true;
        }
        if (this.activeSource != null && !sources.contains(this.activeSource)) {
            this.activeSource = null;
            this.sourceConfig = new CompoundTag();
            notify = true;
        }
        if (notify) {
            this.notifyUpdate();
        }
        if (this.activeSource == null || this.activeTarget == null) {
            return;
        }
        DisplayLinkContext context = new DisplayLinkContext(this.level, this);
        this.activeSource.transferData(context, this.activeTarget, this.targetLine);
        this.sendPulseNextSync();
        this.sendData();
        this.award(AllAdvancements.DISPLAY_LINK);
    }

    @Override
    public void writeSafe(ValueOutput view) {
        super.writeSafe(view);
        this.writeGatheredData(view);
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        Identifier id;
        super.write(view, clientPacket);
        this.writeGatheredData(view);
        if (clientPacket && this.activeTarget != null && (id = CreateRegistries.DISPLAY_TARGET.getKey((Object)this.activeTarget)) != null) {
            view.store("TargetType", Identifier.CODEC, (Object)id);
        }
    }

    private void writeGatheredData(ValueOutput view) {
        view.store("TargetOffset", BlockPos.CODEC, (Object)this.targetOffset);
        view.putInt("TargetLine", this.targetLine);
        if (this.activeSource != null) {
            CompoundTag data = this.sourceConfig.copy();
            Identifier id = CreateRegistries.DISPLAY_SOURCE.getKey((Object)this.activeSource);
            if (id != null) {
                data.store("Id", Identifier.CODEC, (Object)id);
            }
            view.store("Source", CompoundTag.CODEC, (Object)data);
        }
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.targetOffset = view.read("TargetOffset", BlockPos.CODEC).orElse(BlockPos.ZERO);
        this.targetLine = view.getIntOr("TargetLine", 0);
        if (clientPacket) {
            view.read("TargetType", Identifier.CODEC).ifPresent(id -> {
                this.activeTarget = DisplayTarget.get(id);
            });
        }
        view.read("Source", CompoundTag.CODEC).ifPresent(data -> {
            this.activeSource = DisplaySource.get(data.read("Id", Identifier.CODEC).orElse(null));
            this.sourceConfig = this.activeSource != null ? data.copy() : new CompoundTag();
        });
    }

    public void target(BlockPos targetPosition) {
        this.targetOffset = targetPosition.subtract((Vec3i)this.worldPosition);
    }

    public BlockPos getSourcePosition() {
        Iterator<FactoryPanelPosition> iterator = this.factoryPanelSupport.getLinkedPanels().iterator();
        if (iterator.hasNext()) {
            FactoryPanelPosition position = iterator.next();
            return position.pos();
        }
        return this.worldPosition.relative(this.getDirection());
    }

    public CompoundTag getSourceConfig() {
        return this.sourceConfig;
    }

    public void setSourceConfig(CompoundTag sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public Direction getDirection() {
        return ((Direction)this.getBlockState().getValueOrElse((Property)DisplayLinkBlock.FACING, (Comparable)Direction.UP)).getOpposite();
    }

    public BlockPos getTargetPosition() {
        return this.worldPosition.offset((Vec3i)this.targetOffset);
    }

    @Override
    public Vec3 getBulbOffset(BlockState state) {
        if (((Direction)state.getValueOrElse((Property)DisplayLinkBlock.FACING, (Comparable)Direction.UP)).getAxis().isVertical()) {
            return bulbOffsetVertical;
        }
        return bulbOffset;
    }

    @Override
    public void transform(BlockEntity be, StructureTransform transform) {
        this.targetOffset = transform.applyWithoutOffset(this.targetOffset);
        this.notifyUpdate();
    }
}

