/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public abstract class LinkWithBulbBlockEntity
extends SmartBlockEntity {
    private LerpedFloat glow = LerpedFloat.linear().startWithValue(0.0);
    private boolean sendPulse;

    public LinkWithBulbBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.glow.chase(0.0, 0.5, LerpedFloat.Chaser.EXP);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isVirtual() || this.level.isClientSide()) {
            this.glow.tickChaser();
        }
    }

    public float getGlow(float partialTicks) {
        return this.glow.getValue(partialTicks);
    }

    public void sendPulseNextSync() {
        this.sendPulse = true;
    }

    public void pulse() {
        this.glow.setValue(2.0);
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket && this.sendPulse) {
            this.sendPulse = false;
            view.putBoolean("Pulse", true);
        }
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket && view.getBooleanOr("Pulse", false)) {
            this.pulse();
        }
    }

    public Vec3 getBulbOffset(BlockState state) {
        return Vec3.ZERO;
    }

    public Direction getBulbFacing(BlockState state) {
        return (Direction)state.getValue((Property)DisplayLinkBlock.FACING);
    }
}

