/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.source.ValueListDisplaySource;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FactoryGaugeDisplaySource
extends ValueListDisplaySource {
    @Override
    protected Stream<IntAttached<MutableComponent>> provideEntries(DisplayLinkContext context, int maxRows) {
        List<FactoryPanelPosition> panels = context.blockEntity().factoryPanelSupport.getLinkedPanels();
        if (panels.isEmpty()) {
            return Stream.empty();
        }
        return panels.stream().map(fpp -> this.createEntry(context.level(), (FactoryPanelPosition)fpp)).filter(Objects::nonNull).limit(maxRows);
    }

    @Nullable
    public IntAttached<MutableComponent> createEntry(Level level, FactoryPanelPosition pos) {
        ServerFactoryPanelBehaviour panel = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)level, pos);
        if (panel == null) {
            return null;
        }
        ItemStack filter = panel.getFilter();
        int demand = panel.getAmount() * (panel.upTo ? 1 : filter.getMaxStackSize());
        String s = " ";
        if (demand != 0) {
            int promised = panel.getPromised();
            s = panel.satisfied ? "\u2714" : (promised != 0 ? "\u2191" : "\u25aa");
        }
        return IntAttached.with(panel.getLevelInStorage(), Component.literal((String)(s + " ")).withColor(panel.getIngredientStatusColor()).append((Component)filter.getHoverName().plainCopy().withStyle(ChatFormatting.RESET)));
    }

    @Override
    protected String getTranslationKey() {
        return "gauge_status";
    }

    @Override
    protected boolean valueFirst() {
        return true;
    }
}

