/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink.source;

import com.zurrtum.create.content.kinetics.clock.CuckooClockBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TimeOfDayDisplaySource
extends SingleLineDisplaySource {
    public static final MutableComponent EMPTY_TIME = Component.literal((String)"--:--");

    @Override
    protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        Level level = context.level();
        if (!(level instanceof ServerLevel)) {
            return EMPTY_TIME;
        }
        ServerLevel sLevel = (ServerLevel)level;
        BlockEntity blockEntity = context.getSourceBlockEntity();
        if (!(blockEntity instanceof CuckooClockBlockEntity)) {
            return EMPTY_TIME;
        }
        CuckooClockBlockEntity ccbe = (CuckooClockBlockEntity)blockEntity;
        if (ccbe.getSpeed() == 0.0f) {
            return EMPTY_TIME;
        }
        boolean c12 = context.sourceConfig().getIntOr("Cycle", 0) == 0;
        int dayTime = (int)(sLevel.getDayTime() % 24000L);
        int hours = (dayTime / 1000 + 6) % 24;
        int minutes = dayTime % 1000 * 60 / 1000;
        MutableComponent suffix = Component.translatable((String)("create.generic.daytime." + (hours > 11 ? "pm" : "am")));
        minutes = minutes / 5 * 5;
        if (c12 && (hours %= 12) == 0) {
            hours = 12;
        }
        MutableComponent component = Component.literal((String)((hours < 10 ? " " : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes + (c12 ? " " : "")));
        return c12 ? component.append((Component)suffix) : component;
    }

    @Override
    protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
        return "Instant";
    }

    @Override
    protected FlapDisplaySection createSectionForValue(DisplayLinkContext context, int size) {
        return new FlapDisplaySection((float)size * 7.0f, "instant", false, false);
    }

    @Override
    protected String getTranslationKey() {
        return "time_of_day";
    }

    @Override
    public boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }
}

