/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.displayLink.target;

import com.zurrtum.create.api.behaviour.display.DisplayHolder;
import com.zurrtum.create.api.behaviour.display.DisplayTarget;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;

public class SignDisplayTarget
extends DisplayTarget {
    @Override
    public void acceptText(int line, List<MutableComponent> text, DisplayLinkContext context) {
        BlockEntity be = context.getTargetBlockEntity();
        if (!(be instanceof SignBlockEntity)) {
            return;
        }
        SignBlockEntity sign = (SignBlockEntity)be;
        boolean changed = false;
        Couple<SignText> signText = Couple.createWithContext(arg_0 -> ((SignBlockEntity)sign).getText(arg_0));
        DisplayHolder holder = (DisplayHolder)sign;
        int i = 0;
        while (i < text.size() && i + line < 4) {
            if (i == 0) {
                SignDisplayTarget.reserve(i + line, holder, context);
            }
            if (i > 0 && this.isReserved(i + line, holder, context)) break;
            int iFinal = i++;
            String content = text.get(iFinal).getString(sign.getMaxTextLineWidth());
            signText = signText.map(st -> st.setMessage(iFinal + line, (Component)Component.literal((String)content)));
            changed = true;
        }
        if (changed) {
            signText.forEachWithContext((arg_0, arg_1) -> ((SignBlockEntity)sign).setText(arg_0, arg_1));
            context.level().sendBlockUpdated(context.getTargetPos(), sign.getBlockState(), sign.getBlockState(), 2);
        }
    }

    @Override
    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        return new DisplayTargetStats(4, 15, this);
    }

    @Override
    public boolean requiresComponentSanitization() {
        return true;
    }
}

