/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.link;

import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.equipment.clipboard.ClipboardCloneable;
import com.zurrtum.create.content.redstone.link.IRedstoneLinkable;
import com.zurrtum.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Optional;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class ServerLinkBehaviour
extends BlockEntityBehaviour<SmartBlockEntity>
implements IRedstoneLinkable,
ClipboardCloneable {
    public static final BehaviourType<ServerLinkBehaviour> TYPE = new BehaviourType();
    public RedstoneLinkNetworkHandler.Frequency frequencyFirst = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    public RedstoneLinkNetworkHandler.Frequency frequencyLast = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    Vec3 textShift = Vec3.ZERO;
    public boolean newPosition = true;
    private Mode mode;
    private IntSupplier transmission;
    private IntConsumer signalCallback;

    protected ServerLinkBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public static ServerLinkBehaviour receiver(SmartBlockEntity be, IntConsumer signalCallback) {
        ServerLinkBehaviour behaviour = new ServerLinkBehaviour(be);
        behaviour.signalCallback = signalCallback;
        behaviour.mode = Mode.RECEIVE;
        return behaviour;
    }

    public static ServerLinkBehaviour transmitter(SmartBlockEntity be, IntSupplier transmission) {
        ServerLinkBehaviour behaviour = new ServerLinkBehaviour(be);
        behaviour.transmission = transmission;
        behaviour.mode = Mode.TRANSMIT;
        return behaviour;
    }

    public ServerLinkBehaviour moveText(Vec3 shift) {
        this.textShift = shift;
        return this;
    }

    public void copyItemsFrom(ServerLinkBehaviour behaviour) {
        if (behaviour == null) {
            return;
        }
        this.frequencyFirst = behaviour.frequencyFirst;
        this.frequencyLast = behaviour.frequencyLast;
    }

    @Override
    public boolean isListening() {
        return this.mode == Mode.RECEIVE;
    }

    @Override
    public int getTransmittedStrength() {
        return this.mode == Mode.TRANSMIT ? this.transmission.getAsInt() : 0;
    }

    @Override
    public void setReceivedStrength(int networkPower) {
        if (!this.newPosition) {
            return;
        }
        this.signalCallback.accept(networkPower);
    }

    public void notifySignalChange() {
        Create.REDSTONE_LINK_NETWORK_HANDLER.updateNetworkOf((LevelAccessor)this.getLevel(), this);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getLevel().isClientSide()) {
            return;
        }
        this.getHandler().addToNetwork((LevelAccessor)this.getLevel(), this);
        this.newPosition = true;
    }

    @Override
    public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
        return Couple.create(this.frequencyFirst, this.frequencyLast);
    }

    @Override
    public void unload() {
        super.unload();
        if (this.getLevel().isClientSide()) {
            return;
        }
        this.getHandler().removeFromNetwork((LevelAccessor)this.getLevel(), this);
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.store("FrequencyFirst", RedstoneLinkNetworkHandler.Frequency.CODEC, (Object)this.frequencyFirst);
        view.store("FrequencyLast", RedstoneLinkNetworkHandler.Frequency.CODEC, (Object)this.frequencyLast);
        view.store("LastKnownPosition", BlockPos.CODEC, (Object)this.blockEntity.getBlockPos());
    }

    @Override
    public void read(ValueInput view, boolean clientPacket) {
        this.newPosition = view.read("LastKnownPosition", BlockPos.CODEC).map(pos -> !this.blockEntity.getBlockPos().equals(pos)).orElse(true);
        super.read(view, clientPacket);
        this.frequencyFirst = view.read("FrequencyFirst", RedstoneLinkNetworkHandler.Frequency.CODEC).orElse(RedstoneLinkNetworkHandler.Frequency.EMPTY);
        this.frequencyLast = view.read("FrequencyLast", RedstoneLinkNetworkHandler.Frequency.CODEC).orElse(RedstoneLinkNetworkHandler.Frequency.EMPTY);
    }

    public void setFrequency(boolean first, ItemStack stack) {
        boolean changed;
        stack = stack.copy();
        stack.setCount(1);
        ItemStack toCompare = first ? this.frequencyFirst.getStack() : this.frequencyLast.getStack();
        boolean bl = changed = !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)toCompare);
        if (changed) {
            this.getHandler().removeFromNetwork((LevelAccessor)this.getLevel(), this);
        }
        if (first) {
            this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of(stack);
        } else {
            this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of(stack);
        }
        if (!changed) {
            return;
        }
        this.blockEntity.sendData();
        this.getHandler().addToNetwork((LevelAccessor)this.getLevel(), this);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    private RedstoneLinkNetworkHandler getHandler() {
        return Create.REDSTONE_LINK_NETWORK_HANDLER;
    }

    @Override
    public boolean isAlive() {
        Level level = this.getLevel();
        BlockPos pos = this.getPos();
        if (this.blockEntity.isChunkUnloaded()) {
            return false;
        }
        if (this.blockEntity.isRemoved()) {
            return false;
        }
        if (!level.isLoaded(pos)) {
            return false;
        }
        return level.getBlockEntity(pos) == this.blockEntity;
    }

    @Override
    public BlockPos getLocation() {
        return this.getPos();
    }

    @Override
    public String getClipboardKey() {
        return "Frequencies";
    }

    @Override
    public boolean writeToClipboard(ValueOutput view, Direction side) {
        view.store("First", ItemStack.OPTIONAL_CODEC, (Object)this.frequencyFirst.getStack());
        view.store("Last", ItemStack.OPTIONAL_CODEC, (Object)this.frequencyLast.getStack());
        return true;
    }

    @Override
    public boolean readFromClipboard(ValueInput view, Player player, Direction side, boolean simulate) {
        Optional first = view.read("First", ItemStack.OPTIONAL_CODEC);
        if (first.isEmpty()) {
            return false;
        }
        Optional last = view.read("Last", ItemStack.OPTIONAL_CODEC);
        if (last.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.setFrequency(true, (ItemStack)first.get());
        this.setFrequency(false, (ItemStack)last.get());
        return true;
    }

    static enum Mode {
        TRANSMIT,
        RECEIVE;

    }
}

