/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.link.controller;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.zurrtum.create.content.redstone.link.controller.LinkedControllerMenu;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class LinkedControllerItem
extends Item
implements MenuProvider {
    public LinkedControllerItem(Item.Properties properties) {
        super(properties);
    }

    public static InteractionResult onItemUseFirst(Level world, Player player, ItemStack stack, InteractionHand hand, BlockHitResult ray, BlockPos pos) {
        Item item = stack.getItem();
        if (item instanceof LinkedControllerItem) {
            LinkedControllerItem item2 = (LinkedControllerItem)item;
            if (player.mayBuild()) {
                BlockState hitState = world.getBlockState(pos);
                if (player.isShiftKeyDown()) {
                    if (hitState.is((Block)AllBlocks.LECTERN_CONTROLLER)) {
                        if (!world.isClientSide()) {
                            AllBlocks.LECTERN_CONTROLLER.withBlockEntityDo((BlockGetter)world, pos, be -> be.swapControllers(stack, player, hand, hitState));
                        }
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    if (hitState.is((Block)AllBlocks.REDSTONE_LINK)) {
                        if (world.isClientSide()) {
                            AllClientHandle.INSTANCE.toggleLinkedControllerBindMode(pos);
                        }
                        player.getCooldowns().addCooldown(stack, 2);
                        return InteractionResult.SUCCESS;
                    }
                    if (hitState.is(Blocks.LECTERN) && !((Boolean)hitState.getValue((Property)LecternBlock.HAS_BOOK)).booleanValue()) {
                        if (!world.isClientSide()) {
                            ItemStack lecternStack = player.isCreative() ? stack.copy() : stack.split(1);
                            AllBlocks.LECTERN_CONTROLLER.replaceLectern(hitState, world, pos, lecternStack);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (hitState.is((Block)AllBlocks.LECTERN_CONTROLLER)) {
                        return InteractionResult.PASS;
                    }
                }
            }
            return item2.use(world, player, hand);
        }
        return null;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND) {
            if (!world.isClientSide() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (player.mayBuild()) {
                    this.openHandledScreen(serverPlayer);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown()) {
            if (world.isClientSide()) {
                AllClientHandle.INSTANCE.toggleLinkedControllerActive();
            }
            player.getCooldowns().addCooldown(heldItem, 2);
        }
        return InteractionResult.PASS;
    }

    public static ItemStackHandler getFrequencyItems(ItemStack stack) {
        ItemStackHandler newInv = new ItemStackHandler(12);
        if (!stack.is((Item)AllItems.LINKED_CONTROLLER)) {
            throw new IllegalArgumentException("Cannot get frequency items from non-controller: " + String.valueOf(stack));
        }
        if (!stack.has(AllDataComponents.LINKED_CONTROLLER_ITEMS)) {
            return newInv;
        }
        ItemHelper.fillItemStackHandler((ItemContainerContents)stack.getOrDefault(AllDataComponents.LINKED_CONTROLLER_ITEMS, (Object)ItemContainerContents.EMPTY), newInv);
        return newInv;
    }

    public static Couple<RedstoneLinkNetworkHandler.Frequency> toFrequency(ItemStack controller, int slot) {
        ItemStackHandler frequencyItems = LinkedControllerItem.getFrequencyItems(controller);
        return Couple.create(RedstoneLinkNetworkHandler.Frequency.of(frequencyItems.getItem(slot * 2)), RedstoneLinkNetworkHandler.Frequency.of(frequencyItems.getItem(slot * 2 + 1)));
    }

    @Override
    @Nullable
    public MenuBase<?> createMenu(int id, Inventory inv, Player player, RegistryFriendlyByteBuf extraData) {
        ItemStack heldItem = player.getMainHandItem();
        ItemStack.STREAM_CODEC.encode((Object)extraData, (Object)heldItem);
        return new LinkedControllerMenu(id, inv, heldItem);
    }

    @Override
    public Component getDisplayName() {
        return this.getName();
    }
}

