/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.nixieTube;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.redstone.nixieTube.DoubleFaceAttachedBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.RedStoneConnectBlock;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NixieTubeBlock
extends DoubleFaceAttachedBlock
implements IBE<NixieTubeBlockEntity>,
IWrenchable,
SimpleWaterloggedBlock,
SpecialBlockItemRequirement,
RedStoneConnectBlock {
    protected final DyeColor color;

    public NixieTubeBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACE, (Comparable)((Object)DoubleFaceAttachedBlock.DoubleAttachFace.FLOOR))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public NixieTubeBlock(BlockBehaviour.Properties properties) {
        this(properties, DyeColor.ORANGE);
    }

    public static Function<BlockBehaviour.Properties, NixieTubeBlock> dyed(DyeColor color) {
        return properties -> new NixieTubeBlock((BlockBehaviour.Properties)properties, color);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        List<ClipboardEntry> entries;
        if (player.isShiftKeyDown()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        NixieTubeBlockEntity nixie = (NixieTubeBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (nixie == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (NixieTubeBlock.isInComputerControlledRow((LevelAccessor)level, pos)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (stack.isEmpty()) {
            if (nixie.reactsToRedstone()) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            nixie.clearCustomText();
            this.updateDisplayedRedstoneValue(state, level, pos);
            return InteractionResult.SUCCESS;
        }
        boolean display = stack.getItem() == Items.NAME_TAG && stack.has(DataComponents.CUSTOM_NAME) || stack.is((Item)AllItems.CLIPBOARD);
        DyeColor dye = AllItemTags.getDyeColor(stack);
        if (!display && dye == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        Object component = stack.is((Item)AllItems.CLIPBOARD) ? ((entries = ClipboardEntry.getLastViewedEntries(stack)).isEmpty() ? (Component)stack.getOrDefault(DataComponents.CUSTOM_NAME, (Object)CommonComponents.EMPTY) : entries.getFirst().text) : (Component)stack.getOrDefault(DataComponents.CUSTOM_NAME, (Object)CommonComponents.EMPTY);
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        NixieTubeBlock.walkNixies((LevelAccessor)level, pos, true, (arg_0, arg_1) -> this.lambda$useItemOn$2(display, level, (Component)component, dye, state, arg_0, arg_1));
        return InteractionResult.SUCCESS;
    }

    public static Direction getLeftNixieDirection(@NotNull BlockState state) {
        Direction left = ((Direction)state.getValue((Property)FACING)).getOpposite();
        if (state.getValue((Property)FACE) == DoubleFaceAttachedBlock.DoubleAttachFace.WALL) {
            left = Direction.UP;
        }
        if (state.getValue((Property)FACE) == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED) {
            left = Direction.DOWN;
        }
        return left;
    }

    public static Direction getRightNixieDirection(@NotNull BlockState state) {
        return NixieTubeBlock.getLeftNixieDirection(state).getOpposite();
    }

    public static boolean isInComputerControlledRow(@NotNull LevelAccessor world, @NotNull BlockPos pos) {
        return false;
    }

    public static boolean walkNixies(@NotNull LevelAccessor world, @NotNull BlockPos start, boolean allowComputerControlled, @Nullable BiConsumer<BlockPos, Integer> callback) {
        BlockPos nextPos;
        BlockState state = world.getBlockState(start);
        if (!(state.getBlock() instanceof NixieTubeBlock)) {
            return false;
        }
        BlockPos currentPos = start;
        Direction left = NixieTubeBlock.getLeftNixieDirection(state);
        Direction right = left.getOpposite();
        while (NixieTubeBlock.areNixieBlocksEqual(world.getBlockState(nextPos = currentPos.relative(left)), state)) {
            currentPos = nextPos;
        }
        if (!allowComputerControlled) {
            BlockPos nextPos2;
            BlockPos leftmostPos = currentPos;
            currentPos = start;
            while (NixieTubeBlock.areNixieBlocksEqual(world.getBlockState(nextPos2 = currentPos.relative(right)), state)) {
                currentPos = nextPos2;
            }
            currentPos = leftmostPos;
        }
        int index = 0;
        while (true) {
            BlockPos nextPos3;
            int rowPosition = ++index;
            if (callback != null) {
                callback.accept(currentPos, rowPosition);
            }
            if (!NixieTubeBlock.areNixieBlocksEqual(world.getBlockState(nextPos3 = currentPos.relative(right)), state)) break;
            currentPos = nextPos3;
        }
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACE, FACING, BlockStateProperties.WATERLOGGED}));
    }

    protected ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        return AllItems.ORANGE_NIXIE_TUBE.getDefaultInstance();
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, (Item)AllItems.ORANGE_NIXIE_TUBE);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return switch ((DoubleFaceAttachedBlock.DoubleAttachFace)((Object)pState.getValue((Property)FACE))) {
            case DoubleFaceAttachedBlock.DoubleAttachFace.CEILING -> AllShapes.NIXIE_TUBE_CEILING.get(facing.getClockWise().getAxis());
            case DoubleFaceAttachedBlock.DoubleAttachFace.FLOOR -> AllShapes.NIXIE_TUBE.get(facing.getClockWise().getAxis());
            default -> AllShapes.NIXIE_TUBE_WALL.get(facing);
        };
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighbourPos, BlockState neighbourState, RandomSource random) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            tickView.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return state;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        if (state.getValue((Property)FACE) != DoubleFaceAttachedBlock.DoubleAttachFace.WALL && state.getValue((Property)FACE) != DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getClockWise());
        }
        return (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, @Nullable Orientation wireOrientation, boolean isMoving) {
        if (level.isClientSide()) {
            return;
        }
        if (!level.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource r) {
        this.updateDisplayedRedstoneValue(state, (Level)worldIn, pos);
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.getBlock() == oldState.getBlock() || isMoving || oldState.getBlock() instanceof NixieTubeBlock) {
            return;
        }
        this.updateDisplayedRedstoneValue(state, worldIn, pos);
    }

    public static void updateDisplayedRedstoneValue(NixieTubeBlockEntity be, BlockState state, boolean force) {
        if (be.getLevel() == null || be.getLevel().isClientSide()) {
            return;
        }
        if (be.reactsToRedstone() || force) {
            be.updateRedstoneStrength(NixieTubeBlock.getPower(be.getLevel(), state, be.getBlockPos()));
        }
    }

    private void updateDisplayedRedstoneValue(BlockState state, Level level, BlockPos pos) {
        if (level.isClientSide()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, be -> NixieTubeBlock.updateDisplayedRedstoneValue(be, state, false));
    }

    static boolean isValidBlock(BlockGetter world, BlockPos pos, boolean above) {
        BlockState state = world.getBlockState(pos.above(above ? 1 : -1));
        return !state.getShape(world, pos).isEmpty();
    }

    private static int getPower(Level worldIn, BlockState state, BlockPos pos) {
        int power = 0;
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.getSignal(pos.relative(direction), direction), power);
        }
        for (Direction direction : Iterate.directions) {
            if (((Direction)state.getValue((Property)FACING)).getOpposite() == direction) continue;
            power = Math.max(worldIn.getSignal(pos.relative(direction), Direction.UP), power);
        }
        return power;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Override
    public boolean canConnectRedstone(BlockState state, @Nullable Direction side) {
        return side != null;
    }

    @Override
    public Class<NixieTubeBlockEntity> getBlockEntityClass() {
        return NixieTubeBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends NixieTubeBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.NIXIE_TUBE;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static NixieTubeBlock getColorBlock(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> AllBlocks.WHITE_NIXIE_TUBE;
            case DyeColor.ORANGE -> AllBlocks.ORANGE_NIXIE_TUBE;
            case DyeColor.MAGENTA -> AllBlocks.MAGENTA_NIXIE_TUBE;
            case DyeColor.LIGHT_BLUE -> AllBlocks.LIGHT_BLUE_NIXIE_TUBE;
            case DyeColor.YELLOW -> AllBlocks.YELLOW_NIXIE_TUBE;
            case DyeColor.LIME -> AllBlocks.LIME_NIXIE_TUBE;
            case DyeColor.PINK -> AllBlocks.PINK_NIXIE_TUBE;
            case DyeColor.GRAY -> AllBlocks.GRAY_NIXIE_TUBE;
            case DyeColor.LIGHT_GRAY -> AllBlocks.LIGHT_GRAY_NIXIE_TUBE;
            case DyeColor.CYAN -> AllBlocks.CYAN_NIXIE_TUBE;
            case DyeColor.PURPLE -> AllBlocks.PURPLE_NIXIE_TUBE;
            case DyeColor.BLUE -> AllBlocks.BLUE_NIXIE_TUBE;
            case DyeColor.BROWN -> AllBlocks.BROWN_NIXIE_TUBE;
            case DyeColor.GREEN -> AllBlocks.GREEN_NIXIE_TUBE;
            case DyeColor.RED -> AllBlocks.RED_NIXIE_TUBE;
            case DyeColor.BLACK -> AllBlocks.BLACK_NIXIE_TUBE;
        };
    }

    public static boolean areNixieBlocksEqual(BlockState blockState, BlockState otherState) {
        if (!(blockState.getBlock() instanceof NixieTubeBlock)) {
            return false;
        }
        if (!(otherState.getBlock() instanceof NixieTubeBlock)) {
            return false;
        }
        return NixieTubeBlock.withColor(blockState, DyeColor.WHITE) == NixieTubeBlock.withColor(otherState, DyeColor.WHITE);
    }

    public static BlockState withColor(BlockState state, DyeColor color) {
        return (BlockState)((BlockState)((BlockState)(color == DyeColor.ORANGE ? AllBlocks.ORANGE_NIXIE_TUBE : NixieTubeBlock.getColorBlock(color)).defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)))).setValue((Property)FACE, (Comparable)((Object)((DoubleFaceAttachedBlock.DoubleAttachFace)((Object)state.getValue((Property)FACE)))));
    }

    public static DyeColor colorOf(BlockState blockState) {
        return blockState.getBlock() instanceof NixieTubeBlock ? ((NixieTubeBlock)blockState.getBlock()).color : DyeColor.ORANGE;
    }

    public static Direction getFacing(BlockState sideState) {
        return NixieTubeBlock.getConnectedDirection(sideState);
    }

    private /* synthetic */ void lambda$useItemOn$2(boolean display, Level level, Component component, DyeColor dye, BlockState state, BlockPos currentPos, Integer rowPosition) {
        if (display) {
            this.withBlockEntityDo((BlockGetter)level, currentPos, be -> be.displayCustomText(component, rowPosition));
        }
        if (dye != null) {
            level.setBlockAndUpdate(currentPos, NixieTubeBlock.withColor(state, dye));
        }
    }
}

