/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.smartObserver;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.fluids.PipeConnection;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.redstone.DirectedDirectionalBlock;
import com.zurrtum.create.content.redstone.smartObserver.SmartObserverBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.TankManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class SmartObserverBlockEntity
extends SmartBlockEntity {
    private static final int DEFAULT_DELAY = 6;
    private ServerFilteringBehaviour filtering;
    private InvManipulationBehaviour observedInventory;
    private TankManipulationBehaviour observedTank;
    private VersionedInventoryTrackerBehaviour invVersionTracker;
    private boolean sustainSignal;
    public int turnOffTicks = 0;

    public SmartObserverBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.SMART_OBSERVER, pos, state);
        this.setLazyTickRate(20);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.filtering = new ServerFilteringBehaviour(this).withCallback($ -> this.invVersionTracker.reset());
        behaviours.add(this.filtering);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
        CapManipulationBehaviourBase.InterfaceProvider towardBlockFacing = (w, p, s) -> new BlockFace(p, DirectedDirectionalBlock.getTargetDirection(s));
        this.observedInventory = (InvManipulationBehaviour)new InvManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedInventory);
        this.observedTank = (TankManipulationBehaviour)new TankManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedTank);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            return;
        }
        BlockState state = this.getBlockState();
        if (this.turnOffTicks > 0) {
            --this.turnOffTicks;
            if (this.turnOffTicks == 0) {
                this.level.scheduleTick(this.worldPosition, state.getBlock(), 1);
            }
        }
        if (!this.isActive()) {
            return;
        }
        BlockPos targetPos = this.worldPosition.relative(SmartObserverBlock.getTargetDirection(state));
        Block block = this.level.getBlockState(targetPos).getBlock();
        if (!this.filtering.getFilter().isEmpty() && block.asItem() != null && this.filtering.test(new ItemStack((ItemLike)block))) {
            this.activate(3);
            return;
        }
        TransportedItemStackHandlerBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)this.level, targetPos, TransportedItemStackHandlerBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.handleCenteredProcessingOnAllItems(0.45f, stack -> {
                if (!this.filtering.test(stack.stack) || this.turnOffTicks == 6) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                this.activate();
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
            return;
        }
        FluidTransportBehaviour fluidBehaviour = BlockEntityBehaviour.get((BlockGetter)this.level, targetPos, FluidTransportBehaviour.TYPE);
        if (fluidBehaviour != null) {
            for (Direction side : Iterate.directions) {
                PipeConnection.Flow flow = fluidBehaviour.getFlow(side);
                if (flow == null || !flow.inbound || !flow.complete || !this.filtering.test(flow.fluid)) continue;
                this.activate();
                return;
            }
            return;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(targetPos);
        if (blockEntity instanceof ChainConveyorBlockEntity) {
            ChainConveyorBlockEntity ccbe = (ChainConveyorBlockEntity)blockEntity;
            for (ChainConveyorPackage box : ccbe.getLoopingPackages()) {
                if (!this.filtering.test(box.item)) continue;
                this.activate();
                return;
            }
            return;
        }
        if (this.observedInventory.hasInventory()) {
            boolean skipInv = this.invVersionTracker.stillWaiting(this.observedInventory);
            this.invVersionTracker.awaitNewVersion(this.observedInventory);
            if (skipInv && this.sustainSignal) {
                this.turnOffTicks = 6;
            }
            if (!skipInv) {
                this.sustainSignal = false;
                if (!((InvManipulationBehaviour)this.observedInventory.simulate()).extract().isEmpty()) {
                    this.sustainSignal = true;
                    this.activate();
                    return;
                }
            }
        }
        if (!((TankManipulationBehaviour)this.observedTank.simulate()).extractAny().isEmpty()) {
            this.activate();
        }
    }

    public void activate() {
        this.activate(6);
    }

    public void activate(int ticks) {
        BlockState state = this.getBlockState();
        this.turnOffTicks = ticks;
        if (((Boolean)state.getValue((Property)SmartObserverBlock.POWERED)).booleanValue()) {
            return;
        }
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)SmartObserverBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        this.level.updateNeighborsAt(this.worldPosition, state.getBlock(), null);
    }

    private boolean isActive() {
        return true;
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        view.putInt("TurnOff", this.turnOffTicks);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.turnOffTicks = view.getIntOr("TurnOff", 0);
    }
}

