/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.thresholdSwitch;

import com.google.common.base.Predicate;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import com.zurrtum.create.content.redstone.DirectedDirectionalBlock;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchBlock;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.TankManipulationBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.ticks.TickPriority;

public class ThresholdSwitchBlockEntity
extends SmartBlockEntity {
    public int onWhenAbove = 128;
    public int offWhenBelow = 64;
    public int currentMinLevel;
    public int currentLevel = -1;
    public int currentMaxLevel;
    public boolean inStacks;
    private boolean redstoneState = false;
    private boolean inverted = false;
    private boolean poweredAfterDelay = false;
    private ServerFilteringBehaviour filtering;
    private InvManipulationBehaviour observedInventory;
    private TankManipulationBehaviour observedTank;
    private VersionedInventoryTrackerBehaviour invVersionTracker;

    public ThresholdSwitchBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.THRESHOLD_SWITCH, pos, state);
        this.setLazyTickRate(10);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.onWhenAbove = view.getIntOr("OnAboveAmount", 0);
        this.offWhenBelow = view.getIntOr("OffBelowAmount", 0);
        this.currentLevel = view.getIntOr("CurrentAmount", 0);
        this.currentMinLevel = view.getIntOr("CurrentMinAmount", 0);
        this.currentMaxLevel = view.getIntOr("CurrentMaxAmount", 0);
        this.inStacks = view.getBooleanOr("InStacks", false);
        this.redstoneState = view.getBooleanOr("Powered", false);
        this.inverted = view.getBooleanOr("Inverted", false);
        this.poweredAfterDelay = view.getBooleanOr("PoweredAfterDelay", false);
        super.read(view, clientPacket);
    }

    protected void writeCommon(ValueOutput view) {
        view.putFloat("OnAboveAmount", (float)this.onWhenAbove);
        view.putFloat("OffBelowAmount", (float)this.offWhenBelow);
        view.putBoolean("Inverted", this.inverted);
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        this.writeCommon(view);
        view.putInt("CurrentAmount", this.currentLevel);
        view.putInt("CurrentMinAmount", this.currentMinLevel);
        view.putInt("CurrentMaxAmount", this.currentMaxLevel);
        view.putBoolean("InStacks", this.inStacks);
        view.putBoolean("Powered", this.redstoneState);
        view.putBoolean("PoweredAfterDelay", this.poweredAfterDelay);
        super.write(view, clientPacket);
    }

    @Override
    public void writeSafe(ValueOutput view) {
        this.writeCommon(view);
        super.writeSafe(view);
    }

    public int getMinLevel() {
        return this.currentMinLevel;
    }

    public int getStockLevel() {
        return this.currentLevel;
    }

    public int getMaxLevel() {
        return this.currentMaxLevel;
    }

    public void updateCurrentLevel() {
        boolean changed = false;
        int prevLevel = this.currentLevel;
        int prevMaxLevel = this.currentMaxLevel;
        BlockPos target = this.getTargetPos();
        BlockEntity targetBlockEntity = this.level.getBlockEntity(target);
        this.observedInventory.findNewCapability();
        this.observedTank.findNewCapability();
        if (targetBlockEntity instanceof ThresholdSwitchObservable) {
            ThresholdSwitchObservable observable = (ThresholdSwitchObservable)targetBlockEntity;
            this.currentMinLevel = observable.getMinValue();
            this.currentLevel = observable.getCurrentValue();
            this.currentMaxLevel = observable.getMaxValue();
        } else if (this.observedInventory.hasInventory() || this.observedTank.hasInventory()) {
            int space;
            FluidStack stackInSlot;
            int slot;
            int size;
            this.currentMinLevel = 0;
            this.currentLevel = 0;
            this.currentMaxLevel = 0;
            if (this.observedInventory.hasInventory()) {
                Container inv = (Container)this.observedInventory.getInventory();
                if (this.invVersionTracker.stillWaiting(inv)) {
                    this.currentLevel = prevLevel;
                    this.currentMaxLevel = prevMaxLevel;
                } else {
                    this.invVersionTracker.awaitNewVersion(inv);
                    size = inv.getContainerSize();
                    for (slot = 0; slot < size; ++slot) {
                        stackInSlot = inv.getItem(slot);
                        int n = space = stackInSlot.isEmpty() ? 64 : inv.getMaxStackSize((ItemStack)stackInSlot);
                        if (space == 0) continue;
                        this.currentMaxLevel += space;
                        if (!this.filtering.test((ItemStack)stackInSlot)) continue;
                        this.currentLevel += stackInSlot.getCount();
                    }
                }
            }
            if (this.observedTank.hasInventory()) {
                FluidInventory tank = (FluidInventory)this.observedTank.getInventory();
                size = tank.size();
                for (slot = 0; slot < size; ++slot) {
                    stackInSlot = tank.getStack(slot);
                    space = tank.getMaxAmount(stackInSlot);
                    if (space == 0) continue;
                    this.currentMaxLevel += space;
                    if (!this.filtering.test(stackInSlot)) continue;
                    this.currentLevel += stackInSlot.getAmount();
                }
            }
        } else {
            this.currentMinLevel = -1;
            this.currentMaxLevel = -1;
            if (this.currentLevel == -1) {
                return;
            }
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)ThresholdSwitchBlock.LEVEL, (Comparable)Integer.valueOf(0)), 3);
            this.currentLevel = -1;
            this.redstoneState = false;
            this.sendData();
            this.scheduleBlockTick();
            return;
        }
        this.currentLevel = Mth.clamp((int)this.currentLevel, (int)this.currentMinLevel, (int)this.currentMaxLevel);
        changed = this.currentLevel != prevLevel;
        boolean previouslyPowered = this.redstoneState;
        if (this.redstoneState && this.currentLevel <= this.offWhenBelow) {
            this.redstoneState = false;
        } else if (!this.redstoneState && this.currentLevel >= this.onWhenAbove) {
            this.redstoneState = true;
        }
        boolean update = previouslyPowered != this.redstoneState;
        int displayLevel = 0;
        float normedLevel = (float)(this.currentLevel - this.currentMinLevel) / (float)(this.currentMaxLevel - this.currentMinLevel);
        if (this.currentLevel > 0) {
            displayLevel = (int)(1.0f + normedLevel * 4.0f);
        }
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)ThresholdSwitchBlock.LEVEL, (Comparable)Integer.valueOf(displayLevel)), update ? 3 : 2);
        if (update) {
            this.scheduleBlockTick();
        }
        if (changed || update) {
            DisplayLinkBlock.notifyGatherers((LevelAccessor)this.level, this.worldPosition);
            this.notifyUpdate();
        }
    }

    private boolean isSuitableInventory(BlockEntity be) {
        return be != null && !(be instanceof StockTickerBlockEntity) && !(ItemHelper.getInventory(this.level, be.getBlockPos(), null, be, null) instanceof ProcessingInventory);
    }

    public BlockPos getTargetPos() {
        return this.worldPosition.relative(ThresholdSwitchBlock.getTargetDirection(this.getBlockState()));
    }

    public ItemStack getDisplayItemForScreen() {
        BlockPos target = this.getTargetPos();
        return new ItemStack((ItemLike)this.level.getBlockState(target).getBlock());
    }

    public ThresholdType getTypeOfCurrentTarget() {
        if (this.observedInventory.hasInventory()) {
            return ThresholdType.ITEM;
        }
        if (this.observedTank.hasInventory()) {
            return ThresholdType.FLUID;
        }
        if (this.level.getBlockEntity(this.getTargetPos()) instanceof ThresholdSwitchObservable) {
            return ThresholdType.CUSTOM;
        }
        return ThresholdType.UNSUPPORTED;
    }

    protected void scheduleBlockTick() {
        Block block = this.getBlockState().getBlock();
        if (!this.level.getBlockTicks().willTickThisTick(this.worldPosition, (Object)block)) {
            this.level.scheduleTick(this.worldPosition, block, 2, TickPriority.NORMAL);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.level.isClientSide()) {
            return;
        }
        this.updateCurrentLevel();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.filtering = new ServerFilteringBehaviour(this).withCallback($ -> {
            this.updateCurrentLevel();
            this.invVersionTracker.reset();
        });
        behaviours.add(this.filtering);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
        CapManipulationBehaviourBase.InterfaceProvider towardBlockFacing = (w, p, s) -> new BlockFace(p, DirectedDirectionalBlock.getTargetDirection(s));
        this.observedInventory = (InvManipulationBehaviour)((InvManipulationBehaviour)new InvManipulationBehaviour(this, towardBlockFacing).bypassSidedness()).withFilter((Predicate<BlockEntity>)((Predicate)this::isSuitableInventory));
        behaviours.add(this.observedInventory);
        this.observedTank = (TankManipulationBehaviour)new TankManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedTank);
    }

    public float getLevelForDisplay() {
        return this.currentLevel == -1 ? 0.0f : (float)this.currentLevel;
    }

    public boolean getState() {
        return this.redstoneState;
    }

    public boolean shouldBePowered() {
        return this.inverted != this.redstoneState;
    }

    public void updatePowerAfterDelay() {
        this.poweredAfterDelay = this.shouldBePowered();
        this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        this.sendData();
    }

    public boolean isPowered() {
        return this.poweredAfterDelay;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        if (inverted == this.inverted) {
            return;
        }
        this.inverted = inverted;
        this.updatePowerAfterDelay();
    }

    public static enum ThresholdType {
        UNSUPPORTED,
        ITEM,
        FLUID,
        CUSTOM;

    }
}

