/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.schematics.cannon;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.zurrtum.create.content.schematics.SchematicPrinter;
import com.zurrtum.create.content.schematics.cannon.LaunchedItem;
import com.zurrtum.create.content.schematics.cannon.MaterialChecklist;
import com.zurrtum.create.content.schematics.cannon.SchematicannonInventory;
import com.zurrtum.create.content.schematics.cannon.SchematicannonMenu;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.component.SchematicannonOptions;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.config.CSchematics;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureSchematicannonPacket;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class SchematicannonBlockEntity
extends SmartBlockEntity
implements MenuProvider {
    public static final int NEIGHBOUR_CHECKING = 100;
    public static final int MAX_ANCHOR_DISTANCE = 256;
    public SchematicannonInventory inventory;
    public boolean sendUpdate;
    public boolean dontUpdateChecklist;
    public int neighbourCheckCooldown;
    public SchematicPrinter printer;
    public ItemStack missingItem;
    public boolean positionNotLoaded;
    public boolean hasCreativeCrate;
    private int printerCooldown;
    private int skipsLeft;
    private boolean blockSkipped;
    public BlockPos previousTarget;
    public LinkedHashSet<Container> attachedInventories;
    public List<LaunchedItem> flyingBlocks;
    public MaterialChecklist checklist;
    public int remainingFuel;
    public float bookPrintingProgress;
    public float schematicProgress;
    public String statusMsg;
    public State state;
    public int blocksPlaced;
    public int blocksToPlace;
    public int replaceMode;
    public boolean skipMissing;
    public boolean replaceBlockEntities;
    public boolean firstRenderTick;
    public float defaultYaw;

    public SchematicannonBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.SCHEMATICANNON, pos, state);
        this.setLazyTickRate(30);
        this.attachedInventories = new LinkedHashSet();
        this.flyingBlocks = new LinkedList<LaunchedItem>();
        this.inventory = new SchematicannonInventory(this);
        this.statusMsg = "idle";
        this.state = State.STOPPED;
        this.replaceMode = 2;
        this.checklist = new MaterialChecklist();
        this.printer = new SchematicPrinter();
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
        super.preRemoveSideEffects(pos, oldState);
        Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.inventory);
    }

    public void findInventories() {
        this.hasCreativeCrate = false;
        this.attachedInventories.clear();
        for (Direction facing : Iterate.directions) {
            Container capability;
            BlockEntity blockEntity;
            BlockPos target = this.worldPosition.relative(facing);
            if (!this.level.isLoaded(target)) continue;
            BlockState state = this.level.getBlockState(target);
            if (state.is((Block)AllBlocks.CREATIVE_CRATE)) {
                this.hasCreativeCrate = true;
            }
            if ((blockEntity = this.level.getBlockEntity(target)) == null || (capability = ItemHelper.getInventory(this.level, target, state, blockEntity, facing)) == null) continue;
            this.attachedInventories.add(capability);
        }
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        if (!clientPacket) {
            this.inventory.read(view);
        }
        this.statusMsg = view.getStringOr("Status", "");
        this.schematicProgress = view.getFloatOr("Progress", 0.0f);
        this.bookPrintingProgress = view.getFloatOr("PaperProgress", 0.0f);
        this.remainingFuel = view.getIntOr("RemainingFuel", 0);
        this.state = view.read("State", State.CODEC).orElse(State.STOPPED);
        this.blocksPlaced = view.getIntOr("AmountPlaced", 0);
        this.blocksToPlace = view.getIntOr("AmountToPlace", 0);
        this.missingItem = null;
        view.read("MissingItem", ItemStack.OPTIONAL_CODEC).ifPresent(item -> {
            this.missingItem = item;
        });
        view.read("Options", SchematicannonOptions.CODEC).ifPresentOrElse(options -> {
            this.replaceMode = options.replaceMode();
            this.skipMissing = options.skipMissing();
            this.replaceBlockEntities = options.replaceBlockEntities();
        }, () -> {
            this.replaceMode = 2;
            this.skipMissing = true;
            this.replaceBlockEntities = false;
        });
        view.child("Printer").ifPresent(data -> this.printer.read((ValueInput)data, clientPacket));
        view.childrenList("FlyingBlocks").ifPresent(this::readFlyingBlocks);
        this.defaultYaw = view.getFloatOr("DefaultYaw", 0.0f);
        super.read(view, clientPacket);
    }

    protected void readFlyingBlocks(ValueInput.ValueInputList list) {
        if (list.isEmpty()) {
            this.flyingBlocks.clear();
            return;
        }
        boolean pastDead = false;
        int i = -1;
        for (ValueInput item : list) {
            ++i;
            LaunchedItem launched = LaunchedItem.from(item, this.blockHolderGetter());
            BlockPos readBlockPos = launched.target;
            if (this.level == null || !this.level.isClientSide()) {
                this.flyingBlocks.add(launched);
                continue;
            }
            while (!(pastDead || this.flyingBlocks.isEmpty() || this.flyingBlocks.getFirst().target.equals((Object)readBlockPos))) {
                this.flyingBlocks.removeFirst();
            }
            pastDead = true;
            if (i < this.flyingBlocks.size()) continue;
            this.flyingBlocks.add(launched);
        }
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        if (!clientPacket) {
            this.inventory.write(view);
            if (this.state == State.RUNNING) {
                view.putBoolean("Running", true);
            }
        }
        view.putFloat("Progress", this.schematicProgress);
        view.putFloat("PaperProgress", this.bookPrintingProgress);
        view.putInt("RemainingFuel", this.remainingFuel);
        view.putString("Status", this.statusMsg);
        view.store("State", State.CODEC, (Object)this.state);
        view.putInt("AmountPlaced", this.blocksPlaced);
        view.putInt("AmountToPlace", this.blocksToPlace);
        if (this.missingItem != null) {
            view.store("MissingItem", ItemStack.OPTIONAL_CODEC, (Object)this.missingItem);
        }
        view.store("Options", SchematicannonOptions.CODEC, (Object)new SchematicannonOptions(this.replaceMode, this.skipMissing, this.replaceBlockEntities));
        this.printer.write(view.child("Printer"));
        ValueOutput.ValueOutputList blocks = view.childrenList("FlyingBlocks");
        for (LaunchedItem b : this.flyingBlocks) {
            b.write(blocks.addChild());
        }
        view.putFloat("DefaultYaw", this.defaultYaw);
        super.write(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.state != State.STOPPED && this.neighbourCheckCooldown-- <= 0) {
            this.neighbourCheckCooldown = 100;
            this.findInventories();
        }
        this.firstRenderTick = true;
        this.previousTarget = this.printer.getCurrentTarget();
        this.tickFlyingBlocks();
        if (this.level.isClientSide()) {
            return;
        }
        this.tickPaperPrinter();
        this.refillFuelIfPossible();
        this.skipsLeft = 1000;
        this.blockSkipped = true;
        while (this.blockSkipped && this.skipsLeft-- > 0) {
            this.tickPrinter();
        }
        this.schematicProgress = 0.0f;
        if (this.blocksToPlace > 0) {
            this.schematicProgress = (float)this.blocksPlaced / (float)this.blocksToPlace;
        }
        if (this.sendUpdate) {
            this.sendUpdate = false;
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 6);
        }
    }

    public CSchematics config() {
        return AllConfigs.server().schematics;
    }

    protected void tickPrinter() {
        ItemRequirement requirement;
        ItemStack blueprint = this.inventory.getItem(0);
        this.blockSkipped = false;
        if (blueprint.isEmpty() && !this.statusMsg.equals("idle") && this.inventory.getItem(1).isEmpty()) {
            this.state = State.STOPPED;
            this.statusMsg = "idle";
            this.sendUpdate = true;
            return;
        }
        if (this.state == State.STOPPED) {
            if (this.printer.isLoaded()) {
                this.resetPrinter();
            }
            return;
        }
        if (this.state == State.PAUSED && !this.positionNotLoaded && this.missingItem == null && this.remainingFuel > 0) {
            return;
        }
        if (!this.printer.isLoaded()) {
            this.initializePrinter(blueprint);
            return;
        }
        if (this.printerCooldown > 0) {
            --this.printerCooldown;
            return;
        }
        if (this.remainingFuel <= 0 && !this.hasCreativeCrate) {
            this.refillFuelIfPossible();
            if (this.remainingFuel <= 0) {
                this.state = State.PAUSED;
                this.statusMsg = "noGunpowder";
                this.sendUpdate = true;
                return;
            }
        }
        if (this.hasCreativeCrate) {
            this.remainingFuel = 0;
            if (this.missingItem != null) {
                this.missingItem = null;
                this.state = State.RUNNING;
            }
        }
        if (this.missingItem == null && !this.positionNotLoaded) {
            if (!this.printer.advanceCurrentPos()) {
                this.finishedPrinting();
                return;
            }
            this.sendUpdate = true;
        }
        if (!this.level.isLoaded(this.printer.getCurrentTarget())) {
            this.positionNotLoaded = true;
            this.statusMsg = "targetNotLoaded";
            this.state = State.PAUSED;
            return;
        }
        if (this.positionNotLoaded) {
            this.positionNotLoaded = false;
            this.state = State.RUNNING;
        }
        if ((requirement = this.printer.getCurrentRequirement()).isInvalid() || !this.printer.shouldPlaceCurrent(this.level, this::shouldPlace)) {
            this.sendUpdate = !this.statusMsg.equals("searching");
            this.statusMsg = "searching";
            this.blockSkipped = true;
            return;
        }
        List<ItemRequirement.StackRequirement> requiredItems = requirement.getRequiredItems();
        if (!requirement.isEmpty()) {
            for (ItemRequirement.StackRequirement required : requiredItems) {
                if (this.grabItemsFromAttachedInventories(required, true)) continue;
                if (this.skipMissing) {
                    this.statusMsg = "skipping";
                    this.blockSkipped = true;
                    if (this.missingItem != null) {
                        this.missingItem = null;
                        this.state = State.RUNNING;
                    }
                    return;
                }
                this.missingItem = required.stack;
                this.state = State.PAUSED;
                this.statusMsg = "missingBlock";
                return;
            }
            for (ItemRequirement.StackRequirement required : requiredItems) {
                this.grabItemsFromAttachedInventories(required, false);
            }
        }
        this.state = State.RUNNING;
        ItemStack icon = requirement.isEmpty() || requiredItems.isEmpty() ? ItemStack.EMPTY : requiredItems.get((int)0).stack;
        this.printer.handleCurrentTarget((target, blockState, blockEntity) -> {
            this.statusMsg = blockState.getBlock() != Blocks.AIR ? "placing" : "clearing";
            this.launchBlockOrBelt(target, icon, blockState, blockEntity);
        }, (target, entity) -> {
            this.statusMsg = "placing";
            this.launchEntity(target, icon, entity);
        });
        this.printerCooldown = (Integer)this.config().schematicannonDelay.get();
        --this.remainingFuel;
        this.sendUpdate = true;
        this.missingItem = null;
    }

    public int getShotsPerGunpowder() {
        return this.hasCreativeCrate ? 0 : (Integer)this.config().schematicannonShotsPerGunpowder.get();
    }

    protected void initializePrinter(ItemStack blueprint) {
        if (!blueprint.has(AllDataComponents.SCHEMATIC_ANCHOR)) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicInvalid";
            this.sendUpdate = true;
            return;
        }
        if (!((Boolean)blueprint.getOrDefault(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)false)).booleanValue()) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicNotPlaced";
            this.sendUpdate = true;
            return;
        }
        this.printer.loadSchematic(blueprint, this.level, true);
        if (this.printer.isErrored()) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicErrored";
            this.inventory.setItem(0, ItemStack.EMPTY);
            this.inventory.setItem(1, AllItems.EMPTY_SCHEMATIC.getDefaultInstance());
            this.printer.resetSchematic();
            this.sendUpdate = true;
            return;
        }
        if (this.printer.isWorldEmpty()) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicExpired";
            this.inventory.setItem(0, ItemStack.EMPTY);
            this.inventory.setItem(1, AllItems.EMPTY_SCHEMATIC.getDefaultInstance());
            this.printer.resetSchematic();
            this.sendUpdate = true;
            return;
        }
        if (!this.printer.getAnchor().closerThan((Vec3i)this.getBlockPos(), 256.0)) {
            this.state = State.STOPPED;
            this.statusMsg = "targetOutsideRange";
            this.printer.resetSchematic();
            this.sendUpdate = true;
            return;
        }
        this.state = State.PAUSED;
        this.statusMsg = "ready";
        this.updateChecklist();
        this.sendUpdate = true;
        this.blocksToPlace += this.blocksPlaced;
    }

    protected ItemStack getItemForBlock(BlockState blockState) {
        Item item = blockState.getBlock().asItem();
        return item == Items.AIR ? ItemStack.EMPTY : item.getDefaultInstance();
    }

    protected boolean grabItemsFromAttachedInventories(ItemRequirement.StackRequirement required, boolean simulate) {
        boolean success;
        block5: {
            Container cap;
            Container cap2;
            if (this.hasCreativeCrate) {
                return true;
            }
            this.attachedInventories.removeIf(Objects::isNull);
            ItemRequirement.ItemUseType usage = required.usage;
            if (usage == ItemRequirement.ItemUseType.DAMAGE) {
                for (Container cap3 : this.attachedInventories) {
                    if (cap3 == null || !(simulate ? !cap3.count(stack -> required.matches((ItemStack)stack) && stack.isDamageableItem(), 1).isEmpty() : cap3.update(stack -> required.matches((ItemStack)stack) && stack.isDamageableItem(), stack -> {
                        int maxDamage;
                        int damage = stack.getDamageValue() + 1;
                        if (damage >= (maxDamage = stack.getMaxDamage())) {
                            return ItemStack.EMPTY;
                        }
                        stack.setDamageValue(damage);
                        return stack;
                    }))) continue;
                    return true;
                }
                return false;
            }
            int remaining = required.stack.getCount();
            Iterator cap3 = this.attachedInventories.iterator();
            while (cap3.hasNext() && ((cap2 = (Container)cap3.next()) == null || (remaining -= cap2.countAll(required::matches, remaining)) != 0)) {
            }
            boolean bl = success = remaining == 0;
            if (simulate || !success) break block5;
            remaining = required.stack.getCount();
            Iterator iterator = this.attachedInventories.iterator();
            while (iterator.hasNext() && ((cap = (Container)iterator.next()) == null || (remaining -= cap.extractAll(required::matches, remaining)) != 0)) {
            }
        }
        return success;
    }

    public void finishedPrinting() {
        if (this.replaceMode == ConfigureSchematicannonPacket.Option.REPLACE_EMPTY.ordinal()) {
            this.printer.sendBlockUpdates(this.level);
        }
        this.inventory.setItem(0, ItemStack.EMPTY);
        this.inventory.setItem(1, new ItemStack((ItemLike)AllItems.EMPTY_SCHEMATIC, this.inventory.getItem(1).getCount() + 1));
        this.state = State.STOPPED;
        this.statusMsg = "finished";
        this.resetPrinter();
        AllSoundEvents.SCHEMATICANNON_FINISH.playOnServer(this.level, (Vec3i)this.worldPosition);
        this.sendUpdate = true;
    }

    protected void resetPrinter() {
        this.printer.resetSchematic();
        this.missingItem = null;
        this.sendUpdate = true;
        this.schematicProgress = 0.0f;
        this.blocksPlaced = 0;
        this.blocksToPlace = 0;
    }

    protected boolean shouldPlace(BlockPos pos, BlockState state, BlockEntity be, BlockState toReplace, BlockState toReplaceOther, boolean isNormalCube) {
        if (pos.closerThan((Vec3i)this.getBlockPos(), 2.0)) {
            return false;
        }
        if (!this.replaceBlockEntities && (toReplace.hasBlockEntity() || toReplaceOther != null && toReplaceOther.hasBlockEntity())) {
            return false;
        }
        if (this.shouldIgnoreBlockState(state, be)) {
            return false;
        }
        boolean placingAir = state.isAir();
        if (this.replaceMode == 3) {
            return true;
        }
        if (this.replaceMode == 2 && !placingAir) {
            return true;
        }
        if (!(this.replaceMode != 1 || !isNormalCube && (toReplace.isRedstoneConductor((BlockGetter)this.level, pos) || toReplaceOther != null && toReplaceOther.isRedstoneConductor((BlockGetter)this.level, pos)) || placingAir)) {
            return true;
        }
        return this.replaceMode == 0 && !toReplace.isRedstoneConductor((BlockGetter)this.level, pos) && (toReplaceOther == null || !toReplaceOther.isRedstoneConductor((BlockGetter)this.level, pos)) && !placingAir;
    }

    protected boolean shouldIgnoreBlockState(BlockState state, BlockEntity be) {
        if (state.getBlock() == Blocks.STRUCTURE_VOID) {
            return true;
        }
        ItemRequirement requirement = ItemRequirement.of(state, be);
        if (requirement.isEmpty()) {
            return false;
        }
        if (requirement.isInvalid()) {
            return false;
        }
        if (state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) && state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER) {
            return true;
        }
        if (state.hasProperty((Property)BlockStateProperties.BED_PART) && state.getValue((Property)BlockStateProperties.BED_PART) == BedPart.HEAD) {
            return true;
        }
        if (state.getBlock() instanceof PistonHeadBlock) {
            return true;
        }
        if (state.is((Block)AllBlocks.BELT)) {
            return state.getValue(BeltBlock.PART) == BeltPart.MIDDLE;
        }
        return false;
    }

    protected void tickFlyingBlocks() {
        LinkedList<LaunchedItem> toRemove = new LinkedList<LaunchedItem>();
        for (LaunchedItem b : this.flyingBlocks) {
            if (!b.update(this.level)) continue;
            toRemove.add(b);
        }
        this.flyingBlocks.removeAll(toRemove);
    }

    protected void refillFuelIfPossible() {
        if (this.hasCreativeCrate) {
            return;
        }
        if (this.remainingFuel > this.getShotsPerGunpowder()) {
            this.remainingFuel = this.getShotsPerGunpowder();
            this.sendUpdate = true;
            return;
        }
        if (this.remainingFuel > 0) {
            return;
        }
        ItemStack gunpowder = this.inventory.getItem(4);
        if (!gunpowder.isEmpty()) {
            gunpowder.shrink(1);
        } else {
            boolean externalGunpowderFound = false;
            for (Container cap : this.attachedInventories) {
                if (cap == null || cap.extractAll(stack -> this.inventory.canPlaceItem(4, (ItemStack)stack), 1) == 0) continue;
                externalGunpowderFound = true;
                break;
            }
            if (!externalGunpowderFound) {
                return;
            }
        }
        this.remainingFuel += this.getShotsPerGunpowder();
        if (this.statusMsg.equals("noGunpowder")) {
            if (this.blocksPlaced > 0) {
                this.state = State.RUNNING;
            }
            this.statusMsg = "ready";
        }
        this.sendUpdate = true;
    }

    protected void tickPaperPrinter() {
        boolean outputFull;
        int BookInput = 2;
        int BookOutput = 3;
        ItemStack blueprint = this.inventory.getItem(0);
        ItemStack paper = this.inventory.getItem(BookInput);
        ItemStack output = this.inventory.getItem(BookOutput);
        boolean bl = outputFull = output.getCount() == output.getMaxStackSize();
        if (this.printer.isErrored()) {
            return;
        }
        if (!this.printer.isLoaded()) {
            if (!blueprint.isEmpty()) {
                this.initializePrinter(blueprint);
            }
            return;
        }
        if (paper.isEmpty() || outputFull) {
            if (this.bookPrintingProgress != 0.0f) {
                this.sendUpdate = true;
            }
            this.bookPrintingProgress = 0.0f;
            this.dontUpdateChecklist = false;
            return;
        }
        if (this.bookPrintingProgress >= 1.0f) {
            this.bookPrintingProgress = 0.0f;
            if (!this.dontUpdateChecklist) {
                this.updateChecklist();
            }
            this.dontUpdateChecklist = true;
            this.inventory.setItem(BookInput, ItemStack.EMPTY);
            ItemStack stack = paper.is((Item)AllItems.CLIPBOARD) ? this.checklist.createWrittenClipboard() : this.checklist.createWrittenBook();
            stack.setCount(this.inventory.getItem(BookOutput).getCount() + 1);
            this.inventory.setItem(BookOutput, stack);
            this.inventory.setChanged();
            this.sendUpdate = true;
            return;
        }
        this.bookPrintingProgress += 0.05f;
        this.sendUpdate = true;
    }

    public static BlockState stripBeltIfNotLast(BlockState blockState) {
        BeltPart part = (BeltPart)((Object)blockState.getValue(BeltBlock.PART));
        if (part == BeltPart.MIDDLE) {
            return Blocks.AIR.defaultBlockState();
        }
        boolean isLastSegment = false;
        Direction facing = (Direction)blockState.getValue((Property)BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope = (BeltSlope)((Object)blockState.getValue(BeltBlock.SLOPE));
        boolean positive = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        boolean start = part == BeltPart.START;
        boolean end = part == BeltPart.END;
        switch (slope) {
            case DOWNWARD: {
                isLastSegment = start;
                break;
            }
            case UPWARD: {
                isLastSegment = end;
                break;
            }
            default: {
                boolean bl = isLastSegment = positive && end || !positive && start;
            }
        }
        if (isLastSegment) {
            return blockState;
        }
        return (BlockState)AllBlocks.SHAFT.defaultBlockState().setValue((Property)AbstractSimpleShaftBlock.AXIS, (Comparable)(slope == BeltSlope.SIDEWAYS ? Direction.Axis.Y : facing.getClockWise().getAxis()));
    }

    /*
     * Unable to fully structure code
     */
    protected void launchBlockOrBelt(BlockPos target, ItemStack icon, BlockState blockState, BlockEntity blockEntity) {
        block4: {
            if (!blockState.is((Block)AllBlocks.BELT)) break block4;
            blockState = SchematicannonBlockEntity.stripBeltIfNotLast(blockState);
            if (!(blockEntity instanceof BeltBlockEntity)) ** GOTO lbl-1000
            bbe = (BeltBlockEntity)blockEntity;
            if (blockState.is((Block)AllBlocks.BELT)) {
                casings = new BeltBlockEntity.CasingType[bbe.beltLength];
                Arrays.fill((Object[])casings, (Object)BeltBlockEntity.CasingType.NONE);
                currentPos = target;
                for (i = 0; i < bbe.beltLength && (currentState = bbe.getLevel().getBlockState(currentPos)).getBlock() instanceof BeltBlock && (var11_12 = bbe.getLevel().getBlockEntity(currentPos)) instanceof BeltBlockEntity; ++i) {
                    beltAtSegment = (BeltBlockEntity)var11_12;
                    casings[i] = beltAtSegment.casing;
                    currentPos = BeltBlock.nextSegmentPosition(currentState, currentPos, blockState.getValue(BeltBlock.PART) != BeltPart.END);
                }
                this.launchBelt(target, blockState, bbe.beltLength, casings);
            } else if (blockState != Blocks.AIR.defaultBlockState()) {
                this.launchBlock(target, icon, blockState, null);
            }
            return;
        }
        data = BlockHelper.prepareBlockEntityData(this.level, blockState, blockEntity);
        this.launchBlock(target, icon, blockState, data);
    }

    protected void launchBelt(BlockPos target, BlockState state, int length, BeltBlockEntity.CasingType[] casings) {
        ++this.blocksPlaced;
        ItemStack connector = AllItems.BELT_CONNECTOR.getDefaultInstance();
        this.flyingBlocks.add(new LaunchedItem.ForBelt(this.getBlockPos(), target, connector, state, casings));
        this.playFiringSound();
    }

    protected void launchBlock(BlockPos target, ItemStack stack, BlockState state, @Nullable CompoundTag data) {
        if (!state.isAir()) {
            ++this.blocksPlaced;
        }
        this.flyingBlocks.add(new LaunchedItem.ForBlockState(this.getBlockPos(), target, stack, state, data));
        this.playFiringSound();
    }

    protected void launchEntity(BlockPos target, ItemStack stack, Entity entity) {
        ++this.blocksPlaced;
        this.flyingBlocks.add(new LaunchedItem.ForEntity(this.getBlockPos(), target, stack, entity));
        this.playFiringSound();
    }

    public void playFiringSound() {
        AllSoundEvents.SCHEMATICANNON_LAUNCH_BLOCK.playOnServer(this.level, (Vec3i)this.worldPosition);
    }

    public SchematicannonMenu createMenu(int id, Inventory inv, Player player, RegistryFriendlyByteBuf extraData) {
        this.sendToMenu(extraData);
        return new SchematicannonMenu(id, inv, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)"create.gui.schematicannon.title");
    }

    public void updateChecklist() {
        this.checklist.required.clear();
        this.checklist.damageRequired.clear();
        this.checklist.blocksNotLoaded = false;
        if (this.printer.isLoaded() && !this.printer.isErrored()) {
            this.blocksToPlace = this.blocksPlaced;
            this.blocksToPlace += this.printer.markAllBlockRequirements(this.checklist, this.level, this::shouldPlace);
            this.printer.markAllEntityRequirements(this.checklist);
        }
        this.checklist.gathered.clear();
        this.findInventories();
        for (Container cap : this.attachedInventories) {
            if (cap == null) continue;
            for (ItemStack stack : cap) {
                this.checklist.collect(stack);
            }
        }
        this.sendUpdate = true;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.findInventories();
    }

    protected void applyImplicitComponents(DataComponentGetter componentInput) {
        SchematicannonOptions options = (SchematicannonOptions)componentInput.getOrDefault(AllDataComponents.SCHEMATICANNON_OPTIONS, (Object)new SchematicannonOptions(2, true, false));
        this.replaceMode = options.replaceMode();
        this.skipMissing = options.skipMissing();
        this.replaceBlockEntities = options.replaceBlockEntities();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(AllDataComponents.SCHEMATICANNON_OPTIONS, (Object)new SchematicannonOptions(this.replaceMode, this.skipMissing, this.replaceBlockEntities));
    }

    public static enum State implements StringRepresentable
    {
        STOPPED,
        PAUSED,
        RUNNING;

        public static final Codec<State> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(State::values);
        }
    }
}

