/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.bogey;

import com.zurrtum.create.AllBogeyStyles;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.content.trains.bogey.BogeyStyle;
import com.zurrtum.create.foundation.blockEntity.CachedRenderBBBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBogeyBlockEntity
extends CachedRenderBBBlockEntity {
    public static final String BOGEY_STYLE_KEY = "BogeyStyle";
    public static final String BOGEY_DATA_KEY = "BogeyData";
    private CompoundTag bogeyData;
    LerpedFloat virtualAnimation = LerpedFloat.angular();

    public AbstractBogeyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract BogeyStyle getDefaultStyle();

    public CompoundTag getBogeyData() {
        if (this.bogeyData == null || !this.bogeyData.contains(BOGEY_STYLE_KEY)) {
            this.bogeyData = this.createBogeyData();
        }
        return this.bogeyData;
    }

    public void setBogeyData(@NotNull CompoundTag newData) {
        if (!newData.contains(BOGEY_STYLE_KEY)) {
            newData.store(BOGEY_STYLE_KEY, Identifier.CODEC, (Object)this.getDefaultStyle().id);
        }
        this.bogeyData = newData;
    }

    public void setBogeyStyle(@NotNull BogeyStyle style) {
        this.getBogeyData().store(BOGEY_STYLE_KEY, Identifier.CODEC, (Object)style.id);
        this.markUpdated();
    }

    @NotNull
    public BogeyStyle getStyle() {
        CompoundTag data = this.getBogeyData();
        Identifier currentStyle = (Identifier)data.read(BOGEY_STYLE_KEY, Identifier.CODEC).orElseThrow();
        BogeyStyle style = AllBogeyStyles.BOGEY_STYLES.get(currentStyle);
        if (style == null) {
            this.setBogeyStyle(this.getDefaultStyle());
            return this.getStyle();
        }
        return style;
    }

    protected void saveAdditional(ValueOutput view) {
        CompoundTag data = this.getBogeyData();
        if (data != null) {
            view.store(BOGEY_DATA_KEY, CompoundTag.CODEC, (Object)data);
        }
        super.saveAdditional(view);
    }

    protected void loadAdditional(ValueInput view) {
        this.bogeyData = view.read(BOGEY_DATA_KEY, CompoundTag.CODEC).orElseGet(this::createBogeyData);
        super.loadAdditional(view);
    }

    private CompoundTag createBogeyData() {
        CompoundTag nbt = new CompoundTag();
        nbt.store(BOGEY_STYLE_KEY, Identifier.CODEC, (Object)this.getDefaultStyle().id);
        boolean upsideDown = false;
        Block block = this.getBlockState().getBlock();
        if (block instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogeyBlock = (AbstractBogeyBlock)block;
            upsideDown = bogeyBlock.isUpsideDown(this.getBlockState());
        }
        nbt.putBoolean("UpsideDown", upsideDown);
        return nbt;
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(2.0);
    }

    public float getVirtualAngle(float partialTicks) {
        return this.virtualAnimation.getValue(partialTicks);
    }

    public void animate(float distanceMoved) {
        BlockState blockState = this.getBlockState();
        Block block = blockState.getBlock();
        if (!(block instanceof AbstractBogeyBlock)) {
            return;
        }
        AbstractBogeyBlock type = (AbstractBogeyBlock)block;
        double angleDiff = (double)(360.0f * distanceMoved) / (Math.PI * 2 * type.getWheelRadius());
        double newWheelAngle = ((double)this.virtualAnimation.getValue() - angleDiff) % 360.0;
        this.virtualAnimation.setValue(newWheelAngle);
    }

    private void markUpdated() {
        this.setChanged();
        Level level = this.getLevel();
        if (level != null) {
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }
}

