/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.display;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.LevelTickAccess;

public class FlapDisplayBlock
extends HorizontalKineticBlock
implements IBE<FlapDisplayBlockEntity>,
IWrenchable,
ICogWheel,
SimpleWaterloggedBlock {
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public FlapDisplayBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)HORIZONTAL_FACING)).getAxis();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{UP, DOWN, BlockStateProperties.WATERLOGGED}));
    }

    @Override
    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.MEDIUM;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction face = context.getClickedFace();
        BlockPos clickedPos = context.getClickedPos();
        BlockPos placedOnPos = clickedPos.relative(face.getOpposite());
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(placedOnPos);
        BlockState stateForPlacement = this.defaultBlockState();
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        if (blockState.getBlock() != this || context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            stateForPlacement = super.getStateForPlacement(context);
        } else {
            Direction otherFacing = (Direction)blockState.getValue((Property)HORIZONTAL_FACING);
            stateForPlacement = (BlockState)stateForPlacement.setValue((Property)HORIZONTAL_FACING, (Comparable)otherFacing);
        }
        return this.updateColumn(level, clickedPos, (BlockState)stateForPlacement.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER)), true);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (placementHelper.matchesItem(stack)) {
            return placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand);
        }
        FlapDisplayBlockEntity flapBE = (FlapDisplayBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (flapBE == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if ((flapBE = flapBE.getController()) == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        double yCoord = hitResult.getLocation().add((Vec3)Vec3.atLowerCornerOf((Vec3i)hitResult.getDirection().getOpposite().getUnitVec3i()).scale((double)0.125)).y;
        int lineIndex = flapBE.getLineIndexAt(yCoord);
        if (stack.isEmpty()) {
            if (!flapBE.isSpeedRequirementFulfilled()) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            flapBE.applyTextManually(lineIndex, null);
            return InteractionResult.SUCCESS;
        }
        if (stack.getItem() == Items.GLOW_INK_SAC) {
            if (!level.isClientSide()) {
                level.playSound(null, pos, SoundEvents.INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                flapBE.setGlowing(lineIndex);
            }
            return InteractionResult.SUCCESS;
        }
        boolean display = stack.getItem() == Items.NAME_TAG && stack.has(DataComponents.CUSTOM_NAME) || stack.is((Item)AllItems.CLIPBOARD);
        DyeColor dye = AllItemTags.getDyeColor(stack);
        if (!display && dye == null) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (dye == null && !flapBE.isSpeedRequirementFulfilled()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        Component customName = (Component)stack.get(DataComponents.CUSTOM_NAME);
        if (display) {
            if (stack.is((Item)AllItems.CLIPBOARD)) {
                List<ClipboardEntry> entries = ClipboardEntry.getLastViewedEntries(stack);
                int line = lineIndex;
                for (ClipboardEntry entry : entries) {
                    for (String string : entry.text.getString().split("\n")) {
                        flapBE.applyTextManually(line++, (Component)Component.literal((String)string));
                    }
                }
                return InteractionResult.SUCCESS;
            }
            flapBE.applyTextManually(lineIndex, customName);
        }
        if (dye != null) {
            level.playSound(null, pos, SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            flapBE.setColour(lineIndex, dye);
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.FLAP_DISPLAY.get((Direction)pState.getValue((Property)HORIZONTAL_FACING));
    }

    @Override
    public Class<FlapDisplayBlockEntity> getBlockEntityClass() {
        return FlapDisplayBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends FlapDisplayBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.FLAP_DISPLAY;
    }

    @Override
    public float getParticleTargetRadius() {
        return 0.85f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 0.75f;
    }

    private BlockState updateColumn(Level level, BlockPos pos, BlockState state, boolean present) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        Direction.Axis axis = this.getConnectionAxis(state);
        for (Direction connection : Iterate.directionsInAxis(Direction.Axis.Y)) {
            boolean connect = true;
            block1: for (Direction movement : Iterate.directionsInAxis(axis)) {
                currentPos.set((Vec3i)pos);
                for (int i = 0; i < 1000 && level.isLoaded((BlockPos)currentPos); ++i) {
                    BlockState other1 = currentPos.equals((Object)pos) ? state : level.getBlockState((BlockPos)currentPos);
                    BlockState other2 = level.getBlockState(currentPos.relative(connection));
                    boolean col1 = this.canConnect(state, other1);
                    boolean col2 = this.canConnect(state, other2);
                    currentPos.move(movement);
                    if (!col1 && !col2) continue block1;
                    if (col1 && col2) continue;
                    connect = false;
                    break block1;
                }
            }
            state = FlapDisplayBlock.setConnection(state, connection, connect);
        }
        return state;
    }

    @Override
    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.onPlace(pState, pLevel, pPos, pOldState, pIsMoving);
        if (pOldState.getBlock() == this) {
            return;
        }
        LevelTickAccess blockTicks = pLevel.getBlockTicks();
        if (!blockTicks.hasScheduledTick(pPos, (Object)this)) {
            pLevel.scheduleTick(pPos, (Block)this, 1);
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pState.getBlock() != this) {
            return;
        }
        BlockPos belowPos = pPos.relative(Direction.fromAxisAndDirection((Direction.Axis)this.getConnectionAxis(pState), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
        BlockState belowState = pLevel.getBlockState(belowPos);
        if (!this.canConnect(pState, belowState)) {
            KineticBlockEntity.switchToBlockState((Level)pLevel, pPos, this.updateColumn((Level)pLevel, pPos, pState, true));
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, FlapDisplayBlockEntity::updateControllerStatus);
    }

    public BlockState updateShape(BlockState state, LevelReader pLevel, ScheduledTickAccess tickView, BlockPos pCurrentPos, Direction pDirection, BlockPos pNeighborPos, BlockState pNeighborState, RandomSource random) {
        return this.updatedShapeInner(state, pDirection, pNeighborState, pLevel, tickView, pCurrentPos);
    }

    private BlockState updatedShapeInner(BlockState state, Direction pDirection, BlockState pNeighborState, LevelReader pLevel, ScheduledTickAccess tickView, BlockPos pCurrentPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            tickView.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(pLevel));
        }
        if (!this.canConnect(state, pNeighborState)) {
            return FlapDisplayBlock.setConnection(state, pDirection, false);
        }
        if (pDirection.getAxis() == this.getConnectionAxis(state)) {
            return (BlockState)this.withPropertiesOf(pNeighborState).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)));
        }
        return FlapDisplayBlock.setConnection(state, pDirection, FlapDisplayBlock.getConnection(pNeighborState, pDirection.getOpposite()));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    protected boolean canConnect(BlockState state, BlockState other) {
        return other.getBlock() == this && state.getValue((Property)HORIZONTAL_FACING) == other.getValue((Property)HORIZONTAL_FACING);
    }

    protected Direction.Axis getConnectionAxis(BlockState state) {
        return ((Direction)state.getValue((Property)HORIZONTAL_FACING)).getClockWise().getAxis();
    }

    public static boolean getConnection(BlockState state, Direction side) {
        BooleanProperty property = side == Direction.DOWN ? DOWN : (side == Direction.UP ? UP : null);
        return property != null && (Boolean)state.getValue((Property)property) != false;
    }

    public static BlockState setConnection(BlockState state, Direction side, boolean connect) {
        BooleanProperty property;
        Object object = side == Direction.DOWN ? DOWN : (property = side == Direction.UP ? UP : null);
        if (property != null) {
            state = (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(connect));
        }
        return state;
    }

    public void affectNeighborsAfterRemoval(BlockState pState, ServerLevel pLevel, BlockPos pPos, boolean pIsMoving) {
        super.affectNeighborsAfterRemoval(pState, pLevel, pPos, pIsMoving);
        if (pIsMoving) {
            return;
        }
        for (Direction d : Iterate.directionsInAxis(this.getConnectionAxis(pState))) {
            BlockPos relative = pPos.relative(d);
            BlockState adjacent = pLevel.getBlockState(relative);
            if (!this.canConnect(pState, adjacent)) continue;
            KineticBlockEntity.switchToBlockState((Level)pLevel, relative, this.updateColumn((Level)pLevel, relative, adjacent, false));
        }
    }

    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return stack -> stack.is((Item)AllItems.DISPLAY_BOARD);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return state -> state.is((Block)AllBlocks.DISPLAY_BOARD);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.getLocation(), ((Direction)state.getValue((Property)HORIZONTAL_FACING)).getAxis(), (Direction dir) -> world.getBlockState(pos.relative(dir)).canBeReplaced());
            return directions.isEmpty() ? PlacementOffset.fail() : PlacementOffset.success((Vec3i)pos.relative(directions.getFirst()), s -> AllBlocks.DISPLAY_BOARD.updateColumn(world, pos.relative((Direction)directions.getFirst()), (BlockState)s.setValue(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)HORIZONTAL_FACING))), true));
        }
    }
}

