/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.display;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.behaviour.display.DisplayHolder;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayBlock;
import com.zurrtum.create.content.trains.display.FlapDisplayLayout;
import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import com.zurrtum.create.foundation.utility.DynamicComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public class FlapDisplayBlockEntity
extends KineticBlockEntity
implements DisplayHolder {
    public List<FlapDisplayLayout> lines;
    public boolean isController;
    public boolean isRunning;
    public int xSize;
    public int ySize;
    public DyeColor[] colour;
    public boolean[] glowingLines;
    public boolean[] manualLines;
    private CompoundTag displayLink;

    public FlapDisplayBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.FLAP_DISPLAY, pos, state);
        this.setLazyTickRate(10);
        this.isController = false;
        this.xSize = 1;
        this.ySize = 1;
        this.colour = new DyeColor[2];
        this.manualLines = new boolean[2];
        this.glowingLines = new boolean[2];
    }

    @Override
    public CompoundTag getDisplayLinkData() {
        return this.displayLink;
    }

    @Override
    public void setDisplayLinkData(CompoundTag data) {
        this.displayLink = data;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.updateControllerStatus();
    }

    public void updateControllerStatus() {
        if (this.level.isClientSide()) {
            return;
        }
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof FlapDisplayBlock)) {
            return;
        }
        Direction leftDirection = ((Direction)blockState.getValue((Property)FlapDisplayBlock.HORIZONTAL_FACING)).getClockWise();
        boolean shouldBeController = (Boolean)blockState.getValue((Property)FlapDisplayBlock.UP) == false && this.level.getBlockState(this.worldPosition.relative(leftDirection)) != blockState;
        int newXSize = 1;
        int newYSize = 1;
        if (shouldBeController) {
            for (int xOffset = 1; xOffset < 32 && this.level.getBlockState(this.worldPosition.relative(leftDirection.getOpposite(), xOffset)) == blockState; ++xOffset) {
                ++newXSize;
            }
            for (int yOffset = 0; yOffset < 32 && ((Boolean)this.level.getBlockState(this.worldPosition.relative(Direction.DOWN, yOffset)).getValueOrElse((Property)FlapDisplayBlock.DOWN, (Comparable)Boolean.valueOf(false))).booleanValue(); ++yOffset) {
                ++newYSize;
            }
        }
        if (this.isController == shouldBeController && newXSize == this.xSize && newYSize == this.ySize) {
            return;
        }
        this.isController = shouldBeController;
        this.xSize = newXSize;
        this.ySize = newYSize;
        this.colour = Arrays.copyOf(this.colour, this.ySize * 2);
        this.glowingLines = Arrays.copyOf(this.glowingLines, this.ySize * 2);
        this.manualLines = new boolean[this.ySize * 2];
        this.lines = null;
        this.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        this.isRunning = super.isSpeedRequirementFulfilled();
        if (!(this.level.isClientSide() && this.isRunning || this.isVirtual())) {
            return;
        }
        int activeFlaps = 0;
        boolean instant = Math.abs(this.getSpeed()) > 128.0f;
        for (FlapDisplayLayout line : this.lines) {
            for (FlapDisplaySection section : line.getSections()) {
                activeFlaps += section.tick(instant, this.level.random);
            }
        }
        if (activeFlaps == 0) {
            return;
        }
        float volume = Mth.clamp((float)((float)activeFlaps / 20.0f), (float)0.25f, (float)1.5f);
        float bgVolume = Mth.clamp((float)((float)activeFlaps / 40.0f), (float)0.25f, (float)1.0f);
        BlockPos middle = this.worldPosition.relative(this.getDirection().getClockWise(), this.xSize / 2).relative(Direction.DOWN, this.ySize / 2);
        AllSoundEvents.SCROLL_VALUE.playAt(this.level, (Vec3i)middle, volume, 0.56f, false);
        this.level.playLocalSound((double)middle.getX(), (double)middle.getY(), (double)middle.getZ(), SoundEvents.CALCITE_HIT, SoundSource.BLOCKS, 0.35f * bgVolume, 1.95f, false);
    }

    @Override
    public boolean isNoisy() {
        return false;
    }

    @Override
    public boolean isSpeedRequirementFulfilled() {
        return this.isRunning;
    }

    public void applyTextManually(int lineIndex, Component componentText) {
        List<FlapDisplayLayout> lines = this.getLines();
        if (lineIndex >= lines.size()) {
            return;
        }
        FlapDisplayLayout layout = lines.get(lineIndex);
        if (!layout.isLayout("Default")) {
            layout.loadDefault(this.getMaxCharCount());
        }
        List<FlapDisplaySection> sections = layout.getSections();
        FlapDisplaySection flapDisplaySection = sections.getFirst();
        if (componentText == null) {
            this.manualLines[lineIndex] = false;
            flapDisplaySection.setText(CommonComponents.EMPTY);
            this.notifyUpdate();
            return;
        }
        this.manualLines[lineIndex] = true;
        Component text = this.isVirtual() ? componentText : DynamicComponent.parseCustomText(this.level, this.worldPosition, componentText);
        flapDisplaySection.setText(text);
        if (this.isVirtual()) {
            flapDisplaySection.refresh(true);
        } else {
            this.notifyUpdate();
        }
    }

    public void setColour(int lineIndex, DyeColor color) {
        this.colour[lineIndex] = color == DyeColor.WHITE ? null : color;
        this.notifyUpdate();
    }

    public void setGlowing(int lineIndex) {
        this.glowingLines[lineIndex] = true;
        this.notifyUpdate();
    }

    public List<FlapDisplayLayout> getLines() {
        if (this.lines == null) {
            this.initDefaultSections();
        }
        return this.lines;
    }

    public void initDefaultSections() {
        this.lines = new ArrayList<FlapDisplayLayout>();
        for (int i = 0; i < this.ySize * 2; ++i) {
            this.lines.add(new FlapDisplayLayout(this.getMaxCharCount()));
        }
    }

    public int getMaxCharCount() {
        return this.getMaxCharCount(0);
    }

    public int getMaxCharCount(int gaps) {
        return (int)(((float)this.xSize * 16.0f - 2.0f - 4.0f * (float)gaps) / 3.5f);
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        int j;
        super.write(view, clientPacket);
        this.writeDisplayLink(view);
        view.putBoolean("Controller", this.isController);
        view.putInt("XSize", this.xSize);
        view.putInt("YSize", this.ySize);
        for (j = 0; j < this.manualLines.length; ++j) {
            if (!this.manualLines[j]) continue;
            view.putBoolean("CustomLine" + j, true);
        }
        for (j = 0; j < this.glowingLines.length; ++j) {
            if (!this.glowingLines[j]) continue;
            view.putBoolean("GlowingLine" + j, true);
        }
        for (j = 0; j < this.colour.length; ++j) {
            if (this.colour[j] == null) continue;
            view.store("Dye" + j, (Codec)DyeColor.CODEC, (Object)this.colour[j]);
        }
        List<FlapDisplayLayout> lines = this.getLines();
        for (int i = 0; i < lines.size(); ++i) {
            lines.get(i).write(view.child("Display" + i));
        }
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        int i;
        super.read(view, clientPacket);
        this.readDisplayLink(view);
        boolean wasActive = this.isController;
        int prevX = this.xSize;
        int prevY = this.ySize;
        this.isController = view.getBooleanOr("Controller", false);
        this.xSize = view.getIntOr("XSize", 0);
        this.ySize = view.getIntOr("YSize", 0);
        this.manualLines = new boolean[this.ySize * 2];
        for (i = 0; i < this.ySize * 2; ++i) {
            this.manualLines[i] = view.getBooleanOr("CustomLine" + i, false);
        }
        this.glowingLines = new boolean[this.ySize * 2];
        for (i = 0; i < this.ySize * 2; ++i) {
            this.glowingLines[i] = view.getBooleanOr("GlowingLine" + i, false);
        }
        this.colour = new DyeColor[this.ySize * 2];
        for (i = 0; i < this.ySize * 2; ++i) {
            this.colour[i] = view.read("Dye" + i, (Codec)DyeColor.CODEC).orElse(null);
        }
        if (clientPacket && wasActive != this.isController || prevX != this.xSize || prevY != this.ySize) {
            this.invalidateRenderBoundingBox();
            this.lines = null;
        }
        List<FlapDisplayLayout> lines = this.getLines();
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            lines.get(i2).read(view.childOrEmpty("Display" + i2));
        }
    }

    public int getLineIndexAt(double yCoord) {
        return (int)Mth.clamp((double)Math.floor(2.0 * ((double)this.worldPosition.getY() - yCoord + 1.0)), (double)0.0, (double)(this.ySize * 2));
    }

    public FlapDisplayBlockEntity getController() {
        if (this.isController) {
            return this;
        }
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof FlapDisplayBlock)) {
            return null;
        }
        BlockPos.MutableBlockPos pos = this.getBlockPos().mutable();
        Direction side = ((Direction)blockState.getValue((Property)FlapDisplayBlock.HORIZONTAL_FACING)).getClockWise();
        for (int i = 0; i < 64; ++i) {
            BlockState other = this.level.getBlockState((BlockPos)pos);
            if (((Boolean)other.getValueOrElse((Property)FlapDisplayBlock.UP, (Comparable)Boolean.valueOf(false))).booleanValue()) {
                pos.move(Direction.UP);
                continue;
            }
            if (!((Boolean)this.level.getBlockState(pos.relative(side)).getValueOrElse((Property)FlapDisplayBlock.UP, (Comparable)Boolean.valueOf(true))).booleanValue()) {
                pos.move(side);
                continue;
            }
            BlockEntity found = this.level.getBlockEntity((BlockPos)pos);
            if (!(found instanceof FlapDisplayBlockEntity)) break;
            FlapDisplayBlockEntity flap = (FlapDisplayBlockEntity)found;
            if (!flap.isController) break;
            return flap;
        }
        return null;
    }

    @Override
    protected AABB createRenderBoundingBox() {
        AABB aabb = new AABB(this.worldPosition);
        if (!this.isController) {
            return aabb;
        }
        Vec3i normal = this.getDirection().getClockWise().getUnitVec3i();
        return aabb.expandTowards((double)(normal.getX() * this.xSize), (double)(-this.ySize), (double)(normal.getZ() * this.xSize));
    }

    public Direction getDirection() {
        return ((Direction)this.getBlockState().getValueOrElse((Property)FlapDisplayBlock.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).getOpposite();
    }

    public boolean isLineGlowing(int line) {
        return this.glowingLines[line];
    }
}

