/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.display;

import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.mutable.MutableInt;

public class FlapDisplayLayout {
    List<FlapDisplaySection> sections;
    String layoutKey;

    public FlapDisplayLayout(int maxCharCount) {
        this.loadDefault(maxCharCount);
    }

    public void loadDefault(int maxCharCount) {
        this.configure("Default", Arrays.asList(new FlapDisplaySection((float)maxCharCount * 7.0f, "alphabet", false, false)));
    }

    public boolean isLayout(String key) {
        return this.layoutKey.equals(key);
    }

    public void configure(String layoutKey, List<FlapDisplaySection> sections) {
        this.layoutKey = layoutKey;
        this.sections = sections;
    }

    public void write(ValueOutput view) {
        view.putString("Key", this.layoutKey);
        ValueOutput.ValueOutputList list = view.childrenList("Sections");
        this.sections.forEach(section -> section.write(list.addChild()));
    }

    public void read(ValueInput view) {
        String prevKey = this.layoutKey;
        this.layoutKey = view.getStringOr("Key", "");
        if (!prevKey.equals(this.layoutKey)) {
            this.sections = new ArrayList<FlapDisplaySection>();
            view.childrenListOrEmpty("Sections").forEach(section -> this.sections.add(FlapDisplaySection.load(section)));
            return;
        }
        MutableInt index = new MutableInt(0);
        view.childrenListOrEmpty("Sections").forEach(section -> this.sections.get(index.getAndIncrement()).update((ValueInput)section));
    }

    public List<FlapDisplaySection> getSections() {
        return this.sections;
    }
}

