/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.display;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class FlapDisplaySection {
    static final Map<String, String[]> LOADED_FLAP_CYCLES = new HashMap<String, String[]>();
    public static final float MONOSPACE = 7.0f;
    public static final float WIDE_MONOSPACE = 9.0f;
    float size;
    boolean singleFlap;
    public boolean hasGap;
    boolean rightAligned;
    public boolean wideFlaps;
    boolean sendTransition;
    String cycle;
    Component component;
    public String[] cyclingOptions;
    public boolean[] spinning;
    public int spinningTicks;
    public String text;

    public FlapDisplaySection(float width, String cycle, boolean singleFlap, boolean hasGap) {
        this.size = width;
        this.cycle = cycle;
        this.hasGap = hasGap;
        this.singleFlap = singleFlap;
        this.spinning = new boolean[singleFlap ? 1 : Math.max(0, (int)(width / 7.0f))];
        this.text = Strings.repeat((String)" ", (int)this.spinning.length);
        this.component = null;
    }

    public FlapDisplaySection rightAligned() {
        this.rightAligned = true;
        return this;
    }

    public FlapDisplaySection wideFlaps() {
        this.wideFlaps = true;
        return this;
    }

    public void setText(Component component) {
        this.component = component;
        this.sendTransition = true;
    }

    public void refresh(boolean transition) {
        if (this.component == null) {
            return;
        }
        Object newText = this.component.getString();
        if (!this.singleFlap) {
            if (this.rightAligned) {
                newText = ((String)newText).trim();
            }
            newText = ((String)newText).toUpperCase(Locale.ROOT);
            newText = ((String)newText).substring(0, Math.min(this.spinning.length, ((String)newText).length()));
            String whitespace = Strings.repeat((String)" ", (int)(this.spinning.length - ((String)newText).length()));
            Object object = newText = this.rightAligned ? whitespace + (String)newText : (String)newText + whitespace;
            if (!this.text.isEmpty()) {
                for (int i = 0; i < this.spinning.length; ++i) {
                    int n = i;
                    this.spinning[n] = this.spinning[n] | (transition && this.text.charAt(i) != ((String)newText).charAt(i));
                }
            }
        } else if (!this.text.isEmpty()) {
            this.spinning[0] = this.spinning[0] | (transition && !((String)newText).equals(this.text));
        }
        this.text = newText;
        this.spinningTicks = 0;
    }

    public int tick(boolean instant, RandomSource random) {
        if (this.cyclingOptions == null) {
            return 0;
        }
        int max = Math.max(4, (int)((float)this.cyclingOptions.length * 1.75f));
        if (this.spinningTicks > max) {
            return 0;
        }
        ++this.spinningTicks;
        if (this.spinningTicks <= max && this.spinningTicks < 2) {
            return this.spinningTicks == 1 ? 0 : this.spinning.length;
        }
        int spinningFlaps = 0;
        for (int i = 0; i < this.spinning.length; ++i) {
            int increasingChance = Mth.clamp((int)(8 - this.spinningTicks), (int)1, (int)10);
            boolean continueSpin = !instant && random.nextInt(increasingChance * max / 4) != 0;
            boolean bl = max > 5 || this.spinningTicks < 2;
            int n = i;
            this.spinning[n] = this.spinning[n] & (continueSpin &= bl);
            if (i > 0 && random.nextInt(3) > 0) {
                int n2 = i - 1;
                this.spinning[n2] = this.spinning[n2] & continueSpin;
            }
            if (i < this.spinning.length - 1 && random.nextInt(3) > 0) {
                int n3 = i + 1;
                this.spinning[n3] = this.spinning[n3] & continueSpin;
            }
            if (this.spinningTicks > max) {
                this.spinning[i] = false;
            }
            if (!this.spinning[i]) continue;
            ++spinningFlaps;
        }
        return spinningFlaps;
    }

    public float getSize() {
        return this.size;
    }

    public void write(ValueOutput view) {
        view.putFloat("Width", this.size);
        view.putString("Cycle", this.cycle);
        if (this.rightAligned) {
            view.putBoolean("RightAligned", true);
        }
        if (this.singleFlap) {
            view.putBoolean("SingleFlap", true);
        }
        if (this.hasGap) {
            view.putBoolean("Gap", true);
        }
        if (this.wideFlaps) {
            view.putBoolean("Wide", true);
        }
        if (this.component != null) {
            view.store("Text", ComponentSerialization.CODEC, (Object)this.component);
        }
        if (this.sendTransition) {
            view.putBoolean("Transition", true);
        }
        this.sendTransition = false;
    }

    public static FlapDisplaySection load(ValueInput view) {
        float width = view.getFloatOr("Width", 0.0f);
        String cycle = view.getStringOr("Cycle", "");
        boolean singleFlap = view.getBooleanOr("SingleFlap", false);
        boolean hasGap = view.getBooleanOr("Gap", false);
        FlapDisplaySection section = new FlapDisplaySection(width, cycle, singleFlap, hasGap);
        section.cyclingOptions = FlapDisplaySection.getFlapCycle(cycle);
        section.rightAligned = view.getBooleanOr("RightAligned", false);
        section.wideFlaps = view.getBooleanOr("Wide", false);
        view.read("Text", ComponentSerialization.CODEC).ifPresent(text -> {
            section.component = text;
            section.refresh(view.getBooleanOr("Transition", false));
        });
        return section;
    }

    public void update(ValueInput view) {
        view.read("Text", ComponentSerialization.CODEC).ifPresent(text -> {
            this.component = text;
        });
        if (this.cyclingOptions == null) {
            this.cyclingOptions = FlapDisplaySection.getFlapCycle(this.cycle);
        }
        this.refresh(view.getBooleanOr("Transition", false));
    }

    public boolean renderCharsIndividually() {
        return !this.singleFlap;
    }

    public Component getText() {
        return this.component;
    }

    public static String[] getFlapCycle(String key) {
        return LOADED_FLAP_CYCLES.computeIfAbsent(key, k -> Component.translatable((String)("create.flap_display.cycles." + key)).getString().split(";"));
    }
}

