/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllContraptionTypes;
import com.zurrtum.create.api.behaviour.interaction.ConductorBlockInteractionBehavior;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.MountedStorageManager;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.contraptions.minecart.TrainCargoManager;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.content.trains.entity.ArrivalSoundQueue;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;

public class CarriageContraption
extends Contraption {
    private Direction assemblyDirection;
    private boolean forwardControls;
    private boolean backwardControls;
    public Couple<Boolean> blockConductors;
    public Map<BlockPos, Couple<Boolean>> conductorSeats = new HashMap<BlockPos, Couple<Boolean>>();
    public ArrivalSoundQueue soundQueue;
    protected MountedStorageManager storageProxy;
    private int bogeys;
    private boolean sidewaysControls;
    private BlockPos secondBogeyPos;
    private List<BlockPos> assembledBlockConductors = new ArrayList<BlockPos>();
    public int portalCutoffMin;
    public int portalCutoffMax;
    static final MountedStorageManager fallbackStorage = new MountedStorageManager();

    public CarriageContraption() {
        this.blockConductors = Couple.create(false, false);
        this.soundQueue = new ArrivalSoundQueue();
        this.portalCutoffMin = Integer.MIN_VALUE;
        this.portalCutoffMax = Integer.MAX_VALUE;
        this.storage = new TrainCargoManager();
    }

    public void setSoundQueueOffset(int offset) {
        this.soundQueue.offset = offset;
    }

    public CarriageContraption(Direction assemblyDirection) {
        this();
        this.assemblyDirection = assemblyDirection;
        this.bogeys = 0;
    }

    @Override
    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        if (this.blocks.size() <= 1) {
            return false;
        }
        if (this.bogeys == 0) {
            return false;
        }
        if (this.bogeys > 2) {
            throw new AssemblyException((Component)Component.translatable((String)"create.train_assembly.too_many_bogeys", (Object[])new Object[]{this.bogeys}));
        }
        if (this.sidewaysControls) {
            throw new AssemblyException((Component)Component.translatable((String)"create.train_assembly.sideways_controls"));
        }
        for (BlockPos blazePos : this.assembledBlockConductors) {
            for (Direction direction : Iterate.directionsInAxis(this.assemblyDirection.getAxis())) {
                if (!this.inControl(blazePos, direction)) continue;
                this.blockConductors.set(direction != this.assemblyDirection, true);
            }
        }
        for (BlockPos seatPos : this.getSeats()) {
            for (Direction direction : Iterate.directionsInAxis(this.assemblyDirection.getAxis())) {
                if (!this.inControl(seatPos, direction)) continue;
                this.conductorSeats.computeIfAbsent(seatPos, p -> Couple.create(false, false)).set(direction != this.assemblyDirection, true);
            }
        }
        return true;
    }

    public boolean inControl(BlockPos pos, Direction direction) {
        BlockPos controlsPos = pos.relative(direction);
        if (!this.blocks.containsKey(controlsPos)) {
            return false;
        }
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)this.blocks.get(controlsPos);
        if (!info.state().is((Block)AllBlocks.TRAIN_CONTROLS)) {
            return false;
        }
        return info.state().getValue((Property)ControlsBlock.FACING) == direction.getOpposite();
    }

    public void swapStorageAfterAssembly(CarriageContraptionEntity cce) {
        Carriage carriage = cce.getCarriage();
        if (carriage.storage == null) {
            carriage.storage = (TrainCargoManager)this.storage;
            this.storage = new MountedStorageManager();
        }
        this.storageProxy = carriage.storage;
    }

    public void returnStorageForDisassembly(MountedStorageManager storage) {
        this.storage = storage;
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return false;
    }

    @Override
    protected Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture(Level world, BlockPos pos) {
        ConductorBlockInteractionBehavior conductor;
        MovingInteractionBehaviour behaviour;
        BlockState blockState = world.getBlockState(pos);
        if (ArrivalSoundQueue.isPlayable(blockState)) {
            int anchorCoord = VecHelper.getCoordinate((Vec3i)this.anchor, this.assemblyDirection.getAxis());
            int posCoord = VecHelper.getCoordinate((Vec3i)pos, this.assemblyDirection.getAxis());
            this.soundQueue.add((posCoord - anchorCoord) * this.assemblyDirection.getAxisDirection().getStep(), this.toLocalPos(pos));
        }
        if (blockState.getBlock() instanceof AbstractBogeyBlock) {
            ++this.bogeys;
            if (this.bogeys == 2) {
                this.secondBogeyPos = pos;
            }
        }
        if ((behaviour = MovingInteractionBehaviour.REGISTRY.get((StateHolder<Block, ?>)blockState)) instanceof ConductorBlockInteractionBehavior && (conductor = (ConductorBlockInteractionBehavior)behaviour).isValidConductor(blockState)) {
            this.assembledBlockConductors.add(this.toLocalPos(pos));
        }
        if (blockState.is((Block)AllBlocks.TRAIN_CONTROLS)) {
            Direction facing = (Direction)blockState.getValue((Property)ControlsBlock.FACING);
            if (facing.getAxis() != this.assemblyDirection.getAxis()) {
                this.sidewaysControls = true;
            } else {
                boolean forwards;
                boolean bl = forwards = facing == this.assemblyDirection;
                if (forwards) {
                    this.forwardControls = true;
                } else {
                    this.backwardControls = true;
                }
            }
        }
        return super.capture(world, pos);
    }

    @Override
    public void write(ValueOutput view, boolean spawnPacket) {
        super.write(view, spawnPacket);
        view.store("AssemblyDirection", (Codec)Direction.CODEC, (Object)this.getAssemblyDirection());
        view.putBoolean("FrontControls", this.forwardControls);
        view.putBoolean("BackControls", this.backwardControls);
        view.putBoolean("FrontBlazeConductor", ((Boolean)this.blockConductors.getFirst()).booleanValue());
        view.putBoolean("BackBlazeConductor", ((Boolean)this.blockConductors.getSecond()).booleanValue());
        ValueOutput.ValueOutputList list = view.childrenList("ConductorSeats");
        for (Map.Entry<BlockPos, Couple<Boolean>> entry : this.conductorSeats.entrySet()) {
            ValueOutput item = list.addChild();
            item.store("Pos", BlockPos.CODEC, (Object)entry.getKey());
            Couple<Boolean> couple = entry.getValue();
            item.putBoolean("Forward", ((Boolean)couple.getFirst()).booleanValue());
            item.putBoolean("Backward", ((Boolean)couple.getSecond()).booleanValue());
        }
        this.soundQueue.write(view);
    }

    @Override
    public void read(Level world, ValueInput view, boolean spawnData) {
        this.assemblyDirection = view.read("AssemblyDirection", (Codec)Direction.CODEC).orElse(Direction.DOWN);
        this.forwardControls = view.getBooleanOr("FrontControls", false);
        this.backwardControls = view.getBooleanOr("BackControls", false);
        this.blockConductors = Couple.create(view.getBooleanOr("FrontBlazeConductor", false), view.getBooleanOr("BackBlazeConductor", false));
        this.conductorSeats.clear();
        view.childrenListOrEmpty("ConductorSeats").forEach(item -> this.conductorSeats.put(item.read("Pos", BlockPos.CODEC).orElse(BlockPos.ZERO), Couple.create(item.getBooleanOr("Forward", false), item.getBooleanOr("Backward", false))));
        this.soundQueue.read(view);
        super.read(world, view, spawnData);
    }

    @Override
    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        return false;
    }

    @Override
    public ContraptionType getType() {
        return AllContraptionTypes.CARRIAGE;
    }

    public Direction getAssemblyDirection() {
        return this.assemblyDirection;
    }

    public boolean hasForwardControls() {
        return this.forwardControls;
    }

    public boolean hasBackwardControls() {
        return this.backwardControls;
    }

    public BlockPos getSecondBogeyPos() {
        return this.secondBogeyPos;
    }

    @Override
    public Optional<List<AABB>> getSimplifiedEntityColliders() {
        if (this.notInPortal()) {
            return super.getSimplifiedEntityColliders();
        }
        return Optional.empty();
    }

    @Override
    public boolean isHiddenInPortal(BlockPos localPos) {
        if (this.notInPortal()) {
            return super.isHiddenInPortal(localPos);
        }
        Direction facing = this.assemblyDirection;
        Direction.Axis axis = facing.getClockWise().getAxis();
        int coord = axis.choose(localPos.getZ(), localPos.getY(), localPos.getX()) * -facing.getAxisDirection().getStep();
        return !this.withinVisible(coord) || this.atSeam(coord);
    }

    public boolean isHiddenInPortal(int posAlongMovementAxis) {
        if (this.notInPortal()) {
            return false;
        }
        return !this.withinVisible(posAlongMovementAxis) || this.atSeam(posAlongMovementAxis);
    }

    public boolean notInPortal() {
        return this.portalCutoffMin == Integer.MIN_VALUE && this.portalCutoffMax == Integer.MAX_VALUE;
    }

    public boolean atSeam(BlockPos localPos) {
        Direction facing = this.assemblyDirection;
        Direction.Axis axis = facing.getClockWise().getAxis();
        int coord = axis.choose(localPos.getZ(), localPos.getY(), localPos.getX()) * -facing.getAxisDirection().getStep();
        return coord == this.portalCutoffMin || coord == this.portalCutoffMax;
    }

    public boolean withinVisible(BlockPos localPos) {
        Direction facing = this.assemblyDirection;
        Direction.Axis axis = facing.getClockWise().getAxis();
        int coord = axis.choose(localPos.getZ(), localPos.getY(), localPos.getX()) * -facing.getAxisDirection().getStep();
        return this.withinVisible(coord);
    }

    public boolean atSeam(int posAlongMovementAxis) {
        return posAlongMovementAxis == this.portalCutoffMin || posAlongMovementAxis == this.portalCutoffMax;
    }

    public boolean withinVisible(int posAlongMovementAxis) {
        return posAlongMovementAxis > this.portalCutoffMin && posAlongMovementAxis < this.portalCutoffMax;
    }

    @Override
    public MountedStorageManager getStorage() {
        return this.storageProxy == null ? fallbackStorage : this.storageProxy;
    }

    @Override
    public void writeStorage(ValueOutput view, boolean spawnPacket) {
        if (!spawnPacket) {
            return;
        }
        if (this.storageProxy != null) {
            this.storageProxy.write(view, spawnPacket);
        }
    }

    static {
        fallbackStorage.initialize();
    }
}

