/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class CarriageEntityHandler {
    public static void onEntityEnterSection(Entity entity, long oldPos, long newPos) {
        if (SectionPos.x((long)oldPos) == SectionPos.x((long)newPos) && SectionPos.z((long)oldPos) == SectionPos.z((long)newPos)) {
            return;
        }
        if (!(entity instanceof CarriageContraptionEntity)) {
            return;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
        if (!((ServerLevel)entity.level()).isPositionEntityTicking(SectionPos.of((long)newPos).center())) {
            cce.leftTickingChunks = true;
        }
    }

    public static void validateCarriageEntity(CarriageContraptionEntity entity) {
        if (!entity.isAlive()) {
            return;
        }
        Level level = entity.level();
        if (level.isClientSide()) {
            return;
        }
        if (!CarriageEntityHandler.isActiveChunk(level, entity.blockPosition())) {
            entity.leftTickingChunks = true;
        }
    }

    public static boolean isActiveChunk(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.isPositionEntityTicking(pos);
        }
        return false;
    }
}

