/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.entity;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TravellingPoint;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackGraphHelper;
import com.zurrtum.create.content.trains.graph.TrackGraphLocation;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class TrainRelocator {
    public static boolean relocate(Train train, Level level, BlockPos pos, BezierTrackPointLocation bezier, boolean bezierDirection, Vec3 lookAngle, @Nullable List<Vec3> toVisualise) {
        TrackGraphLocation graphLocation;
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!(block instanceof ITrackBlock)) {
            return false;
        }
        ITrackBlock track = (ITrackBlock)block;
        Pair<Vec3, Direction.AxisDirection> nearestTrackAxis = track.getNearestTrackAxis((BlockGetter)level, pos, blockState, lookAngle);
        TrackGraphLocation trackGraphLocation = bezier != null ? TrackGraphHelper.getBezierGraphLocationAt(level, pos, bezierDirection ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE, bezier) : (graphLocation = TrackGraphHelper.getGraphLocationAt(level, pos, nearestTrackAxis.getSecond(), nearestTrackAxis.getFirst()));
        if (graphLocation == null) {
            return false;
        }
        TrackGraph graph = graphLocation.graph;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)((Object)graphLocation.edge.getFirst()));
        TrackNode node2 = graph.locateNode((TrackNodeLocation)((Object)graphLocation.edge.getSecond()));
        TrackEdge edge = graph.getConnectionsFrom(node1).get(node2);
        if (edge == null) {
            return false;
        }
        TravellingPoint probe = new TravellingPoint(node1, node2, edge, graphLocation.position, false);
        TravellingPoint.IEdgePointListener ignoreSignals = probe.ignoreEdgePoints();
        TravellingPoint.ITurnListener ignoreTurns = probe.ignoreTurns();
        ArrayList recordedLocations = new ArrayList();
        ArrayList recordedVecs = new ArrayList();
        Consumer<TravellingPoint> recorder = tp -> {
            recordedLocations.add(Pair.of(Couple.create(tp.node1, tp.node2), tp.position));
            recordedVecs.add(tp.getPosition(graph));
        };
        TravellingPoint.ITrackSelector steer = probe.steer(TravellingPoint.SteerDirection.NONE, track.getUpNormal((BlockGetter)level, pos, blockState));
        MutableBoolean blocked = new MutableBoolean(false);
        MutableBoolean portal = new MutableBoolean(false);
        MutableInt blockingIndex = new MutableInt(0);
        train.forEachTravellingPointBackwards((tp, d) -> {
            if (blocked.booleanValue()) {
                return;
            }
            probe.travel(graph, (double)d, steer, ignoreSignals, ignoreTurns, $ -> {
                portal.setTrue();
                return true;
            });
            recorder.accept(probe);
            if (probe.blocked || portal.booleanValue()) {
                blocked.setTrue();
                return;
            }
            blockingIndex.increment();
        });
        if (level.isClientSide() && toVisualise != null && !recordedVecs.isEmpty()) {
            toVisualise.clear();
            toVisualise.add((Vec3)recordedVecs.getFirst());
        }
        for (int i = 0; i < recordedVecs.size() - 1; ++i) {
            boolean collided;
            Vec3 vec1 = (Vec3)recordedVecs.get(i);
            Vec3 vec2 = (Vec3)recordedVecs.get(i + 1);
            boolean blocking = i >= blockingIndex.intValue() - 1;
            boolean bl = collided = !blocked.booleanValue() && train.findCollidingTrain(level, vec1, vec2, (ResourceKey<Level>)level.dimension()) != null;
            if (level.isClientSide() && toVisualise != null) {
                toVisualise.add(vec2);
            }
            if (!collided && !blocking) continue;
            return false;
        }
        if (blocked.booleanValue()) {
            return false;
        }
        if (toVisualise != null) {
            return true;
        }
        train.leaveStation();
        train.derailed = false;
        train.navigation.waitingForSignal = null;
        train.occupiedSignalBlocks.clear();
        train.graph = graph;
        train.speed = 0.0;
        train.migratingPoints.clear();
        train.cancelStall();
        if (train.navigation.destination != null) {
            train.navigation.cancelNavigation();
        }
        train.forEachTravellingPoint(tp -> {
            Pair last = (Pair)recordedLocations.removeLast();
            tp.node1 = (TrackNode)((Couple)last.getFirst()).getFirst();
            tp.node2 = (TrackNode)((Couple)last.getFirst()).getSecond();
            tp.position = (Double)last.getSecond();
            tp.edge = graph.getConnectionsFrom(tp.node1).get(tp.node2);
        });
        for (Carriage carriage : train.carriages) {
            carriage.updateContraptionAnchors();
        }
        train.status.successfulMigration();
        train.collectInitiallyOccupiedSignalBlocks();
        return true;
    }
}

