/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.observer;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.graph.TrackNodeLocation;
import com.zurrtum.create.content.trains.signal.SignalPropagator;
import com.zurrtum.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class TrackObserver
extends SingleBlockEntityEdgePoint {
    private int activated = 0;
    private FilterItemStack filter = FilterItemStack.empty();
    private UUID currentTrain = null;

    @Override
    public void blockEntityAdded(BlockEntity blockEntity, boolean front) {
        super.blockEntityAdded(blockEntity, front);
        ServerFilteringBehaviour filteringBehaviour = BlockEntityBehaviour.get(blockEntity, ServerFilteringBehaviour.TYPE);
        if (filteringBehaviour != null) {
            this.setFilterAndNotify(blockEntity.getLevel(), filteringBehaviour.getFilter());
        }
    }

    @Override
    public void tick(MinecraftServer server, TrackGraph graph, boolean preTrains) {
        super.tick(server, graph, preTrains);
        if (this.isActivated()) {
            --this.activated;
        }
        if (!this.isActivated()) {
            this.currentTrain = null;
        }
    }

    public void setFilterAndNotify(Level level, ItemStack filter) {
        this.filter = FilterItemStack.of(filter.copy());
        this.notifyTrains(level);
    }

    private void notifyTrains(Level level) {
        TrackGraph graph = Create.RAILWAYS.sided((LevelAccessor)level).getGraph((TrackNodeLocation)((Object)this.edgeLocation.getFirst()));
        if (graph == null) {
            return;
        }
        TrackEdge edge = graph.getConnection(this.edgeLocation.map(graph::locateNode));
        if (edge == null) {
            return;
        }
        SignalPropagator.notifyTrains(graph, edge);
    }

    public FilterItemStack getFilter() {
        return this.filter;
    }

    public UUID getCurrentTrain() {
        return this.currentTrain;
    }

    public boolean isActivated() {
        return this.activated > 0;
    }

    public void keepAlive(Train train) {
        this.activated = 8;
        this.currentTrain = train.id;
    }

    @Override
    public void read(ValueInput view, boolean migration, DimensionPalette dimensions) {
        super.read(view, migration, dimensions);
        this.activated = view.getIntOr("Activated", 0);
        this.filter = view.read("Filter", FilterItemStack.CODEC).orElseGet(FilterItemStack::empty);
        this.currentTrain = view.read("TrainId", UUIDUtil.CODEC).orElse(null);
    }

    @Override
    public <T> void decode(DynamicOps<T> ops, T input, boolean migration, DimensionPalette dimensions) {
        super.decode(ops, input, migration, dimensions);
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        this.activated = ((Number)ops.getNumberValue(map.get("Activated")).getOrThrow()).intValue();
        this.filter = FilterItemStack.CODEC.parse(ops, map.get("Filter")).result().orElseGet(FilterItemStack::empty);
        this.currentTrain = UUIDUtil.CODEC.parse(ops, map.get("TrainId")).result().orElse(null);
    }

    @Override
    public void write(ValueOutput view, DimensionPalette dimensions) {
        super.write(view, dimensions);
        view.putInt("Activated", this.activated);
        view.store("Filter", FilterItemStack.CODEC, (Object)this.filter);
        if (this.currentTrain != null) {
            view.store("TrainId", UUIDUtil.CODEC, (Object)this.currentTrain);
        }
    }

    @Override
    public <T> DataResult<T> encode(DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        DataResult<T> prefix = super.encode(ops, empty, dimensions);
        RecordBuilder map = ops.mapBuilder();
        map.add("Activated", ops.createInt(this.activated));
        map.add("Filter", (Object)this.filter, FilterItemStack.CODEC);
        if (this.currentTrain != null) {
            map.add("TrainId", (Object)this.currentTrain, (Encoder)UUIDUtil.CODEC);
        }
        return map.build(prefix);
    }
}

