/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.zurrtum.create.content.trains.schedule.destination.ScheduleInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ScheduleEntry {
    public static final StreamCodec<RegistryFriendlyByteBuf, ScheduleEntry> STREAM_CODEC = StreamCodec.composite(ScheduleInstruction.STREAM_CODEC, entry -> entry.instruction, CatnipStreamCodecBuilders.list(CatnipStreamCodecBuilders.list(ScheduleWaitCondition.STREAM_CODEC)), entry -> entry.conditions, ScheduleEntry::new);
    public ScheduleInstruction instruction;
    public List<List<ScheduleWaitCondition>> conditions;

    public ScheduleEntry() {
        this.conditions = new ArrayList<List<ScheduleWaitCondition>>();
    }

    public ScheduleEntry(ScheduleInstruction instruction, List<List<ScheduleWaitCondition>> conditions) {
        this.instruction = instruction;
        this.conditions = conditions;
    }

    public ScheduleEntry clone(HolderLookup.Provider registries) {
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "ScheduleEntry", Create.LOGGER);){
            TagValueOutput writeView = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)registries);
            this.write((ValueOutput)writeView);
            ValueInput readView = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)registries, (CompoundTag)writeView.buildResult());
            ScheduleEntry scheduleEntry = ScheduleEntry.read(readView);
            return scheduleEntry;
        }
    }

    public void write(ValueOutput view) {
        this.instruction.write(view.child("Instruction"));
        if (!this.instruction.supportsConditions()) {
            return;
        }
        ValueOutput.ValueOutputList outer = view.childrenList("Conditions");
        this.conditions.forEach(column -> {
            ValueOutput.ValueOutputList list = outer.addChild().childrenList("Column");
            column.forEach(condition -> condition.write(list.addChild()));
        });
    }

    public static <T> DataResult<T> encode(ScheduleEntry input, DynamicOps<T> ops, T empty) {
        RecordBuilder map = ops.mapBuilder();
        map.add("Instruction", ScheduleInstruction.encode(input.instruction, ops, empty));
        if (!input.instruction.supportsConditions()) {
            return map.build(empty);
        }
        ListBuilder outer = ops.listBuilder();
        input.conditions.forEach(column -> {
            ListBuilder list = ops.listBuilder();
            column.forEach(condition -> list.add(ScheduleWaitCondition.encode(condition, ops, empty)));
            outer.add(list.build(empty));
        });
        map.add("Conditions", outer.build(empty));
        return map.build(empty);
    }

    public static ScheduleEntry read(ValueInput view) {
        ScheduleEntry entry = new ScheduleEntry();
        entry.instruction = ScheduleInstruction.read(view.childOrEmpty("Instruction"));
        entry.conditions = new ArrayList<List<ScheduleWaitCondition>>();
        if (entry.instruction.supportsConditions()) {
            view.childrenListOrEmpty("Conditions").forEach(column -> entry.conditions.add(column.childrenListOrEmpty("Column").stream().map(ScheduleWaitCondition::read).collect(Collectors.toList())));
        }
        return entry;
    }

    public static <T> ScheduleEntry decode(DynamicOps<T> ops, T input) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        ScheduleEntry entry = new ScheduleEntry();
        entry.instruction = ScheduleInstruction.decode(ops, map.get("Instruction"));
        entry.conditions = new ArrayList<List<ScheduleWaitCondition>>();
        if (entry.instruction.supportsConditions()) {
            ((Consumer)ops.getList(map.get("Conditions")).getOrThrow()).accept(column -> entry.conditions.add(((Stream)ops.getStream(column).getOrThrow()).map(item -> ScheduleWaitCondition.decode(ops, item)).collect(Collectors.toList())));
        }
        return entry;
    }
}

