/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule;

import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.foundation.gui.menu.HeldItemGhostItemMenu;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ScheduleMenu
extends HeldItemGhostItemMenu {
    public boolean slotsActive = true;
    public int targetSlotsActive = 1;
    static final int slots = 2;

    public ScheduleMenu(int id, Inventory inv, ItemStack contentHolder) {
        super(AllMenuTypes.SCHEDULE, id, inv, contentHolder);
    }

    @Override
    protected ItemStackHandler createGhostInventory() {
        return new ItemStackHandler(2);
    }

    @Override
    protected boolean allowRepeats() {
        return true;
    }

    @Override
    protected void addSlots() {
        this.addPlayerSlots(46, 140);
        for (int i = 0; i < 2; ++i) {
            this.addSlot(new InactiveItemHandlerSlot(this.ghostInventory, i, i, 54 + 20 * i, 88));
        }
    }

    @Override
    protected void addPlayerSlots(int x, int y) {
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.addSlot(new InactiveSlot((Container)this.playerInventory, hotbarSlot, x + hotbarSlot * 18, y + 58));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new InactiveSlot((Container)this.playerInventory, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
    }

    @Override
    protected void saveData(ItemStack contentHolder) {
    }

    class InactiveItemHandlerSlot
    extends Slot {
        private final int targetIndex;

        public InactiveItemHandlerSlot(Container itemHandler, int targetIndex, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.targetIndex = targetIndex;
        }

        public boolean isActive() {
            return ScheduleMenu.this.slotsActive && this.targetIndex < ScheduleMenu.this.targetSlotsActive;
        }
    }

    class InactiveSlot
    extends Slot {
        public InactiveSlot(Container pContainer, int pIndex, int pX, int pY) {
            super(pContainer, pIndex, pX, pY);
        }

        public boolean isActive() {
            return ScheduleMenu.this.slotsActive;
        }
    }
}

