/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.condition.LazyTickedScheduleCondition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.Level;

public abstract class CargoThresholdCondition
extends LazyTickedScheduleCondition {
    public CargoThresholdCondition(Identifier id) {
        super(id, 20);
        this.data.putString("Threshold", "10");
    }

    @Override
    public boolean lazyTickCompletion(Level level, Train train, CompoundTag context) {
        int lastChecked = context.contains("LastChecked") ? context.getIntOr("LastChecked", 0) : -1;
        int status = 0;
        for (Carriage carriage : train.carriages) {
            status += carriage.storage.getVersion();
        }
        if (status == lastChecked) {
            return false;
        }
        context.putInt("LastChecked", status);
        return this.test(level, train, context);
    }

    protected void requestStatusToUpdate(int amount, CompoundTag context) {
        context.putInt("CurrentDisplay", amount);
        super.requestStatusToUpdate(context);
    }

    protected int getLastDisplaySnapshot(CompoundTag context) {
        if (!context.contains("CurrentDisplay")) {
            return -1;
        }
        return context.getIntOr("CurrentDisplay", 0);
    }

    protected abstract boolean test(Level var1, Train var2, CompoundTag var3);

    public Ops getOperator() {
        return this.enumData("Operator", Ops.class);
    }

    public int getThreshold() {
        try {
            return Integer.parseInt(this.textData("Threshold"));
        }
        catch (NumberFormatException e) {
            this.data.putString("Threshold", "0");
            return 0;
        }
    }

    public int getMeasure() {
        return this.intData("Measure");
    }

    public static enum Ops {
        GREATER(">"),
        LESS("<"),
        EQUAL("=");

        public final String formatted;

        private Ops(String formatted) {
            this.formatted = formatted;
        }

        public boolean test(int current, int target) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (current > target) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (current == target) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> current < target;
            };
        }
    }
}

