/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.condition;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.AllSchedules;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.ScheduleDataEntry;
import com.zurrtum.create.content.trains.schedule.destination.NbtReadContext;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueInputContextHelper;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class ScheduleWaitCondition
extends ScheduleDataEntry {
    public static final StreamCodec<RegistryFriendlyByteBuf, ScheduleWaitCondition> STREAM_CODEC = StreamCodec.of(ScheduleWaitCondition::encode, ScheduleWaitCondition::decode);

    public ScheduleWaitCondition(Identifier id) {
        super(id);
    }

    public abstract boolean tickCompletion(Level var1, Train var2, CompoundTag var3);

    protected void requestStatusToUpdate(CompoundTag context) {
        context.putInt("StatusVersion", context.getIntOr("StatusVersion", 0) + 1);
    }

    public final void write(ValueOutput view) {
        view.store("Id", Identifier.CODEC, (Object)this.id);
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "ScheduleWaitCondition", Create.LOGGER);){
            TagValueOutput writeView = new TagValueOutput((ProblemReporter)logging, ((TagValueOutput)view).ops, this.data);
            this.writeAdditional((ValueOutput)writeView);
            view.store("Data", CompoundTag.CODEC, (Object)writeView.buildResult());
        }
    }

    public static <T> DataResult<T> encode(ScheduleWaitCondition input, DynamicOps<T> ops, T empty) {
        RecordBuilder map = ops.mapBuilder();
        map.add("Id", (Object)input.id, (Encoder)Identifier.CODEC);
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "ScheduleWaitCondition", Create.LOGGER);){
            TagValueOutput view = new TagValueOutput((ProblemReporter)logging, ops, input.data);
            input.writeAdditional((ValueOutput)view);
            map.add("Data", (Object)view.buildResult(), (Encoder)CompoundTag.CODEC);
        }
        return map.build(empty);
    }

    public static ScheduleWaitCondition read(ValueInput view) {
        Identifier location = view.read("Id", Identifier.CODEC).orElse(null);
        ScheduleWaitCondition condition = AllSchedules.createScheduleWaitCondition(location);
        if (condition == null) {
            return ScheduleWaitCondition.fallback(location);
        }
        ValueInput data = view.childOrEmpty("Data");
        condition.readAdditional(data);
        condition.data = view.read("Data", CompoundTag.CODEC).orElseGet(CompoundTag::new);
        return condition;
    }

    public static <T> ScheduleWaitCondition decode(DynamicOps<T> ops, T input) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        Identifier location = Identifier.CODEC.parse(ops, map.get("Id")).result().orElse(null);
        ScheduleWaitCondition condition = AllSchedules.createScheduleWaitCondition(location);
        if (condition == null) {
            return ScheduleWaitCondition.fallback(location);
        }
        condition.data = CompoundTag.CODEC.parse(ops, map.get("Data")).result().orElseGet(CompoundTag::new);
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "ScheduleWaitCondition", Create.LOGGER);){
            TagValueInput view = new TagValueInput((ProblemReporter)logging, (ValueInputContextHelper)new NbtReadContext(ops), condition.data);
            condition.readAdditional((ValueInput)view);
        }
        return condition;
    }

    private static ScheduleWaitCondition fallback(Identifier location) {
        Create.LOGGER.warn("Could not parse waiting condition type: {}", (Object)location);
        return null;
    }

    private static void encode(RegistryFriendlyByteBuf buf, ScheduleWaitCondition value) {
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "ScheduleWaitCondition", Create.LOGGER);){
            TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)buf.registryAccess());
            value.write((ValueOutput)view);
            buf.writeNbt((Tag)view.buildResult());
        }
    }

    private static ScheduleWaitCondition decode(RegistryFriendlyByteBuf buf) {
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(() -> "ScheduleWaitCondition", Create.LOGGER);){
            ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)buf.registryAccess(), (CompoundTag)buf.readNbt());
            ScheduleWaitCondition scheduleWaitCondition = ScheduleWaitCondition.read(view);
            return scheduleWaitCondition;
        }
    }

    public abstract MutableComponent getWaitingStatus(Level var1, Train var2, CompoundTag var3);
}

