/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.zurrtum.create.content.trains.station.GlobalStation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class StationUnloadedCondition
extends ScheduleWaitCondition {
    public StationUnloadedCondition(Identifier id) {
        super(id);
    }

    @Override
    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        GlobalStation currentStation = train.getCurrentStation();
        if (currentStation == null) {
            return false;
        }
        ResourceKey<Level> stationDim = currentStation.getBlockEntityDimension();
        MinecraftServer server = level.getServer();
        if (server == null) {
            return false;
        }
        ServerLevel stationLevel = server.getLevel(stationDim);
        if (stationLevel == null) {
            return false;
        }
        return !stationLevel.isPositionEntityTicking(currentStation.getBlockEntityPos());
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, Train train, CompoundTag tag) {
        return Component.translatable((String)"create.schedule.condition.unloaded.status");
    }
}

