/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.schedule.condition;

import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.Level;

public class TimeOfDayCondition
extends ScheduleWaitCondition {
    public TimeOfDayCondition(Identifier id) {
        super(id);
        this.data.putInt("Hour", 8);
        this.data.putInt("Rotation", 5);
    }

    @Override
    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        int targetTicks;
        int maxTickDiff = 40;
        int targetHour = this.intData("Hour");
        int targetMinute = this.intData("Minute");
        int dayTime = (int)(level.getDayTime() % (long)this.getRotation());
        int diff = dayTime - (targetTicks = (int)(((double)((targetHour + 18) % 24 * 1000) + Math.ceil((float)targetMinute / 60.0f * 1000.0f)) % (double)this.getRotation()));
        return diff >= 0 && maxTickDiff >= diff;
    }

    public int getRotation() {
        int index = this.intData("Rotation");
        return switch (index) {
            case 9 -> 250;
            case 8 -> 500;
            case 7 -> 750;
            case 6 -> 1000;
            case 5 -> 2000;
            case 4 -> 3000;
            case 3 -> 4000;
            case 2 -> 6000;
            case 1 -> 12000;
            default -> 24000;
        };
    }

    public MutableComponent getDigitalDisplay(int hour, int minute, boolean doubleDigitHrs) {
        int hour12raw = hour % 12 == 0 ? 12 : hour % 12;
        Object hr12 = doubleDigitHrs ? this.twoDigits(hour12raw) : "" + hour12raw;
        Object hr24 = doubleDigitHrs ? this.twoDigits(hour) : "" + hour;
        return Component.translatable((String)"create.schedule.condition.time_of_day.digital_format", (Object[])new Object[]{hr12, hr24, this.twoDigits(minute), hour > 11 ? Component.translatable((String)"create.generic.daytime.pm") : Component.translatable((String)"create.generic.daytime.am")});
    }

    public String twoDigits(int t) {
        return t < 10 ? "0" + t : "" + t;
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, Train train, CompoundTag tag) {
        int targetHour = this.intData("Hour");
        int targetMinute = this.intData("Minute");
        long timeOfDay = level.getDayTime();
        int dayTime = (int)(timeOfDay % (long)this.getRotation());
        int targetTicks = (int)(((double)((targetHour + 18) % 24 * 1000) + Math.ceil((float)targetMinute / 60.0f * 1000.0f)) % (double)this.getRotation());
        int diff = targetTicks - dayTime;
        if (diff < 0) {
            diff += this.getRotation();
        }
        int departureTime = (int)(timeOfDay + (long)diff) % 24000;
        int departingHour = (departureTime / 1000 + 6) % 24;
        int departingMinute = departureTime % 1000 * 60 / 1000;
        return Component.translatable((String)"create.schedule.condition.time_of_day.status").append((Component)this.getDigitalDisplay(departingHour, departingMinute, false));
    }
}

